/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.runners;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.runners.ScriptService;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.utils.IdUtils;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@KestraTest
class ScriptServiceTest {
    public static final Pattern COMMAND_PATTERN_CAPTURE_LOCAL_PATH = Pattern.compile("my command with an internal storage file: (.*)");
    @Inject
    private TestRunContextFactory runContextFactory;

    ScriptServiceTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void replaceInternalStorage() throws IOException {
        String tenant = IdUtils.create();
        RunContext runContext = this.runContextFactory.of("id", "namespace", tenant);
        String command = ScriptService.replaceInternalStorage((RunContext)runContext, null, (boolean)false);
        Assertions.assertThat((String)command).isEqualTo("");
        command = ScriptService.replaceInternalStorage((RunContext)runContext, (String)"my command", (boolean)false);
        Assertions.assertThat((String)command).isEqualTo("my command");
        Path path = ScriptServiceTest.createFile(tenant, "file");
        String internalStorageUri = "kestra://some/file.txt";
        File localFile = null;
        try {
            command = ScriptService.replaceInternalStorage((RunContext)runContext, (String)("my command with an internal storage file: " + internalStorageUri), (boolean)false);
            java.util.regex.Matcher matcher = COMMAND_PATTERN_CAPTURE_LOCAL_PATH.matcher(command);
            Assertions.assertThat((boolean)matcher.matches()).isTrue();
            Path absoluteLocalFilePath = Path.of(matcher.group(1), new String[0]);
            localFile = absoluteLocalFilePath.toFile();
            Assertions.assertThat((boolean)localFile.exists()).isTrue();
            command = ScriptService.replaceInternalStorage((RunContext)runContext, (String)("my command with an internal storage file: " + internalStorageUri), (boolean)true);
            matcher = COMMAND_PATTERN_CAPTURE_LOCAL_PATH.matcher(command);
            Assertions.assertThat((boolean)matcher.matches()).isTrue();
            String relativePath = matcher.group(1);
            Assertions.assertThat((String)relativePath).doesNotStartWith((CharSequence)"/");
            Assertions.assertThat((boolean)runContext.workingDir().resolve(Path.of(relativePath, new String[0])).toFile().exists()).isTrue();
        }
        finally {
            localFile.delete();
            path.toFile().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void replaceInternalStorageUnicode() throws IOException {
        String tenant = IdUtils.create();
        RunContext runContext = this.runContextFactory.of("id", "namespace", tenant);
        Path path = ScriptServiceTest.createFile(tenant, "file-\u9f8d");
        String internalStorageUri = "kestra://some/file-\u9f8d.txt";
        File localFile = null;
        try {
            String command = ScriptService.replaceInternalStorage((RunContext)runContext, (String)("my command with an internal storage file: " + internalStorageUri), (boolean)false);
            java.util.regex.Matcher matcher = COMMAND_PATTERN_CAPTURE_LOCAL_PATH.matcher(command);
            Assertions.assertThat((boolean)matcher.matches()).isTrue();
            Path absoluteLocalFilePath = Path.of(matcher.group(1), new String[0]);
            localFile = absoluteLocalFilePath.toFile();
            Assertions.assertThat((boolean)localFile.exists()).isTrue();
        }
        finally {
            localFile.delete();
            path.toFile().delete();
        }
    }

    @Test
    void uploadInputFiles() throws IOException {
        String tenant = IdUtils.create();
        RunContext runContext = this.runContextFactory.of("id", "namespace", tenant);
        Path path = ScriptServiceTest.createFile(tenant, "file");
        ArrayList<File> filesToDelete = new ArrayList<File>();
        String internalStorageUri = "kestra://some/file.txt";
        try {
            String wdir = "/my/wd";
            List commands = ScriptService.replaceInternalStorage((RunContext)runContext, Map.of("workingDir", wdir), List.of("my command with an internal storage file: " + internalStorageUri, "my command with some additional var usage: {{ workingDir }}"), (boolean)false);
            Assertions.assertThat((List)commands).isNotEmpty();
            MatcherAssert.assertThat((Object)((String)commands.getFirst()), (Matcher)Matchers.not((Matcher)Matchers.is((Object)("my command with an internal storage file: " + internalStorageUri))));
            java.util.regex.Matcher matcher = COMMAND_PATTERN_CAPTURE_LOCAL_PATH.matcher((CharSequence)commands.getFirst());
            Assertions.assertThat((boolean)matcher.matches()).isTrue();
            File file = Path.of(matcher.group(1), new String[0]).toFile();
            Assertions.assertThat((boolean)file.exists()).isTrue();
            filesToDelete.add(file);
            Assertions.assertThat((String)((String)commands.get(1))).isEqualTo("my command with some additional var usage: " + wdir);
            commands = ScriptService.replaceInternalStorage((RunContext)runContext, Collections.emptyMap(), List.of("my command with an internal storage file: " + internalStorageUri), (boolean)true);
            matcher = COMMAND_PATTERN_CAPTURE_LOCAL_PATH.matcher((CharSequence)commands.getFirst());
            Assertions.assertThat((boolean)matcher.matches()).isTrue();
            file = runContext.workingDir().resolve(Path.of(matcher.group(1), new String[0])).toFile();
            Assertions.assertThat((boolean)file.exists()).isTrue();
            filesToDelete.add(file);
        }
        catch (IllegalVariableEvaluationException e) {
            throw new RuntimeException(e);
        }
        finally {
            filesToDelete.forEach(File::delete);
            path.toFile().delete();
        }
    }

    @Test
    void uploadOutputFiles() throws IOException {
        String tenant = IdUtils.create();
        RunContext runContext = this.runContextFactory.of("id", "namespace", tenant);
        Path path = ScriptServiceTest.createFile(tenant, "file");
        Map outputFiles = ScriptService.uploadOutputFiles((RunContext)runContext, (Path)Path.of("/tmp/unittest/%s".formatted(tenant), new String[0]));
        MatcherAssert.assertThat((Object)outputFiles, (Matcher)Matchers.not((Matcher)Matchers.anEmptyMap()));
        Assertions.assertThat((URI)((URI)outputFiles.get("file.txt"))).isEqualTo((Object)URI.create("kestra:///file.txt"));
        path.toFile().delete();
    }

    @Test
    void scriptCommands() {
        List scriptCommands = ScriptService.scriptCommands(List.of("interpreter"), List.of("beforeCommand"), List.of("command"));
        Assertions.assertThat((List)scriptCommands).hasSize(2);
        Assertions.assertThat((String)((String)scriptCommands.getFirst())).isEqualTo("interpreter");
        Assertions.assertThat((String)((String)scriptCommands.get(1))).isEqualTo("beforeCommand\ncommand");
    }

    @Test
    void labels() {
        RunContext runContext = this.runContext((RunContextFactory)this.runContextFactory, "very.very.very.very.very.very.very.very.very.very.very.very.long.namespace");
        Map labels = ScriptService.labels((RunContext)runContext, (String)"kestra.io/");
        Assertions.assertThat((int)labels.size()).isEqualTo(6);
        Assertions.assertThat((String)((String)labels.get("kestra.io/namespace"))).isEqualTo("very.very.very.very.very.very.very.very.very.very.very.very.lon");
        Assertions.assertThat((String)((String)labels.get("kestra.io/flow-id"))).isEqualTo("flowId");
        Assertions.assertThat((String)((String)labels.get("kestra.io/task-id"))).isEqualTo("task");
        Assertions.assertThat((String)((String)labels.get("kestra.io/execution-id"))).isEqualTo("executionId");
        Assertions.assertThat((String)((String)labels.get("kestra.io/taskrun-id"))).isEqualTo("taskrun");
        Assertions.assertThat((String)((String)labels.get("kestra.io/taskrun-attempt"))).isEqualTo("0");
        labels = ScriptService.labels((RunContext)runContext, null, (boolean)true, (boolean)true);
        Assertions.assertThat((int)labels.size()).isEqualTo(6);
        Assertions.assertThat((String)((String)labels.get("namespace"))).isEqualTo("very.very.very.very.very.very.very.very.very.very.very.very.lon");
        Assertions.assertThat((String)((String)labels.get("flow-id"))).isEqualTo("flowid");
        Assertions.assertThat((String)((String)labels.get("task-id"))).isEqualTo("task");
        Assertions.assertThat((String)((String)labels.get("execution-id"))).isEqualTo("executionid");
        Assertions.assertThat((String)((String)labels.get("taskrun-id"))).isEqualTo("taskrun");
        Assertions.assertThat((String)((String)labels.get("taskrun-attempt"))).isEqualTo("0");
    }

    @Test
    void jobName() {
        RunContext runContext = this.runContext((RunContextFactory)this.runContextFactory, "namespace");
        String jobName = ScriptService.jobName((RunContext)runContext);
        Assertions.assertThat((String)jobName).startsWith((CharSequence)"namespace-flowid-task-");
        Assertions.assertThat((int)jobName.length()).isEqualTo(27);
        runContext = this.runContext((RunContextFactory)this.runContextFactory, "very.very.very.very.very.very.very.very.very.very.very.very.long.namespace");
        jobName = ScriptService.jobName((RunContext)runContext);
        Assertions.assertThat((String)jobName).startsWith((CharSequence)"veryveryveryveryveryveryveryveryveryveryveryverylongnames-");
        Assertions.assertThat((int)jobName.length()).isEqualTo(63);
    }

    @Test
    void normalize() {
        Assertions.assertThat((String)ScriptService.normalize(null)).isNull();
        Assertions.assertThat((String)ScriptService.normalize((String)"a-normal-string")).isEqualTo("a-normal-string");
        Assertions.assertThat((String)ScriptService.normalize((String)"very.very.very.very.very.very.very.very.very.very.very.very.long.namespace")).isEqualTo("very.very.very.very.very.very.very.very.very.very.very.very.lon");
    }

    private RunContext runContext(RunContextFactory runContextFactory, String namespace) {
        Task task = new Task(this){

            public String getId() {
                return "task";
            }

            public String getType() {
                return "Task";
            }
        };
        TaskRun taskRun = TaskRun.builder().id("taskrun").taskId("task").flowId("flowId").namespace(namespace).executionId("executionId").state(new State().withState(State.Type.RUNNING)).build();
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id("flowId")).namespace(namespace)).revision(Integer.valueOf(1))).tasks(List.of(task)).build();
        Execution execution = Execution.builder().flowId("flowId").namespace(namespace).id("executionId").taskRunList(List.of(taskRun)).state(new State().withState(State.Type.RUNNING)).build();
        return runContextFactory.of((FlowInterface)flow, task, execution, taskRun);
    }

    private static Path createFile(String tenant, String fileName) throws IOException {
        Path path = Path.of("/tmp/unittest/%s/%s.txt".formatted(tenant, fileName), new String[0]);
        if (!path.toFile().exists()) {
            Files.createDirectory(Path.of("/tmp/unittest/%s".formatted(tenant), new String[0]), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
        }
        return path;
    }
}

