/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.runners;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.runners.AbstractLogConsumer;
import io.kestra.core.models.tasks.runners.TargetOS;
import io.kestra.core.models.tasks.runners.TaskCommands;
import io.kestra.core.models.tasks.runners.TaskRunner;
import io.kestra.core.models.tasks.runners.TaskRunnerDetailResult;
import io.kestra.core.models.tasks.runners.TaskRunnerResult;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.micronaut.context.ApplicationContext;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
public class TaskRunnerTest {
    public static final String ADDITIONAL_VAR_KEY = "additionalVarKey";
    public static final String ADDITIONAL_ENV_KEY = "ADDITIONAL_ENV_KEY";
    @Inject
    ApplicationContext applicationContext;
    @Inject
    RunContextFactory runContextFactory;

    @Test
    void additionalVarsAndEnv() throws IllegalVariableEvaluationException {
        TaskRunnerAdditional taskRunner = new TaskRunnerAdditional(true);
        TaskCommandsAdditional taskCommands = new TaskCommandsAdditional();
        Map<String, String> contextVariables = Map.of("runnerBucketPath", "someRunnerBucketPath", "runnerAdditionalVarKey", "runnerVarKey", "runnerAdditionalVarValue", "runnerVarValue", "runnerAdditionalEnvKey", "runnerEnvKey", "runnerAdditionalEnvValue", "runnerEnvValue", "scriptCommandsAdditionalVarKey", "scriptCommandsVarKey", "scriptCommandsAdditionalVarValue", "scriptCommandsVarValue", "scriptCommandsAdditionalEnvKey", "scriptCommandsEnvKey", "scriptCommandsAdditionalEnvValue", "scriptCommandsEnvValue");
        RunContext runContext = this.runContextFactory.of(contextVariables);
        Assertions.assertThat((Map)taskRunner.additionalVars(runContext, taskCommands)).isEqualTo(Map.of("bucketPath", contextVariables.get("runnerBucketPath"), "workingDir", "runnerWorkingDir", "outputDir", "runnerOutputDir", contextVariables.get("runnerAdditionalVarKey"), contextVariables.get("runnerAdditionalVarValue"), contextVariables.get("scriptCommandsAdditionalVarKey"), contextVariables.get("scriptCommandsAdditionalVarValue"), ADDITIONAL_VAR_KEY, "runnerSpecificVarValue"));
        Assertions.assertThat((Map)taskRunner.env(runContext, taskCommands)).isEqualTo(Map.of("BUCKET_PATH", "overridenEnvBucketPath", "WORKING_DIR", "overridenEnvWorkingDir", "OUTPUT_DIR", "overridenEnvOutputDir", contextVariables.get("runnerAdditionalEnvKey"), contextVariables.get("runnerAdditionalEnvValue"), contextVariables.get("scriptCommandsAdditionalEnvKey"), contextVariables.get("scriptCommandsAdditionalEnvValue"), ADDITIONAL_ENV_KEY, "runnerSpecificEnvValue"));
        taskRunner = new TaskRunnerAdditional(false);
        Assertions.assertThat((Map)taskRunner.env(runContext, taskCommands)).isEqualTo(Map.of("BUCKET_PATH", contextVariables.get("runnerBucketPath"), "WORKING_DIR", "runnerWorkingDir", "OUTPUT_DIR", "runnerOutputDir", contextVariables.get("runnerAdditionalEnvKey"), contextVariables.get("runnerAdditionalEnvValue"), contextVariables.get("scriptCommandsAdditionalEnvKey"), contextVariables.get("scriptCommandsAdditionalEnvValue"), ADDITIONAL_ENV_KEY, "runnerSpecificEnvValue"));
    }

    private static class TaskRunnerAdditional
    extends TaskRunner<TaskRunnerDetailResult> {
        public static final String RUNNER_BUCKET_PATH = "{{runnerBucketPath}}";
        public static final String RUNNER_WORKING_DIR = "runnerWorkingDir";
        public static final String RUNNER_OUTPUT_DIR = "runnerOutputDir";
        public static final String RUNNER_ADDITIONAL_VAR_KEY = "{{runnerAdditionalVarKey}}";
        public static final String RUNNER_ADDITIONAL_VAR_VALUE = "{{runnerAdditionalVarValue}}";
        public static final String RUNNER_ADDITIONAL_ENV_KEY = "{{runnerAdditionalEnvKey}}";
        public static final String RUNNER_ADDITIONAL_ENV_VALUE = "{{runnerAdditionalEnvValue}}";
        public static final String ADDITIONAL_VAR_VALUE = "runnerSpecificVarValue";
        public static final String ADDITIONAL_ENV_VALUE = "runnerSpecificEnvValue";
        private static final String OVERRIDEN_ENV_WORKING_DIR = "overridenEnvWorkingDir";
        private static final String OVERRIDEN_ENV_OUTPUT_DIR = "overridenEnvOutputDir";
        private static final String OVERRIDEN_ENV_BUCKET_PATH = "overridenEnvBucketPath";
        private final boolean overrideEnvValues;

        public TaskRunnerAdditional(boolean overrideEnvValues) {
            this.overrideEnvValues = overrideEnvValues;
        }

        public TaskRunnerResult<TaskRunnerDetailResult> run(RunContext runContext, TaskCommands taskCommands, List<String> filesToDownload) {
            return null;
        }

        protected Map<String, Object> runnerAdditionalVars(RunContext runContext, TaskCommands taskCommands) {
            return Map.of("bucketPath", RUNNER_BUCKET_PATH, "workingDir", RUNNER_WORKING_DIR, "outputDir", RUNNER_OUTPUT_DIR, RUNNER_ADDITIONAL_VAR_KEY, RUNNER_ADDITIONAL_VAR_VALUE, TaskRunnerTest.ADDITIONAL_VAR_KEY, ADDITIONAL_VAR_VALUE);
        }

        protected Map<String, String> runnerEnv(RunContext runContext, TaskCommands taskCommands) {
            HashMap<String, String> env = new HashMap<String, String>(Map.of(RUNNER_ADDITIONAL_ENV_KEY, RUNNER_ADDITIONAL_ENV_VALUE, TaskRunnerTest.ADDITIONAL_ENV_KEY, ADDITIONAL_ENV_VALUE));
            if (this.overrideEnvValues) {
                env.put("WORKING_DIR", OVERRIDEN_ENV_WORKING_DIR);
                env.put("OUTPUT_DIR", OVERRIDEN_ENV_OUTPUT_DIR);
                env.put("BUCKET_PATH", OVERRIDEN_ENV_BUCKET_PATH);
            }
            return env;
        }
    }

    private static class TaskCommandsAdditional
    implements TaskCommands {
        public static final String SCRIPT_COMMANDS_ADDITIONAL_VAR_KEY = "{{scriptCommandsAdditionalVarKey}}";
        public static final String SCRIPT_COMMANDS_ADDITIONAL_VAR_VALUE = "{{scriptCommandsAdditionalVarValue}}";
        public static final String SCRIPT_COMMANDS_ADDITIONAL_ENV_KEY = "{{scriptCommandsAdditionalEnvKey}}";
        public static final String SCRIPT_COMMANDS_ADDITIONAL_ENV_VALUE = "{{scriptCommandsAdditionalEnvValue}}";
        public static final String ADDITIONAL_VAR_VALUE = "commandsSpecificVarValue";
        public static final String ADDITIONAL_ENV_VALUE = "commandsSpecificEnvValue";

        private TaskCommandsAdditional() {
        }

        public String getContainerImage() {
            return null;
        }

        public AbstractLogConsumer getLogConsumer() {
            return null;
        }

        public Property<List<String>> getInterpreter() {
            return null;
        }

        public Property<List<String>> getBeforeCommands() {
            return null;
        }

        public Property<List<String>> getCommands() {
            return null;
        }

        public TargetOS getTargetOS() {
            return null;
        }

        public Map<String, Object> getAdditionalVars() {
            return Map.of(SCRIPT_COMMANDS_ADDITIONAL_VAR_KEY, SCRIPT_COMMANDS_ADDITIONAL_VAR_VALUE, TaskRunnerTest.ADDITIONAL_VAR_KEY, ADDITIONAL_VAR_VALUE);
        }

        public Path getWorkingDirectory() {
            return null;
        }

        public Path getOutputDirectory() {
            return null;
        }

        public Map<String, String> getEnv() {
            return Map.of(SCRIPT_COMMANDS_ADDITIONAL_ENV_KEY, SCRIPT_COMMANDS_ADDITIONAL_ENV_VALUE, TaskRunnerTest.ADDITIONAL_ENV_KEY, ADDITIONAL_ENV_VALUE);
        }

        public Boolean getEnableOutputDirectory() {
            return true;
        }

        public Duration getTimeout() {
            return null;
        }
    }
}

