/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.triggers.StatefulTriggerInterface;
import io.kestra.core.models.triggers.StatefulTriggerService;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@KestraTest
class StatefulTriggerInterfaceTest {
    @Inject
    RunContextFactory runContextFactory;

    StatefulTriggerInterfaceTest() {
    }

    @Test
    void shouldPersistAndReadState() throws Exception {
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("io.kestra.unittest")).id("test-flow")).revision(Integer.valueOf(1))).build();
        RunContext runContext = this.runContextFactory.of(flow, Map.of("flow", Map.of("tenantId", "main", "namespace", "io.kestra.unittest", "id", "test-flow", "revision", 1)));
        String key = StatefulTriggerService.defaultKey((String)"ns", (String)"test-flow", (String)"trigger-persist");
        Optional<Duration> ttl = Optional.of(Duration.ofMinutes(5L));
        HashMap state = new HashMap();
        StatefulTriggerService.Entry candidate = StatefulTriggerService.Entry.candidate((String)"gs://bucket/file1.csv", (String)"v1", (Instant)Instant.now());
        StatefulTriggerService.StateUpdate result = StatefulTriggerService.computeAndUpdateState(state, (StatefulTriggerService.Entry)candidate, (StatefulTriggerInterface.On)StatefulTriggerInterface.On.CREATE_OR_UPDATE);
        MatcherAssert.assertThat((Object)result.fire(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)result.isNew(), (Matcher)Matchers.is((Object)true));
        StatefulTriggerService.writeState((RunContext)runContext, (String)key, state, ttl);
        Map reloaded = StatefulTriggerService.readState((RunContext)runContext, (String)key, ttl);
        MatcherAssert.assertThat((Object)reloaded, (Matcher)Matchers.hasKey((Object)"gs://bucket/file1.csv"));
        MatcherAssert.assertThat((Object)((StatefulTriggerService.Entry)reloaded.get("gs://bucket/file1.csv")).version(), (Matcher)Matchers.is((Object)"v1"));
        StatefulTriggerService.StateUpdate result2 = StatefulTriggerService.computeAndUpdateState((Map)reloaded, (StatefulTriggerService.Entry)candidate, (StatefulTriggerInterface.On)StatefulTriggerInterface.On.CREATE_OR_UPDATE);
        MatcherAssert.assertThat((Object)result2.fire(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void shouldExpireOldEntriesAfterTTL() throws Exception {
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("io.kestra.unittest")).id("test-flow")).revision(Integer.valueOf(1))).build();
        RunContext runContext = this.runContextFactory.of(flow, Map.of("flow", Map.of("tenantId", "main", "namespace", "io.kestra.unittest", "id", "test-flow", "revision", 1)));
        String key = StatefulTriggerService.defaultKey((String)"ns", (String)"test-flow", (String)"trigger-ttl");
        Optional<Duration> ttl = Optional.of(Duration.ofMinutes(5L));
        Instant now = Instant.now();
        HashMap<String, StatefulTriggerService.Entry> state = new HashMap<String, StatefulTriggerService.Entry>();
        state.put("gs://bucket/old.csv", new StatefulTriggerService.Entry("gs://bucket/old.csv", "v1", now.minus(Duration.ofHours(2L)), now.minus(Duration.ofHours(2L))));
        state.put("gs://bucket/new.csv", new StatefulTriggerService.Entry("gs://bucket/new.csv", "v1", now, now));
        StatefulTriggerService.writeState((RunContext)runContext, (String)key, state, ttl);
        Map reloaded = StatefulTriggerService.readState((RunContext)runContext, (String)key, ttl);
        MatcherAssert.assertThat((Object)reloaded, (Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)"gs://bucket/new.csv"), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"gs://bucket/old.csv"))));
    }
}

