/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers.multipleflows;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowId;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.triggers.TimeWindow;
import io.kestra.core.models.triggers.multipleflows.MultipleCondition;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionStorageInterface;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionWindow;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.ExecutionFlow;
import io.kestra.plugin.core.trigger.Flow;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
public abstract class AbstractMultipleConditionStorageTest {
    private static final String NAMESPACE = "io.kestra.unit";

    protected abstract MultipleConditionStorageInterface multipleConditionStorage();

    protected abstract void save(MultipleConditionStorageInterface var1, Flow var2, List<MultipleConditionWindow> var3);

    @Test
    void allDefault() {
        MultipleConditionStorageInterface multipleConditionStorage = this.multipleConditionStorage();
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Pair<Flow, io.kestra.plugin.core.condition.MultipleCondition> pair = AbstractMultipleConditionStorageTest.mockFlow(tenant, TimeWindow.builder().build());
        MultipleConditionWindow window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        Assertions.assertThat((String)window.getFlowId()).isEqualTo(((Flow)pair.getLeft()).getId());
        Assertions.assertThat((LocalTime)window.getStart().toLocalTime()).isEqualTo((Object)LocalTime.parse("00:00:00"));
        Assertions.assertThat((LocalDate)window.getStart().toLocalDate()).isEqualTo((Object)ZonedDateTime.now().toLocalDate());
        Assertions.assertThat((LocalTime)window.getEnd().toLocalTime()).isEqualTo((Object)LocalTime.parse("23:59:59.999"));
        Assertions.assertThat((LocalDate)window.getEnd().toLocalDate()).isEqualTo((Object)ZonedDateTime.now().toLocalDate());
    }

    @Test
    void daily() {
        MultipleConditionStorageInterface multipleConditionStorage = this.multipleConditionStorage();
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Pair<Flow, io.kestra.plugin.core.condition.MultipleCondition> pair = AbstractMultipleConditionStorageTest.mockFlow(tenant, TimeWindow.builder().window(Duration.ofDays(1L)).windowAdvance(Duration.ofSeconds(0L)).build());
        MultipleConditionWindow window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        Assertions.assertThat((String)window.getFlowId()).isEqualTo(((Flow)pair.getLeft()).getId());
        Assertions.assertThat((LocalTime)window.getStart().toLocalTime()).isEqualTo((Object)LocalTime.parse("00:00:00"));
        Assertions.assertThat((LocalDate)window.getStart().toLocalDate()).isEqualTo((Object)ZonedDateTime.now().toLocalDate());
        Assertions.assertThat((LocalTime)window.getEnd().toLocalTime()).isEqualTo((Object)LocalTime.parse("23:59:59.999"));
        Assertions.assertThat((LocalDate)window.getEnd().toLocalDate()).isEqualTo((Object)ZonedDateTime.now().toLocalDate());
    }

    @Test
    void dailyAdvance() {
        MultipleConditionStorageInterface multipleConditionStorage = this.multipleConditionStorage();
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Pair<Flow, io.kestra.plugin.core.condition.MultipleCondition> pair = AbstractMultipleConditionStorageTest.mockFlow(tenant, TimeWindow.builder().window(Duration.ofDays(1L)).windowAdvance(Duration.ofHours(4L).negated()).build());
        MultipleConditionWindow window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        Assertions.assertThat((String)window.getFlowId()).isEqualTo(((Flow)pair.getLeft()).getId());
        Assertions.assertThat((LocalTime)window.getStart().toLocalTime()).isEqualTo((Object)LocalTime.parse("20:00:00"));
        Assertions.assertThat((LocalDate)window.getStart().toLocalDate()).isEqualTo((Object)ZonedDateTime.now().minusDays(1L).toLocalDate());
        Assertions.assertThat((LocalTime)window.getEnd().toLocalTime()).isEqualTo((Object)LocalTime.parse("19:59:59.999"));
        Assertions.assertThat((LocalDate)window.getEnd().toLocalDate()).isEqualTo((Object)ZonedDateTime.now().toLocalDate());
    }

    @Test
    void hourly() {
        MultipleConditionStorageInterface multipleConditionStorage = this.multipleConditionStorage();
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Pair<Flow, io.kestra.plugin.core.condition.MultipleCondition> pair = AbstractMultipleConditionStorageTest.mockFlow(tenant, TimeWindow.builder().window(Duration.ofHours(1L)).windowAdvance(Duration.ofHours(4L).negated()).build());
        MultipleConditionWindow window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        Assertions.assertThat((String)window.getFlowId()).isEqualTo(((Flow)pair.getLeft()).getId());
        Assertions.assertThat((int)window.getStart().toLocalTime().getHour()).isEqualTo(ZonedDateTime.now().minusHours(4L).getHour());
        Assertions.assertThat((LocalDate)window.getStart().toLocalDate()).isEqualTo((Object)ZonedDateTime.now().minusHours(4L).toLocalDate());
        Assertions.assertThat((int)window.getEnd().toLocalTime().getHour()).isEqualTo(ZonedDateTime.now().minusHours(4L).getHour());
        Assertions.assertThat((int)window.getEnd().toLocalTime().getMinute()).isEqualTo(59);
        Assertions.assertThat((LocalDate)window.getEnd().toLocalDate()).isEqualTo((Object)ZonedDateTime.now().minusHours(4L).toLocalDate());
    }

    @Test
    void minutely() {
        MultipleConditionStorageInterface multipleConditionStorage = this.multipleConditionStorage();
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Pair<Flow, io.kestra.plugin.core.condition.MultipleCondition> pair = AbstractMultipleConditionStorageTest.mockFlow(tenant, TimeWindow.builder().window(Duration.ofMinutes(15L)).windowAdvance(Duration.ofMinutes(5L).negated()).build());
        MultipleConditionWindow window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        Assertions.assertThat((String)window.getFlowId()).isEqualTo(((Flow)pair.getLeft()).getId());
        Assertions.assertThat((int)window.getStart().getMinute()).isIn(Arrays.asList(10, 25, 40, 55));
        Assertions.assertThat((int)window.getEnd().getMinute()).isIn(Arrays.asList(9, 24, 39, 54));
    }

    @Test
    void expiration() throws Exception {
        MultipleConditionStorageInterface multipleConditionStorage = this.multipleConditionStorage();
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Pair<Flow, io.kestra.plugin.core.condition.MultipleCondition> pair = AbstractMultipleConditionStorageTest.mockFlow(tenant, TimeWindow.builder().window(Duration.ofSeconds(2L)).windowAdvance(Duration.ofMinutes(0L).negated()).build());
        MultipleConditionWindow window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        this.save(multipleConditionStorage, (Flow)pair.getLeft(), Collections.singletonList(window.with((Map)ImmutableMap.of((Object)"a", (Object)true))));
        Assertions.assertThat((String)window.getFlowId()).isEqualTo(((Flow)pair.getLeft()).getId());
        window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        Assertions.assertThat((Boolean)((Boolean)window.getResults().get("a"))).isTrue();
        Thread.sleep(2005L);
        MultipleConditionWindow next = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        Assertions.assertThat((String)next.getStart().format(DateTimeFormatter.ISO_DATE_TIME)).isNotEqualTo((Object)window.getStart().format(DateTimeFormatter.ISO_DATE_TIME));
        Assertions.assertThat((boolean)next.getResults().containsKey("a")).isFalse();
    }

    @Test
    void expired() throws Exception {
        MultipleConditionStorageInterface multipleConditionStorage = this.multipleConditionStorage();
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Pair<Flow, io.kestra.plugin.core.condition.MultipleCondition> pair = AbstractMultipleConditionStorageTest.mockFlow(tenant, TimeWindow.builder().window(Duration.ofSeconds(2L)).windowAdvance(Duration.ofMinutes(0L).negated()).build());
        MultipleConditionWindow window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        this.save(multipleConditionStorage, (Flow)pair.getLeft(), Collections.singletonList(window.with((Map)ImmutableMap.of((Object)"a", (Object)true))));
        Assertions.assertThat((String)window.getFlowId()).isEqualTo(((Flow)pair.getLeft()).getId());
        window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        Assertions.assertThat((Boolean)((Boolean)window.getResults().get("a"))).isTrue();
        List expired = multipleConditionStorage.expired(tenant);
        Assertions.assertThat((int)expired.size()).isZero();
        Thread.sleep(2005L);
        expired = multipleConditionStorage.expired(tenant);
        Assertions.assertThat((int)expired.size()).isEqualTo(1);
    }

    @Test
    void dailyTimeDeadline() throws Exception {
        MultipleConditionStorageInterface multipleConditionStorage = this.multipleConditionStorage();
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Pair<Flow, io.kestra.plugin.core.condition.MultipleCondition> pair = AbstractMultipleConditionStorageTest.mockFlow(tenant, TimeWindow.builder().type(TimeWindow.Type.DAILY_TIME_DEADLINE).deadline(LocalTime.now().plusSeconds(2L)).build());
        MultipleConditionWindow window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        this.save(multipleConditionStorage, (Flow)pair.getLeft(), Collections.singletonList(window.with((Map)ImmutableMap.of((Object)"a", (Object)true))));
        Assertions.assertThat((String)window.getFlowId()).isEqualTo(((Flow)pair.getLeft()).getId());
        window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        Assertions.assertThat((Boolean)((Boolean)window.getResults().get("a"))).isTrue();
        List expired = multipleConditionStorage.expired(tenant);
        Assertions.assertThat((int)expired.size()).isZero();
        Thread.sleep(2005L);
        expired = multipleConditionStorage.expired(tenant);
        Assertions.assertThat((int)expired.size()).isEqualTo(1);
    }

    @Test
    void dailyTimeDeadline_Expired() throws Exception {
        MultipleConditionStorageInterface multipleConditionStorage = this.multipleConditionStorage();
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Pair<Flow, io.kestra.plugin.core.condition.MultipleCondition> pair = AbstractMultipleConditionStorageTest.mockFlow(tenant, TimeWindow.builder().type(TimeWindow.Type.DAILY_TIME_DEADLINE).deadline(LocalTime.now().minusSeconds(1L)).build());
        MultipleConditionWindow window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        this.save(multipleConditionStorage, (Flow)pair.getLeft(), Collections.singletonList(window.with((Map)ImmutableMap.of((Object)"a", (Object)true))));
        Assertions.assertThat((String)window.getFlowId()).isEqualTo(((Flow)pair.getLeft()).getId());
        window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        Assertions.assertThat((Map)window.getResults()).isEmpty();
        List expired = multipleConditionStorage.expired(tenant);
        Assertions.assertThat((int)expired.size()).isEqualTo(1);
    }

    @Test
    void dailyTimeWindow() {
        MultipleConditionStorageInterface multipleConditionStorage = this.multipleConditionStorage();
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        LocalTime startTime = LocalTime.now().truncatedTo(ChronoUnit.MINUTES);
        Pair<Flow, io.kestra.plugin.core.condition.MultipleCondition> pair = AbstractMultipleConditionStorageTest.mockFlow(tenant, TimeWindow.builder().type(TimeWindow.Type.DAILY_TIME_WINDOW).startTime(startTime).endTime(startTime.plusMinutes(5L)).build());
        MultipleConditionWindow window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        this.save(multipleConditionStorage, (Flow)pair.getLeft(), Collections.singletonList(window.with((Map)ImmutableMap.of((Object)"a", (Object)true))));
        Assertions.assertThat((String)window.getFlowId()).isEqualTo(((Flow)pair.getLeft()).getId());
        window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        Assertions.assertThat((Boolean)((Boolean)window.getResults().get("a"))).isTrue();
        List expired = multipleConditionStorage.expired(tenant);
        Assertions.assertThat((int)expired.size()).isZero();
    }

    @Test
    void slidingWindow() throws Exception {
        MultipleConditionStorageInterface multipleConditionStorage = this.multipleConditionStorage();
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Pair<Flow, io.kestra.plugin.core.condition.MultipleCondition> pair = AbstractMultipleConditionStorageTest.mockFlow(tenant, TimeWindow.builder().type(TimeWindow.Type.SLIDING_WINDOW).window(Duration.ofHours(1L)).build());
        MultipleConditionWindow window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        this.save(multipleConditionStorage, (Flow)pair.getLeft(), Collections.singletonList(window.with((Map)ImmutableMap.of((Object)"a", (Object)true))));
        Assertions.assertThat((String)window.getFlowId()).isEqualTo(((Flow)pair.getLeft()).getId());
        window = multipleConditionStorage.getOrCreate((FlowId)pair.getKey(), (MultipleCondition)pair.getRight(), Collections.emptyMap());
        Assertions.assertThat((Boolean)((Boolean)window.getResults().get("a"))).isTrue();
        List expired = multipleConditionStorage.expired(tenant);
        Assertions.assertThat((int)expired.size()).isZero();
    }

    private static Pair<Flow, io.kestra.plugin.core.condition.MultipleCondition> mockFlow(String tenantId, TimeWindow sla) {
        io.kestra.plugin.core.condition.MultipleCondition multipleCondition = io.kestra.plugin.core.condition.MultipleCondition.builder().id("condition-multiple-%s".formatted(tenantId)).conditions((Map)ImmutableMap.of((Object)"flow-a", (Object)ExecutionFlow.builder().flowId(Property.ofValue((Object)"flow-a")).namespace(Property.ofValue((Object)NAMESPACE)).build(), (Object)"flow-b", (Object)ExecutionFlow.builder().flowId(Property.ofValue((Object)"flow-b")).namespace(Property.ofValue((Object)NAMESPACE)).build())).timeWindow(sla).build();
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace(NAMESPACE)).id("multiple-flow")).tenantId(tenantId)).revision(Integer.valueOf(1))).triggers(Collections.singletonList(((Flow.FlowBuilder)((Flow.FlowBuilder)io.kestra.plugin.core.trigger.Flow.builder().id("trigger-flow")).conditions(Collections.singletonList(multipleCondition))).build())).build();
        return Pair.of((Object)flow, (Object)multipleCondition);
    }
}

