/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.kestra.core.docs.JsonSchemaGenerator;
import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.plugins.AdditionalPlugin;
import io.kestra.core.plugins.serdes.PluginDeserializer;
import io.kestra.core.runners.RunContext;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class AdditionalPluginTest {
    @Inject
    private JsonSchemaGenerator jsonSchemaGenerator;

    AdditionalPluginTest() {
    }

    @Test
    @ExecuteFlow(value="flows/valids/additional-plugin.yaml")
    void additionalPlugin(Execution execution) {
        Assertions.assertThat((Object)execution).isNotNull();
        Assertions.assertThat((boolean)execution.getState().isSuccess()).isTrue();
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"output")).isEqualTo((Object)"1 -> Hello");
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().get(1)).getOutputs().get((Object)"output")).isEqualTo((Object)"Hello World!");
    }

    @Test
    void shouldResolveAdditionalPluginSubtypes() {
        Map generate = this.jsonSchemaGenerator.properties(null, AdditionalPluginTestTask.class);
        Map definitions = (Map)generate.get("$defs");
        Assertions.assertThat((Map)definitions).hasSize(7);
        Assertions.assertThat((Map)definitions).containsKey((Object)"io.kestra.core.plugins.AdditionalPluginTest-AdditionalPluginTest1");
        Assertions.assertThat((Map)definitions).containsKey((Object)"io.kestra.core.plugins.AdditionalPluginTest-AdditionalPluginTest2");
    }

    @Plugin
    public static class AdditionalPluginTestTask
    extends Task
    implements RunnableTask<Output> {
        @NotNull
        private BaseAdditionalPluginTest additionalPlugin;

        public Output run(RunContext runContext) throws Exception {
            return Output.builder().output(this.additionalPlugin.sayHello()).build();
        }

        @Generated
        protected AdditionalPluginTestTask(AdditionalPluginTestTaskBuilder<?, ?> b) {
            super(b);
            this.additionalPlugin = b.additionalPlugin;
        }

        @Generated
        public static AdditionalPluginTestTaskBuilder<?, ?> builder() {
            return new AdditionalPluginTestTaskBuilderImpl();
        }

        @Generated
        public String toString() {
            return "AdditionalPluginTest.AdditionalPluginTestTask(super=" + super.toString() + ", additionalPlugin=" + String.valueOf((Object)this.getAdditionalPlugin()) + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AdditionalPluginTestTask)) {
                return false;
            }
            AdditionalPluginTestTask other = (AdditionalPluginTestTask)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BaseAdditionalPluginTest this$additionalPlugin = this.getAdditionalPlugin();
            BaseAdditionalPluginTest other$additionalPlugin = other.getAdditionalPlugin();
            return !(this$additionalPlugin == null ? other$additionalPlugin != null : !((Object)((Object)this$additionalPlugin)).equals((Object)other$additionalPlugin));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AdditionalPluginTestTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            BaseAdditionalPluginTest $additionalPlugin = this.getAdditionalPlugin();
            result = result * 59 + ($additionalPlugin == null ? 43 : ((Object)((Object)$additionalPlugin)).hashCode());
            return result;
        }

        @Generated
        public BaseAdditionalPluginTest getAdditionalPlugin() {
            return this.additionalPlugin;
        }

        @Generated
        public AdditionalPluginTestTask() {
        }

        public static class Output
        implements io.kestra.core.models.tasks.Output {
            private String output;

            @ConstructorProperties(value={"output"})
            @Generated
            Output(String output) {
                this.output = output;
            }

            @Generated
            public static OutputBuilder builder() {
                return new OutputBuilder();
            }

            @Generated
            public String getOutput() {
                return this.output;
            }

            @Generated
            public static class OutputBuilder {
                @Generated
                private String output;

                @Generated
                OutputBuilder() {
                }

                @Generated
                public OutputBuilder output(String output) {
                    this.output = output;
                    return this;
                }

                @Generated
                public Output build() {
                    return new Output(this.output);
                }

                @Generated
                public String toString() {
                    return "AdditionalPluginTest.AdditionalPluginTestTask.Output.OutputBuilder(output=" + this.output + ")";
                }
            }
        }

        @Generated
        public static abstract class AdditionalPluginTestTaskBuilder<C extends AdditionalPluginTestTask, B extends AdditionalPluginTestTaskBuilder<C, B>>
        extends Task.TaskBuilder<C, B> {
            @Generated
            private BaseAdditionalPluginTest additionalPlugin;

            @Generated
            public B additionalPlugin(BaseAdditionalPluginTest additionalPlugin) {
                this.additionalPlugin = additionalPlugin;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "AdditionalPluginTest.AdditionalPluginTestTask.AdditionalPluginTestTaskBuilder(super=" + super.toString() + ", additionalPlugin=" + String.valueOf((Object)this.additionalPlugin) + ")";
            }
        }

        @Generated
        private static final class AdditionalPluginTestTaskBuilderImpl
        extends AdditionalPluginTestTaskBuilder<AdditionalPluginTestTask, AdditionalPluginTestTaskBuilderImpl> {
            @Generated
            private AdditionalPluginTestTaskBuilderImpl() {
            }

            @Override
            @Generated
            protected AdditionalPluginTestTaskBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public AdditionalPluginTestTask build() {
                return new AdditionalPluginTestTask(this);
            }
        }
    }

    @Plugin
    @JsonDeserialize
    public static class AdditionalPluginTest2
    extends BaseAdditionalPluginTest {
        @Override
        public String sayHello() {
            return "Hello World!";
        }

        @Generated
        public static AdditionalPluginTest2Builder builder() {
            return new AdditionalPluginTest2Builder();
        }

        @Generated
        public AdditionalPluginTest2() {
        }

        @Generated
        public static class AdditionalPluginTest2Builder {
            @Generated
            AdditionalPluginTest2Builder() {
            }

            @Generated
            public AdditionalPluginTest2 build() {
                return new AdditionalPluginTest2();
            }

            @Generated
            public String toString() {
                return "AdditionalPluginTest.AdditionalPluginTest2.AdditionalPluginTest2Builder()";
            }
        }
    }

    @Plugin
    @JsonDeserialize
    public static class AdditionalPluginTest1
    extends BaseAdditionalPluginTest {
        @NotNull
        private Property<String> baseMessage;

        @Override
        public String sayHello() {
            return "1 -> " + String.valueOf(this.baseMessage);
        }

        @Generated
        public static AdditionalPluginTest1Builder builder() {
            return new AdditionalPluginTest1Builder();
        }

        @Generated
        public Property<String> getBaseMessage() {
            return this.baseMessage;
        }

        @Generated
        public AdditionalPluginTest1() {
        }

        @ConstructorProperties(value={"baseMessage"})
        @Generated
        public AdditionalPluginTest1(Property<String> baseMessage) {
            this.baseMessage = baseMessage;
        }

        @Generated
        public static class AdditionalPluginTest1Builder {
            @Generated
            private Property<String> baseMessage;

            @Generated
            AdditionalPluginTest1Builder() {
            }

            @Generated
            public AdditionalPluginTest1Builder baseMessage(Property<String> baseMessage) {
                this.baseMessage = baseMessage;
                return this;
            }

            @Generated
            public AdditionalPluginTest1 build() {
                return new AdditionalPluginTest1(this.baseMessage);
            }

            @Generated
            public String toString() {
                return "AdditionalPluginTest.AdditionalPluginTest1.AdditionalPluginTest1Builder(baseMessage=" + String.valueOf(this.baseMessage) + ")";
            }
        }
    }

    @Plugin
    @JsonDeserialize(using=PluginDeserializer.class)
    public static abstract class BaseAdditionalPluginTest
    extends AdditionalPlugin {
        public abstract String sayHello();

        @Generated
        protected BaseAdditionalPluginTest(BaseAdditionalPluginTestBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public BaseAdditionalPluginTest() {
        }

        @Generated
        public static abstract class BaseAdditionalPluginTestBuilder<C extends BaseAdditionalPluginTest, B extends BaseAdditionalPluginTestBuilder<C, B>>
        extends AdditionalPlugin.AdditionalPluginBuilder<C, B> {
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                BaseAdditionalPluginTestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(BaseAdditionalPluginTest instance, BaseAdditionalPluginTestBuilder<?, ?> b) {
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "AdditionalPluginTest.BaseAdditionalPluginTest.BaseAdditionalPluginTestBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

