/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import io.kestra.core.plugins.PluginArtifact;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PluginArtifactTest {
    PluginArtifactTest() {
    }

    @Test
    void shouldParseGivenValidFilenameWithoutClassifier() {
        String fileName = "io_kestra_plugin__plugin-serdes__0_20_0.jar";
        PluginArtifact artifact = PluginArtifact.fromFileName((String)fileName);
        Assertions.assertEquals((Object)"io.kestra.plugin", (Object)artifact.groupId());
        Assertions.assertEquals((Object)"plugin-serdes", (Object)artifact.artifactId());
        Assertions.assertEquals((Object)"jar", (Object)artifact.extension());
        Assertions.assertNull((Object)artifact.classifier());
        Assertions.assertEquals((Object)"0.20.0", (Object)artifact.version());
        Assertions.assertNull((Object)artifact.uri());
    }

    @Test
    void shouldParseGivenValidFilenameWithClassifier() {
        String fileName = "io_kestra_plugin__plugin-serdes__custom-classifier__0_20_0.jar";
        PluginArtifact artifact = PluginArtifact.fromFileName((String)fileName);
        Assertions.assertEquals((Object)"io.kestra.plugin", (Object)artifact.groupId());
        Assertions.assertEquals((Object)"plugin-serdes", (Object)artifact.artifactId());
        Assertions.assertEquals((Object)"jar", (Object)artifact.extension());
        Assertions.assertEquals((Object)"custom-classifier", (Object)artifact.classifier());
        Assertions.assertEquals((Object)"0.20.0", (Object)artifact.version());
        Assertions.assertNull((Object)artifact.uri());
    }

    @Test
    void shouldParseGivenValidFilenameWithQualifier() {
        String fileName = "io_kestra_plugin__plugin-serdes__custom-classifier__0_20_0-SNAPSHOT.jar";
        PluginArtifact artifact = PluginArtifact.fromFileName((String)fileName);
        Assertions.assertEquals((Object)"io.kestra.plugin", (Object)artifact.groupId());
        Assertions.assertEquals((Object)"plugin-serdes", (Object)artifact.artifactId());
        Assertions.assertEquals((Object)"jar", (Object)artifact.extension());
        Assertions.assertEquals((Object)"custom-classifier", (Object)artifact.classifier());
        Assertions.assertEquals((Object)"0.20.0-SNAPSHOT", (Object)artifact.version());
        Assertions.assertNull((Object)artifact.uri());
    }

    @Test
    void shouldParseGivenValidFilenameWithNonStandardQualifier() {
        String fileName = "io_kestra_plugin__plugin-serdes__custom-classifier__0_20_0-RC1-SNAPSHOT.jar";
        PluginArtifact artifact = PluginArtifact.fromFileName((String)fileName);
        Assertions.assertEquals((Object)"io.kestra.plugin", (Object)artifact.groupId());
        Assertions.assertEquals((Object)"plugin-serdes", (Object)artifact.artifactId());
        Assertions.assertEquals((Object)"jar", (Object)artifact.extension());
        Assertions.assertEquals((Object)"custom-classifier", (Object)artifact.classifier());
        Assertions.assertEquals((Object)"0.20.0-RC1-SNAPSHOT", (Object)artifact.version());
        Assertions.assertNull((Object)artifact.uri());
    }

    @Test
    void shouldThrowIllegalArgumentExceptionGivenInvalidFilenameMissingVersion() {
        String fileName = "io_kestra_plugin__plugin-serdes__custom-classifier.jar";
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> PluginArtifact.fromFileName((String)fileName));
        Assertions.assertEquals((Object)"Invalid artifact filename 'io_kestra_plugin__plugin-serdes__custom-classifier.jar', expected format is <groupId>__<artifactId>[__<classifier>]__<version>.jar", (Object)exception.getMessage());
    }

    @Test
    void shouldThrowIllegalArgumentExceptionGivenInvalidFilenameWrongFormat() {
        String fileName = "invalid_filename_format.jar";
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> PluginArtifact.fromFileName((String)fileName));
        Assertions.assertEquals((Object)"Invalid artifact filename 'invalid_filename_format.jar', expected format is <groupId>__<artifactId>[__<classifier>]__<version>.jar", (Object)exception.getMessage());
    }

    @Test
    void shouldParseGivenValidFilenameEdgeCase() {
        String fileName = "group__artifact__0_0_1.jar";
        PluginArtifact artifact = PluginArtifact.fromFileName((String)fileName);
        Assertions.assertEquals((Object)"group", (Object)artifact.groupId());
        Assertions.assertEquals((Object)"artifact", (Object)artifact.artifactId());
        Assertions.assertEquals((Object)"jar", (Object)artifact.extension());
        Assertions.assertNull((Object)artifact.classifier());
        Assertions.assertEquals((Object)"0.0.1", (Object)artifact.version());
        Assertions.assertNull((Object)artifact.uri());
    }
}

