/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import io.kestra.core.plugins.PluginConfiguration;
import io.kestra.core.plugins.PluginConfigurations;
import io.kestra.core.runners.test.TaskWithAlias;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PluginConfigurationsTest {
    private static final String PLUGIN_TEST = "io.kestra.plugin.Test";

    PluginConfigurationsTest() {
    }

    @Test
    void shouldGetOrderedMergeConfigurationProperties() {
        PluginConfigurations configurations = new PluginConfigurations(List.of(new PluginConfiguration(Integer.valueOf(0), PLUGIN_TEST, Map.of("prop1", "v1", "prop2", "v1", "prop3", "v1")), new PluginConfiguration(Integer.valueOf(2), PLUGIN_TEST, Map.of("prop1", "v1", "prop2", "v2", "prop3", "v3")), new PluginConfiguration(Integer.valueOf(1), PLUGIN_TEST, Map.of("prop1", "v2", "prop2", "v2", "prop3", "v2"))));
        Map result = configurations.getConfigurationByPluginType(PLUGIN_TEST);
        Assertions.assertEquals(Map.of("prop1", "v1", "prop2", "v2", "prop3", "v3"), (Object)result);
    }

    @Test
    void shouldGetConfigurationForAlias() {
        Map<String, String> config = Map.of("prop1", "v1", "prop2", "v1", "prop3", "v1");
        PluginConfigurations configurations = new PluginConfigurations(List.of(new PluginConfiguration(Integer.valueOf(0), "io.kestra.core.runners.test.task.Alias", config)));
        Map result = configurations.getConfigurationByPluginTypeOrAliases(new TaskWithAlias().getType(), TaskWithAlias.class);
        Assertions.assertEquals(config, (Object)result);
    }
}

