/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import io.kestra.core.plugins.PluginScanner;
import io.kestra.core.plugins.RegisteredPlugin;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PluginScannerTest {
    PluginScannerTest() {
    }

    @Test
    void scanPlugins() throws URISyntaxException {
        Path plugins = Paths.get(Objects.requireNonNull(PluginScannerTest.class.getClassLoader().getResource("plugins")).toURI());
        PluginScanner pluginScanner = new PluginScanner(PluginScannerTest.class.getClassLoader());
        List scan = pluginScanner.scan(plugins);
        Assertions.assertThat((int)scan.size()).isEqualTo(1);
        Assertions.assertThat((String)((RegisteredPlugin)scan.getFirst()).getManifest().getMainAttributes().getValue("X-Kestra-Group")).isEqualTo("io.kestra.plugin.templates");
    }

    @Test
    void scanCore() {
        PluginScanner pluginScanner = new PluginScanner(PluginScannerTest.class.getClassLoader());
        RegisteredPlugin scan = pluginScanner.scan();
        Assertions.assertThat((String)scan.getManifest().getMainAttributes().getValue("X-Kestra-Group")).isEqualTo("io.kestra.plugin.core");
    }
}

