/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins.serdes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.kestra.core.models.Plugin;
import io.kestra.core.plugins.PluginRegistry;
import io.kestra.core.plugins.serdes.PluginDeserializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class PluginDeserializerTest {
    @Mock
    private PluginRegistry registry;

    PluginDeserializerTest() {
    }

    @Test
    void shouldSucceededDeserializePluginGivenValidType() throws JsonProcessingException {
        ObjectMapper om = new ObjectMapper().registerModule((Module)new SimpleModule().addDeserializer(Plugin.class, (JsonDeserializer)new PluginDeserializer(this.registry)));
        String input = "{ \"plugin\": { \"type\": \"io.kestra.core.plugins.serdes.PluginDeserializerTest.TestPlugin\"} }\n";
        String identifier = TestPlugin.class.getCanonicalName();
        Mockito.when((Object)this.registry.findClassByIdentifier(identifier)).thenAnswer(invocation -> TestPlugin.class);
        TestPluginHolder deserialized = (TestPluginHolder)om.readValue(input, TestPluginHolder.class);
        Assertions.assertThat((String)TestPlugin.class.getCanonicalName()).isEqualTo(deserialized.plugin().getType());
        ((PluginRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.times((int)1))).isVersioningSupported();
        ((PluginRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.times((int)1))).findClassByIdentifier(identifier);
    }

    @Test
    void shouldFailedDeserializePluginGivenInvalidType() {
        ObjectMapper om = new ObjectMapper().registerModule((Module)new SimpleModule().addDeserializer(Plugin.class, (JsonDeserializer)new PluginDeserializer(this.registry)));
        String input = "{ \"plugin\": { \"type\": \"io.kestra.core.plugins.serdes.Unknown\"} }\n";
        InvalidTypeIdException exception = (InvalidTypeIdException)org.junit.jupiter.api.Assertions.assertThrows(InvalidTypeIdException.class, () -> om.readValue(input, TestPluginHolder.class));
        Assertions.assertThat((String)"io.kestra.core.plugins.serdes.Unknown").isEqualTo(exception.getTypeId());
    }

    @Test
    void shouldReturnNullPluginIdentifierGivenNullType() {
        Assertions.assertThat((String)PluginDeserializer.extractPluginRawIdentifier((JsonNode)new TextNode(null), (boolean)true)).isNull();
    }

    @Test
    void shouldReturnNullPluginIdentifierGivenEmptyType() {
        Assertions.assertThat((String)PluginDeserializer.extractPluginRawIdentifier((JsonNode)new TextNode(""), (boolean)true)).isNull();
    }

    @Test
    void shouldReturnTypeWithVersionGivenSupportedVersionTrue() {
        ObjectNode jsonNodes = new ObjectNode(new ObjectMapper().getNodeFactory());
        jsonNodes.set("type", (JsonNode)new TextNode("io.kestra.core.plugins.serdes.Unknown"));
        jsonNodes.set("version", (JsonNode)new TextNode("1.0.0"));
        Assertions.assertThat((String)PluginDeserializer.extractPluginRawIdentifier((JsonNode)jsonNodes, (boolean)true)).isEqualTo("io.kestra.core.plugins.serdes.Unknown:1.0.0");
    }

    @Test
    void shouldReturnTypeWithVersionGivenSupportedVersionFalse() {
        ObjectNode jsonNodes = new ObjectNode(new ObjectMapper().getNodeFactory());
        jsonNodes.set("type", (JsonNode)new TextNode("io.kestra.core.plugins.serdes.Unknown"));
        jsonNodes.set("version", (JsonNode)new TextNode("1.0.0"));
        Assertions.assertThat((String)PluginDeserializer.extractPluginRawIdentifier((JsonNode)jsonNodes, (boolean)false)).isEqualTo("io.kestra.core.plugins.serdes.Unknown");
    }

    public record TestPlugin(String type) implements Plugin
    {
    }

    public record TestPluginHolder(Plugin plugin) {
    }
}

