/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.reporter;

import io.kestra.core.reporter.Reportable;
import io.kestra.core.reporter.Schedules;
import java.time.Duration;
import java.time.Instant;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class SchedulesTest {
    SchedulesTest() {
    }

    @Test
    void shouldTriggerAfterPeriodGivenEnoughTimeHasPassed() {
        Reportable.ReportingSchedule schedule = Schedules.every((Duration)Duration.ofHours(1L));
        Instant now = Instant.now();
        boolean firstRun = schedule.shouldRun(now);
        boolean fiveMinutesLater = schedule.shouldRun(now.plus(Duration.ofMinutes(5L)));
        boolean oneHourLater = schedule.shouldRun(now.plus(Duration.ofHours(1L)));
        Assertions.assertThat((boolean)firstRun).isTrue();
        Assertions.assertThat((boolean)fiveMinutesLater).isFalse();
        Assertions.assertThat((boolean)oneHourLater).isTrue();
    }

    @Test
    void shouldNotTriggerGivenPeriodHasNotElapsed() {
        Reportable.ReportingSchedule schedule = Schedules.every((Duration)Duration.ofMinutes(30L));
        Instant now = Instant.now();
        boolean firstRun = schedule.shouldRun(now);
        boolean almost30Minutes = schedule.shouldRun(now.plus(Duration.ofMinutes(29L)));
        Assertions.assertThat((boolean)firstRun).isTrue();
        Assertions.assertThat((boolean)almost30Minutes).isFalse();
    }

    @Test
    void shouldTriggerHourlyGivenOneHourHasElapsed() {
        Reportable.ReportingSchedule schedule = Schedules.hourly();
        Instant now = Instant.now();
        boolean firstRun = schedule.shouldRun(now);
        boolean nextHour = schedule.shouldRun(now.plus(Duration.ofHours(1L)));
        Assertions.assertThat((boolean)firstRun).isTrue();
        Assertions.assertThat((boolean)nextHour).isTrue();
    }

    @Test
    void shouldTriggerDailyGivenOneDayHasElapsed() {
        Reportable.ReportingSchedule schedule = Schedules.daily();
        Instant now = Instant.now();
        boolean firstRun = schedule.shouldRun(now);
        boolean nextDay = schedule.shouldRun(now.plus(Duration.ofDays(1L)));
        Assertions.assertThat((boolean)firstRun).isTrue();
        Assertions.assertThat((boolean)nextDay).isTrue();
    }

    @Test
    void shouldThrowExceptionGivenZeroOrNegativeDuration() {
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> Schedules.every((Duration)Duration.ZERO)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Period must be positive");
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> Schedules.every((Duration)Duration.ofSeconds(-5L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Period must be positive");
    }
}

