/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.reporter.reports;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.reporter.Reportable;
import io.kestra.core.reporter.reports.ServiceUsageReport;
import io.kestra.core.repositories.ServiceInstanceRepositoryInterface;
import io.kestra.core.server.Service;
import io.kestra.core.server.ServiceInstance;
import io.kestra.core.server.ServiceType;
import io.kestra.core.utils.IdUtils;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
public abstract class AbstractServiceUsageReportTest {
    @Inject
    ServiceUsageReport serviceUsageReport;
    @Inject
    ServiceInstanceRepositoryInterface serviceInstanceRepository;

    @Test
    public void shouldGetReport() {
        LocalDate start = LocalDate.of(2025, 1, 1);
        LocalDate end = start.withDayOfMonth(start.getMonth().length(start.isLeapYear()));
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate from = start;
        int days = 0;
        while (from.toEpochDay() < end.toEpochDay()) {
            Instant createAt = from.atStartOfDay(zoneId).toInstant();
            Instant updatedAt = from.atStartOfDay(zoneId).plus(Duration.ofHours(10L)).toInstant();
            ServiceInstance instance = new ServiceInstance(IdUtils.create(), ServiceType.EXECUTOR, Service.ServiceState.INACTIVE, null, createAt, updatedAt, List.of(), null, Map.of(), Set.of());
            instance = instance.state(Service.ServiceState.RUNNING, createAt).state(Service.ServiceState.NOT_RUNNING, updatedAt);
            this.serviceInstanceRepository.save(instance);
            from = from.plusDays(1L);
            ++days;
        }
        Instant now = end.plusDays(1L).atStartOfDay(zoneId).toInstant();
        ServiceUsageReport.ServiceUsageEvent event = this.serviceUsageReport.report(now, Reportable.TimeInterval.of((ZonedDateTime)start.atStartOfDay(zoneId), (ZonedDateTime)end.plusDays(1L).atStartOfDay(zoneId)));
        List statistics = event.services().dailyStatistics();
        Assertions.assertEquals((int)(ServiceType.values().length - 1), (int)statistics.size());
        Assertions.assertEquals((int)days, (int)statistics.stream().filter(it -> it.type().equalsIgnoreCase("EXECUTOR")).findFirst().get().values().size());
    }
}

