/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.reporter.reports;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.reporter.reports.PluginMetricReport;
import io.kestra.plugin.core.http.Trigger;
import io.kestra.plugin.core.log.Log;
import io.kestra.plugin.core.trigger.Schedule;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class PluginMetricReportTest {
    @Inject
    MetricRegistry metricRegistry;
    @Inject
    PluginMetricReport pluginMetricReport;

    PluginMetricReportTest() {
    }

    @Test
    void shouldGetReport() {
        this.metricRegistry.timer("worker.ended.duration", "Task run duration inside the Worker", new String[]{"task_type", Log.class.getName()}).record(() -> Duration.ofSeconds(1L));
        this.metricRegistry.timer("worker.trigger.duration", "Trigger evaluation duration inside the Worker", new String[]{"trigger_type", Trigger.class.getName()}).record(() -> Duration.ofSeconds(1L));
        this.metricRegistry.timer("scheduler.trigger.evaluation.duration", "Trigger evaluation duration for trigger executed inside the Scheduler (Schedulable triggers)", new String[]{"trigger_type", Schedule.class.getName()}).record(() -> Duration.ofSeconds(1L));
        PluginMetricReport.PluginMetricEvent event = (PluginMetricReport.PluginMetricEvent)this.pluginMetricReport.report(Instant.now());
        Assertions.assertThat((List)event.pluginMetrics()).hasSize(3);
    }
}

