/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.reporter.reports;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.Setting;
import io.kestra.core.reporter.reports.SystemInformationReport;
import io.kestra.core.repositories.SettingRepositoryInterface;
import io.micronaut.test.annotation.MockBean;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.ConstraintViolationException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class SystemInformationReportTest {
    @Inject
    private SystemInformationReport systemInformationReport;

    SystemInformationReportTest() {
    }

    @Test
    void shouldGetReport() {
        SystemInformationReport.SystemInformationEvent event = (SystemInformationReport.SystemInformationEvent)this.systemInformationReport.report(Instant.now());
        Assertions.assertThat((String)event.uri()).isEqualTo("https://mysuperhost.com/subpath");
        Assertions.assertThat((Collection)event.environments()).contains((Object[])new String[]{"test"});
        Assertions.assertThat((Instant)event.startTime()).isNotNull();
        Assertions.assertThat((String)event.host().getUuid()).isNotNull();
        Assertions.assertThat((int)event.host().getHardware().getLogicalProcessorCount()).isNotNull();
        Assertions.assertThat((String)event.host().getJvm().getName()).isNotNull();
        Assertions.assertThat((String)event.host().getOs().getFamily()).isNotNull();
        Assertions.assertThat((String)event.configurations().getRepositoryType()).isEqualTo("h2");
        Assertions.assertThat((String)event.configurations().getQueueType()).isEqualTo("h2");
    }

    @MockBean(value=SettingRepositoryInterface.class)
    @Singleton
    static class TestSettingRepository
    implements SettingRepositoryInterface {
        public static Object UUID = null;

        TestSettingRepository() {
        }

        public Optional<Setting> findByKey(String key) {
            return Optional.empty();
        }

        public List<Setting> findAll() {
            return new ArrayList<Setting>();
        }

        public Setting save(Setting setting) throws ConstraintViolationException {
            if (setting.getKey().equals("instance.uuid")) {
                UUID = setting.getValue();
            }
            return setting;
        }

        public Setting delete(Setting setting) {
            return setting;
        }
    }
}

