/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import com.devskiller.friendly_id.FriendlyId;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.InvalidQueryFiltersException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.Label;
import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.dashboards.AggregationType;
import io.kestra.core.models.dashboards.ColumnDescriptor;
import io.kestra.core.models.dashboards.DataFilter;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionKind;
import io.kestra.core.models.executions.ExecutionTrigger;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.statistics.DailyExecutionStatistics;
import io.kestra.core.models.executions.statistics.Flow;
import io.kestra.core.models.flows.FlowScope;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.ExecutionFixture;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.dashboard.data.Executions;
import io.kestra.plugin.core.dashboard.data.IExecutions;
import io.kestra.plugin.core.debug.Return;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import jakarta.inject.Inject;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.slf4j.event.Level;

@KestraTest
public abstract class AbstractExecutionRepositoryTest {
    public static final String NAMESPACE = "io.kestra.unittest";
    public static final String FLOW = "full";
    @Inject
    protected ExecutionRepositoryInterface executionRepository;

    public static Execution.ExecutionBuilder builder(String tenantId, State.Type state, String flowId) {
        return AbstractExecutionRepositoryTest.builder(tenantId, state, flowId, NAMESPACE);
    }

    public static Execution.ExecutionBuilder builder(String tenantId, State.Type state, String flowId, String namespace) {
        State finalState = AbstractExecutionRepositoryTest.randomDuration(state);
        Execution.ExecutionBuilder execution = Execution.builder().id(FriendlyId.createFriendlyId()).namespace(namespace).tenantId(tenantId).flowId(flowId == null ? FLOW : flowId).flowRevision(Integer.valueOf(1)).state(finalState);
        List<TaskRun> taskRuns = Arrays.asList(TaskRun.of((Execution)execution.build(), (ResolvedTask)ResolvedTask.of((Task)((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id("first")).type(Return.class.getName())).format(Property.ofValue((Object)"test")).build())).withState(State.Type.SUCCESS), AbstractExecutionRepositoryTest.spyTaskRun(TaskRun.of((Execution)execution.build(), (ResolvedTask)ResolvedTask.of((Task)((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id("second")).type(Return.class.getName())).format(Property.ofValue((Object)"test")).build())).withState(state), state), TaskRun.of((Execution)execution.build(), (ResolvedTask)ResolvedTask.of((Task)((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id("third")).type(Return.class.getName())).format(Property.ofValue((Object)"test")).build())).withState(state));
        if (flowId == null) {
            return execution.taskRunList(List.of(taskRuns.getFirst(), taskRuns.get(1), taskRuns.get(2)));
        }
        return execution.taskRunList(List.of(taskRuns.getFirst(), taskRuns.get(1)));
    }

    static TaskRun spyTaskRun(TaskRun taskRun, State.Type state) {
        TaskRun spy = (TaskRun)Mockito.spy((Object)taskRun);
        ((TaskRun)Mockito.doReturn((Object)AbstractExecutionRepositoryTest.randomDuration(state)).when((Object)spy)).getState();
        return spy;
    }

    static State randomDuration(State.Type state) {
        State finalState = new State();
        finalState = (State)Mockito.spy((Object)finalState.withState(state != null ? state : State.Type.SUCCESS));
        Random rand = new Random();
        ((State)Mockito.doReturn((Object)Duration.ofSeconds(rand.nextInt(150))).when((Object)finalState)).getDuration();
        return finalState;
    }

    protected void inject(String tenantId) {
        this.inject(tenantId, null);
    }

    protected void inject(String tenantId, String executionTriggerId) {
        ExecutionTrigger executionTrigger = null;
        if (executionTriggerId != null) {
            executionTrigger = ExecutionTrigger.builder().variables(Map.of("executionId", executionTriggerId)).build();
        }
        this.executionRepository.save(AbstractExecutionRepositoryTest.builder(tenantId, State.Type.RUNNING, null).labels(List.of(new Label("key", "value"), new Label("key2", "value2"))).trigger(executionTrigger).build());
        for (int i = 1; i < 28; ++i) {
            this.executionRepository.save(AbstractExecutionRepositoryTest.builder(tenantId, i < 5 ? State.Type.RUNNING : (i < 8 ? State.Type.FAILED : State.Type.SUCCESS), i < 15 ? null : "second").trigger(executionTrigger).build());
        }
        this.executionRepository.save(AbstractExecutionRepositoryTest.builder(tenantId, State.Type.SUCCESS, null).trigger(executionTrigger).kind(ExecutionKind.TEST).build());
    }

    @ParameterizedTest
    @MethodSource(value={"filterCombinations"})
    void should_find_all(QueryFilter filter, int expectedSize) {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.inject(tenant, "executionTriggerId");
        ArrayListTotal entries = this.executionRepository.find(Pageable.UNPAGED, tenant, List.of(filter));
        Assertions.assertThat((List)entries).hasSize(expectedSize);
    }

    static Stream<Arguments> filterCombinations() {
        return Stream.of(Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.QUERY).value((Object)"unittest").operation(QueryFilter.Op.EQUALS).build(), 28}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.SCOPE).value(List.of(FlowScope.USER)).operation(QueryFilter.Op.EQUALS).build(), 28}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).value((Object)NAMESPACE).operation(QueryFilter.Op.EQUALS).build(), 28}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.LABELS).value(Map.of("key", "value")).operation(QueryFilter.Op.EQUALS).build(), 1}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).value((Object)FLOW).operation(QueryFilter.Op.EQUALS).build(), 15}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.START_DATE).value((Object)ZonedDateTime.now().minusMinutes(1L)).operation(QueryFilter.Op.GREATER_THAN).build(), 28}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.END_DATE).value((Object)ZonedDateTime.now().plusMinutes(1L)).operation(QueryFilter.Op.LESS_THAN).build(), 28}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.STATE).value((Object)State.Type.RUNNING).operation(QueryFilter.Op.EQUALS).build(), 5}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).value((Object)"executionTriggerId").operation(QueryFilter.Op.EQUALS).build(), 28}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).value((Object)ExecutionRepositoryInterface.ChildFilter.CHILD).operation(QueryFilter.Op.EQUALS).build(), 28}));
    }

    @ParameterizedTest
    @MethodSource(value={"errorFilterCombinations"})
    void should_fail_to_find_all(QueryFilter filter) {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        org.junit.jupiter.api.Assertions.assertThrows(InvalidQueryFiltersException.class, () -> this.executionRepository.find(Pageable.UNPAGED, tenant, List.of(filter)));
    }

    static Stream<QueryFilter> errorFilterCombinations() {
        return Stream.of(QueryFilter.builder().field(QueryFilter.Field.TIME_RANGE).value((Object)"test").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).value((Object)"test").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).value((Object)"test").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).value((Object)"test").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).value((Object)"test").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).value((Object)Level.DEBUG).operation(QueryFilter.Op.EQUALS).build());
    }

    @Test
    protected void find() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.inject(tenant);
        ArrayListTotal executions = this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, null);
        Assertions.assertThat((long)executions.getTotal()).isEqualTo(28L);
        Assertions.assertThat((int)executions.size()).isEqualTo(10);
        List<QueryFilter> filters = List.of(QueryFilter.builder().field(QueryFilter.Field.STATE).operation(QueryFilter.Op.EQUALS).value(List.of(State.Type.RUNNING, State.Type.FAILED)).build());
        executions = this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, filters);
        Assertions.assertThat((long)executions.getTotal()).isEqualTo(8L);
        filters = List.of(QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.EQUALS).value(Map.of("key", "value")).build());
        executions = this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, filters);
        Assertions.assertThat((long)executions.getTotal()).isEqualTo(1L);
        filters = List.of(QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.EQUALS).value(Map.of("key", "value2")).build());
        executions = this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, filters);
        Assertions.assertThat((long)executions.getTotal()).isEqualTo(0L);
        filters = List.of(QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.EQUALS).value(Map.of("key", "value", "keyTest", "valueTest")).build());
        executions = this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, filters);
        Assertions.assertThat((long)executions.getTotal()).isEqualTo(0L);
        filters = List.of(QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).operation(QueryFilter.Op.EQUALS).value((Object)"second").build());
        executions = this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, filters);
        Assertions.assertThat((long)executions.getTotal()).isEqualTo(13L);
        filters = List.of(QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).operation(QueryFilter.Op.EQUALS).value((Object)"second").build(), QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.EQUALS).value((Object)NAMESPACE).build());
        executions = this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, filters);
        Assertions.assertThat((long)executions.getTotal()).isEqualTo(13L);
        filters = List.of(QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.STARTS_WITH).value((Object)"io.kestra").build());
        executions = this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, filters);
        Assertions.assertThat((long)executions.getTotal()).isEqualTo(28L);
    }

    @Test
    protected void findTriggerExecutionId() {
        String executionTriggerId = IdUtils.create();
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.inject(tenant, executionTriggerId);
        this.inject(tenant);
        List<QueryFilter> filters = List.of(QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).operation(QueryFilter.Op.EQUALS).value((Object)executionTriggerId).build());
        ArrayListTotal executions = this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, filters);
        Assertions.assertThat((long)executions.getTotal()).isEqualTo(28L);
        Assertions.assertThat((int)executions.size()).isEqualTo(10);
        Assertions.assertThat(((Execution)executions.getFirst()).getTrigger().getVariables().get("executionId")).isEqualTo((Object)executionTriggerId);
        filters = List.of(QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).operation(QueryFilter.Op.EQUALS).value((Object)ExecutionRepositoryInterface.ChildFilter.CHILD).build());
        executions = this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, filters);
        Assertions.assertThat((long)executions.getTotal()).isEqualTo(28L);
        Assertions.assertThat((int)executions.size()).isEqualTo(10);
        Assertions.assertThat(((Execution)executions.getFirst()).getTrigger().getVariables().get("executionId")).isEqualTo((Object)executionTriggerId);
        filters = List.of(QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).operation(QueryFilter.Op.EQUALS).value((Object)ExecutionRepositoryInterface.ChildFilter.MAIN).build());
        executions = this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, filters);
        Assertions.assertThat((long)executions.getTotal()).isEqualTo(28L);
        Assertions.assertThat((int)executions.size()).isEqualTo(10);
        Assertions.assertThat((Object)((Execution)executions.getFirst()).getTrigger()).isNull();
        executions = this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, null);
        Assertions.assertThat((long)executions.getTotal()).isEqualTo(56L);
    }

    @Test
    protected void findWithSort() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.inject(tenant);
        ArrayListTotal executions = this.executionRepository.find(Pageable.from((int)1, (int)10, (Sort)Sort.of((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"id")})), tenant, null);
        Assertions.assertThat((long)executions.getTotal()).isEqualTo(28L);
        Assertions.assertThat((int)executions.size()).isEqualTo(10);
        List<QueryFilter> filters = List.of(QueryFilter.builder().field(QueryFilter.Field.STATE).operation(QueryFilter.Op.EQUALS).value(List.of(State.Type.RUNNING, State.Type.FAILED)).build());
        executions = this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, filters);
        Assertions.assertThat((long)executions.getTotal()).isEqualTo(8L);
    }

    @Test
    protected void findById() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Execution execution1 = ExecutionFixture.EXECUTION_1(tenant);
        this.executionRepository.save(execution1);
        Optional full = this.executionRepository.findById(tenant, execution1.getId());
        Assertions.assertThat((boolean)full.isPresent()).isTrue();
        full.ifPresent(current -> Assertions.assertThat((String)((Execution)full.get()).getId()).isEqualTo(execution1.getId()));
    }

    @Test
    protected void shouldFindByIdTestExecution() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Execution executionTest = ExecutionFixture.EXECUTION_TEST(tenant);
        this.executionRepository.save(executionTest);
        Optional full = this.executionRepository.findById(tenant, executionTest.getId());
        Assertions.assertThat((boolean)full.isPresent()).isTrue();
        full.ifPresent(current -> Assertions.assertThat((String)((Execution)full.get()).getId()).isEqualTo(executionTest.getId()));
    }

    @Test
    protected void purge() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Execution execution1 = ExecutionFixture.EXECUTION_1(tenant);
        this.executionRepository.save(execution1);
        Optional full = this.executionRepository.findById(tenant, execution1.getId());
        Assertions.assertThat((boolean)full.isPresent()).isTrue();
        this.executionRepository.purge(execution1);
        full = this.executionRepository.findById(tenant, execution1.getId());
        Assertions.assertThat((boolean)full.isPresent()).isFalse();
    }

    @Test
    protected void purgeExecutions() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Execution execution1 = ExecutionFixture.EXECUTION_1(tenant);
        this.executionRepository.save(execution1);
        Execution execution2 = ExecutionFixture.EXECUTION_2(tenant);
        this.executionRepository.save(execution2);
        Integer results = this.executionRepository.purge(List.of(execution1, execution2));
        Assertions.assertThat((Integer)results).isEqualTo(2);
        Assertions.assertThat((Optional)this.executionRepository.findById(tenant, execution1.getId())).isEmpty();
        Assertions.assertThat((Optional)this.executionRepository.findById(tenant, execution2.getId())).isEmpty();
    }

    @Test
    protected void delete() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Execution execution1 = ExecutionFixture.EXECUTION_1(tenant);
        this.executionRepository.save(execution1);
        Optional full = this.executionRepository.findById(tenant, execution1.getId());
        Assertions.assertThat((boolean)full.isPresent()).isTrue();
        this.executionRepository.delete(execution1);
        full = this.executionRepository.findById(tenant, execution1.getId());
        Assertions.assertThat((boolean)full.isPresent()).isFalse();
    }

    @Test
    protected void mappingConflict() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.executionRepository.save(ExecutionFixture.EXECUTION_2(tenant));
        this.executionRepository.save(ExecutionFixture.EXECUTION_1(tenant));
        ArrayListTotal page1 = this.executionRepository.findByFlowId(tenant, NAMESPACE, FLOW, Pageable.from((int)1, (int)10));
        Assertions.assertThat((int)page1.size()).isEqualTo(2);
    }

    @Test
    protected void dailyStatistics() throws InterruptedException {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        for (int i = 0; i < 28; ++i) {
            this.executionRepository.save(AbstractExecutionRepositoryTest.builder(tenant, i < 5 ? State.Type.RUNNING : (i < 8 ? State.Type.FAILED : State.Type.SUCCESS), i < 15 ? null : "second").build());
        }
        this.executionRepository.save(AbstractExecutionRepositoryTest.builder(tenant, State.Type.SUCCESS, "second").namespace("system").build());
        Thread.sleep(500L);
        List result = this.executionRepository.dailyStatistics(null, tenant, null, null, null, ZonedDateTime.now().minusDays(10L), ZonedDateTime.now(), null, null);
        Assertions.assertThat((int)result.size()).isEqualTo(11);
        Assertions.assertThat((int)((DailyExecutionStatistics)result.get(10)).getExecutionCounts().size()).isEqualTo(11);
        Assertions.assertThat((long)((DailyExecutionStatistics)result.get(10)).getDuration().getAvg().toMillis()).isGreaterThan(0L);
        Assertions.assertThat((Long)((Long)((DailyExecutionStatistics)result.get(10)).getExecutionCounts().get(State.Type.FAILED))).isEqualTo(3L);
        Assertions.assertThat((Long)((Long)((DailyExecutionStatistics)result.get(10)).getExecutionCounts().get(State.Type.RUNNING))).isEqualTo(5L);
        Assertions.assertThat((Long)((Long)((DailyExecutionStatistics)result.get(10)).getExecutionCounts().get(State.Type.SUCCESS))).isEqualTo(21L);
        result = this.executionRepository.dailyStatistics(null, tenant, List.of(FlowScope.USER, FlowScope.SYSTEM), null, null, ZonedDateTime.now().minusDays(10L), ZonedDateTime.now(), null, null);
        Assertions.assertThat((int)result.size()).isEqualTo(11);
        Assertions.assertThat((Long)((Long)((DailyExecutionStatistics)result.get(10)).getExecutionCounts().get(State.Type.SUCCESS))).isEqualTo(21L);
        result = this.executionRepository.dailyStatistics(null, tenant, List.of(FlowScope.USER), null, null, ZonedDateTime.now().minusDays(10L), ZonedDateTime.now(), null, null);
        Assertions.assertThat((int)result.size()).isEqualTo(11);
        Assertions.assertThat((Long)((Long)((DailyExecutionStatistics)result.get(10)).getExecutionCounts().get(State.Type.SUCCESS))).isEqualTo(20L);
        result = this.executionRepository.dailyStatistics(null, tenant, List.of(FlowScope.SYSTEM), null, null, ZonedDateTime.now().minusDays(10L), ZonedDateTime.now(), null, null);
        Assertions.assertThat((int)result.size()).isEqualTo(11);
        Assertions.assertThat((Long)((Long)((DailyExecutionStatistics)result.get(10)).getExecutionCounts().get(State.Type.SUCCESS))).isEqualTo(1L);
    }

    @Test
    protected void executionsCount() throws InterruptedException {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        for (int i = 0; i < 14; ++i) {
            this.executionRepository.save(AbstractExecutionRepositoryTest.builder(tenant, State.Type.SUCCESS, i < 2 ? "first" : (i < 5 ? "second" : "third")).build());
        }
        Thread.sleep(500L);
        List result = this.executionRepository.executionCounts(tenant, List.of(new Flow(NAMESPACE, "first"), new Flow(NAMESPACE, "second"), new Flow(NAMESPACE, "third"), new Flow(NAMESPACE, "missing")), null, ZonedDateTime.now().minusDays(10L), ZonedDateTime.now(), null);
        Assertions.assertThat((int)result.size()).isEqualTo(4);
        Assertions.assertThat((Long)result.stream().filter(executionCount -> executionCount.getFlowId().equals("first")).findFirst().get().getCount()).isEqualTo(2L);
        Assertions.assertThat((Long)result.stream().filter(executionCount -> executionCount.getFlowId().equals("second")).findFirst().get().getCount()).isEqualTo(3L);
        Assertions.assertThat((Long)result.stream().filter(executionCount -> executionCount.getFlowId().equals("third")).findFirst().get().getCount()).isEqualTo(9L);
        Assertions.assertThat((Long)result.stream().filter(executionCount -> executionCount.getFlowId().equals("missing")).findFirst().get().getCount()).isEqualTo(0L);
        result = this.executionRepository.executionCounts(tenant, List.of(new Flow(NAMESPACE, "first"), new Flow(NAMESPACE, "second"), new Flow(NAMESPACE, "third")), List.of(State.Type.SUCCESS), null, null, null);
        Assertions.assertThat((int)result.size()).isEqualTo(3);
        Assertions.assertThat((Long)result.stream().filter(executionCount -> executionCount.getFlowId().equals("first")).findFirst().get().getCount()).isEqualTo(2L);
        Assertions.assertThat((Long)result.stream().filter(executionCount -> executionCount.getFlowId().equals("second")).findFirst().get().getCount()).isEqualTo(3L);
        Assertions.assertThat((Long)result.stream().filter(executionCount -> executionCount.getFlowId().equals("third")).findFirst().get().getCount()).isEqualTo(9L);
        result = this.executionRepository.executionCounts(tenant, null, null, null, null, List.of(NAMESPACE));
        Assertions.assertThat((int)result.size()).isEqualTo(1);
        Assertions.assertThat((Long)result.stream().filter(executionCount -> executionCount.getNamespace().equals(NAMESPACE)).findFirst().get().getCount()).isEqualTo(14L);
    }

    @Test
    protected void update() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Execution execution = ExecutionFixture.EXECUTION_1(tenant);
        this.executionRepository.save(execution);
        Label label = new Label("key", "value");
        Execution updated = execution.toBuilder().labels(List.of(label)).build();
        this.executionRepository.update(updated);
        Optional validation = this.executionRepository.findById(tenant, updated.getId());
        Assertions.assertThat((boolean)validation.isPresent()).isTrue();
        Assertions.assertThat((int)((Execution)validation.get()).getLabels().size()).isEqualTo(1);
        Assertions.assertThat((Object)((Label)((Execution)validation.get()).getLabels().getFirst())).isEqualTo((Object)label);
    }

    @Test
    void shouldFindLatestExecutionGivenState() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Execution earliest = AbstractExecutionRepositoryTest.buildWithCreatedDate(tenant, Instant.now().minus(Duration.ofMinutes(10L)));
        Execution latest = AbstractExecutionRepositoryTest.buildWithCreatedDate(tenant, Instant.now().minus(Duration.ofMinutes(5L)));
        this.executionRepository.save(earliest);
        this.executionRepository.save(latest);
        Optional result = this.executionRepository.findLatestForStates(tenant, NAMESPACE, FLOW, List.of(State.Type.CREATED));
        Assertions.assertThat((boolean)result.isPresent()).isTrue();
        Assertions.assertThat((String)((Execution)result.get()).getId()).isEqualTo(latest.getId());
    }

    @Test
    protected void fetchData() throws IOException {
        String tenantId = "data-tenant";
        Execution execution = Execution.builder().tenantId(tenantId).id(IdUtils.create()).namespace(NAMESPACE).flowId("some-execution").flowRevision(Integer.valueOf(1)).labels(Label.from(Map.of("country", "FR"))).state(new State(State.Type.CREATED, List.of(new State.History(State.Type.CREATED, Instant.now())))).taskRunList(List.of()).build();
        execution = this.executionRepository.save(execution);
        ArrayListTotal data = this.executionRepository.fetchData(tenantId, (DataFilter)((Executions.ExecutionsBuilder)((Executions.ExecutionsBuilder)Executions.builder().type(Executions.class.getName())).columns(Map.of("count", ColumnDescriptor.builder().field((Enum)IExecutions.Fields.ID).agg(AggregationType.COUNT).build(), "country", ColumnDescriptor.builder().field((Enum)IExecutions.Fields.LABELS).labelKey("country").build(), "date", ColumnDescriptor.builder().field((Enum)IExecutions.Fields.START_DATE).build()))).build(), ZonedDateTime.now().minus(1L, ChronoUnit.HOURS), ZonedDateTime.now(), null);
        Assertions.assertThat((long)data.getTotal()).isEqualTo(1L);
        Assertions.assertThat(((Map)data.get(0)).get("count")).isEqualTo((Object)1L);
        Assertions.assertThat(((Map)data.get(0)).get("country")).isEqualTo((Object)"FR");
        Instant startDate = execution.getState().getStartDate();
        Assertions.assertThat(((Map)data.get(0)).get("date")).isEqualTo((Object)DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(ZonedDateTime.ofInstant(startDate, ZoneId.systemDefault()).withSecond(0).withNano(0)));
    }

    private static Execution buildWithCreatedDate(String tenant, Instant instant) {
        return Execution.builder().id(IdUtils.create()).namespace(NAMESPACE).tenantId(tenant).flowId(FLOW).flowRevision(Integer.valueOf(1)).state(new State(State.Type.CREATED, List.of(new State.History(State.Type.CREATED, instant)))).inputs((Map)ImmutableMap.of((Object)"test", (Object)"value")).taskRunList(List.of()).build();
    }

    @Test
    protected void findAllAsync() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.inject(tenant);
        List executions = (List)this.executionRepository.findAllAsync(tenant).collectList().block();
        Assertions.assertThat((List)executions).hasSize(29);
    }

    @Test
    protected void shouldFindByLabel() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Execution exec1 = this.executionRepository.save(AbstractExecutionRepositoryTest.builder(tenant, State.Type.RUNNING, null).labels(List.of(new Label("labelkey1", "labelvalue1"))).build());
        Execution exec2 = this.executionRepository.save(AbstractExecutionRepositoryTest.builder(tenant, State.Type.RUNNING, null).labels(List.of(new Label("labelkey2", "labelvalue2"))).build());
        Execution exec3 = this.executionRepository.save(AbstractExecutionRepositoryTest.builder(tenant, State.Type.RUNNING, null).labels(List.of(new Label("labelkey2", "labelvalue2"), new Label("labelkey3", "labelvalue3"))).build());
        ((ListAssert)((ListAssert)Assertions.assertThat((List)this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, List.of(QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.EQUALS).value(Map.of("labelkey1", "labelvalue1")).build()))).as("find execution EQUALS LABELS", new Object[0])).usingRecursiveFieldByFieldElementComparatorOnFields(new String[]{"id"})).containsOnly((Object[])new Execution[]{exec1});
        ((ListAssert)Assertions.assertThat((List)this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, List.of(QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.EQUALS).value(Map.of("unexisting_label", "unexisting_value")).build()))).as("find no execution EQUALS non existing LABELS", new Object[0])).isEmpty();
        ((ListAssert)Assertions.assertThat((List)this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, List.of(QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.EQUALS).value(Map.of("labelkey1", "labelvalue1", "keyother", "valueother")).build()))).as("find no execution that EQUALS labelA AND labelB", new Object[0])).isEmpty();
        ((ListAssert)((ListAssert)Assertions.assertThat((List)this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, List.of(QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.NOT_EQUALS).value(Map.of("labelkey1", "labelvalue1")).build()))).as("find execution NOT_EQUALS LABELS", new Object[0])).usingRecursiveFieldByFieldElementComparatorOnFields(new String[]{"id"})).containsOnly((Object[])new Execution[]{exec2, exec3});
        ((ListAssert)((ListAssert)Assertions.assertThat((List)this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, List.of(QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.IN).value(Map.of("labelkey1", "labelvalue1", "labelkey3", "labelvalue3", "keyother", "valueother")).build()))).as("find two execution IN LABELS", new Object[0])).usingRecursiveFieldByFieldElementComparatorOnFields(new String[]{"id"})).containsOnly((Object[])new Execution[]{exec1, exec3});
        ((ListAssert)((ListAssert)Assertions.assertThat((List)this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, List.of(QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.NOT_IN).value(Map.of("labelkey2", "labelvalue2")).build()))).as("find one execution NOT IN LABELS", new Object[0])).usingRecursiveFieldByFieldElementComparatorOnFields(new String[]{"id"})).containsOnly((Object[])new Execution[]{exec1});
        ((ListAssert)((ListAssert)Assertions.assertThat((List)this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, List.of(QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.CONTAINS).value((Object)"alue2").build()))).as("find execution CONTAINS LABELS value", new Object[0])).usingRecursiveFieldByFieldElementComparatorOnFields(new String[]{"id"})).containsOnly((Object[])new Execution[]{exec2, exec3});
        ((ListAssert)((ListAssert)Assertions.assertThat((List)this.executionRepository.find(Pageable.from((int)1, (int)10), tenant, List.of(QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.CONTAINS).value((Object)"ey1").build()))).as("find execution CONTAINS LABELS key", new Object[0])).usingRecursiveFieldByFieldElementComparatorOnFields(new String[]{"id"})).containsOnly((Object[])new Execution[]{exec1});
    }

    @Test
    protected void shouldReturnLastExecutionsWhenInputsAreNull() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.inject(tenant);
        List lastExecutions = this.executionRepository.lastExecutions(tenant, null);
        Assertions.assertThat((List)lastExecutions).isNotEmpty();
        Set flowIds = lastExecutions.stream().map(Execution::getFlowId).collect(Collectors.toSet());
        Assertions.assertThat((int)flowIds.size()).isEqualTo(lastExecutions.size());
    }

    @Test
    protected void shouldIncludeRunningExecutionsInLastExecutions() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Instant older = Instant.now().minus(Duration.ofMinutes(10L));
        State finishedState = new State(State.Type.SUCCESS, List.of(new State.History(State.Type.CREATED, older.minus(Duration.ofMinutes(1L))), new State.History(State.Type.SUCCESS, older)));
        Execution finished = Execution.builder().id(IdUtils.create()).tenantId(tenant).namespace(NAMESPACE).flowId(FLOW).flowRevision(Integer.valueOf(1)).state(finishedState).taskRunList(List.of()).build();
        this.executionRepository.save(finished);
        Instant newer = Instant.now().minus(Duration.ofMinutes(2L));
        State runningState = new State(State.Type.RUNNING, List.of(new State.History(State.Type.CREATED, newer), new State.History(State.Type.RUNNING, newer)));
        Execution running = Execution.builder().id(IdUtils.create()).tenantId(tenant).namespace(NAMESPACE).flowId(FLOW).flowRevision(Integer.valueOf(1)).state(runningState).taskRunList(List.of()).build();
        this.executionRepository.save(running);
        List last = this.executionRepository.lastExecutions(tenant, null);
        Map<String, Execution> byFlow = last.stream().collect(Collectors.toMap(Execution::getFlowId, e -> e));
        Assertions.assertThat((Object)byFlow.get(FLOW)).isNotNull();
        Assertions.assertThat((String)byFlow.get(FLOW).getId()).isEqualTo(running.getId());
    }
}

