/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.repositories.LogRepositoryInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.services.ExecutionService;
import io.kestra.core.utils.IdUtils;
import io.kestra.plugin.core.debug.Return;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.event.Level;

@KestraTest
public abstract class AbstractExecutionServiceTest {
    @Inject
    ExecutionService executionService;
    @Inject
    ExecutionRepositoryInterface executionRepository;
    @Inject
    LogRepositoryInterface logRepository;
    @Inject
    RunContextFactory runContextFactory;

    @Test
    void purge() throws Exception {
        URL resource = AbstractExecutionServiceTest.class.getClassLoader().getResource("application-test.yml");
        File tempFile = File.createTempFile("test", "");
        Files.copy(new FileInputStream(Objects.requireNonNull(resource).getFile()), tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        State state = new State().withState(State.Type.RUNNING).withState(State.Type.SUCCESS);
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("io.kestra.test")).id("abc")).tenantId("main")).revision(Integer.valueOf(1))).build();
        Execution execution = Execution.builder().id(IdUtils.create()).tenantId("main").state(state).flowId(flow.getId()).namespace(flow.getNamespace()).flowRevision(flow.getRevision()).build();
        Return task = ((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id(IdUtils.create())).type(Return.class.getName())).build();
        TaskRun taskRun = TaskRun.builder().namespace(flow.getNamespace()).id(IdUtils.create()).tenantId("main").executionId(execution.getId()).flowId(flow.getId()).taskId(task.getId()).state(state).build();
        RunContext runContext = this.runContextFactory.of((FlowInterface)flow, (Task)task, execution, taskRun);
        execution.withInputs(Map.of("test", runContext.storage().putFile(tempFile)));
        this.executionRepository.save(execution);
        for (int i = 0; i < 10; ++i) {
            this.logRepository.save(LogEntry.builder().executionId(execution.getId()).tenantId("main").timestamp(Instant.now()).message("Message " + i).flowId(flow.getId()).level(Level.INFO).namespace(flow.getNamespace()).build());
        }
        ExecutionService.PurgeResult purge = this.executionService.purge(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), "main", flow.getNamespace(), flow.getId(), null, ZonedDateTime.now(), null, 100);
        Assertions.assertThat((int)purge.getExecutionsCount()).isEqualTo(1);
        Assertions.assertThat((int)purge.getLogsCount()).isEqualTo(10);
        Assertions.assertThat((int)purge.getStoragesCount()).isEqualTo(5);
        purge = this.executionService.purge(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), "main", flow.getNamespace(), flow.getId(), null, ZonedDateTime.now(), null, 100);
        Assertions.assertThat((int)purge.getExecutionsCount()).isZero();
    }
}

