/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.events.CrudEvent;
import io.kestra.core.events.CrudEventType;
import io.kestra.core.exceptions.InvalidQueryFiltersException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.Label;
import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionTrigger;
import io.kestra.core.models.flows.AbstractFlow;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowScope;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.flows.GenericFlow;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.flows.Type;
import io.kestra.core.models.flows.input.StringInput;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.PollingTriggerInterface;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.services.FlowService;
import io.kestra.core.utils.Await;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.debug.Return;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.ConstraintViolationException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.event.Level;

@KestraTest
public abstract class AbstractFlowRepositoryTest {
    public static final String TEST_NAMESPACE = "io.kestra.unittest";
    public static final String TEST_FLOW_ID = "test";
    @Inject
    protected FlowRepositoryInterface flowRepository;
    @Inject
    protected ExecutionRepositoryInterface executionRepository;
    protected static int COUNTER = 0;

    @BeforeAll
    protected static void init() {
        FlowListener.reset();
    }

    private static FlowWithSource.FlowWithSourceBuilder<?, ?> builder(String tenantId) {
        return AbstractFlowRepositoryTest.builder(tenantId, IdUtils.create(), TEST_FLOW_ID);
    }

    private static FlowWithSource.FlowWithSourceBuilder<?, ?> builder(String tenantId, String flowId, String taskId) {
        return (FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)FlowWithSource.builder().tenantId(tenantId)).id(flowId)).namespace(TEST_NAMESPACE)).tasks(Collections.singletonList(((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id(taskId)).type(Return.class.getName())).format(Property.ofValue((Object)TEST_FLOW_ID)).build()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"filterCombinations"})
    void should_find_all(QueryFilter filter) {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)FlowWithSource.builder().id("filterFlowId")).namespace("system")).tenantId(tenant)).labels(Label.from(Map.of("key", "value")))).build();
        flow = this.flowRepository.create(GenericFlow.of((FlowInterface)flow));
        try {
            ArrayListTotal entries = this.flowRepository.find(Pageable.UNPAGED, tenant, List.of(filter));
            Assertions.assertThat((List)entries).hasSize(1);
        }
        finally {
            this.deleteFlow((Flow)flow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"filterCombinations"})
    void should_find_all_with_source(QueryFilter filter) {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)FlowWithSource.builder().id("filterFlowId")).namespace("system")).tenantId(tenant)).labels(Label.from(Map.of("key", "value")))).build();
        flow = this.flowRepository.create(GenericFlow.of((FlowInterface)flow));
        try {
            ArrayListTotal entries = this.flowRepository.findWithSource(Pageable.UNPAGED, tenant, List.of(filter));
            Assertions.assertThat((List)entries).hasSize(1);
        }
        finally {
            this.deleteFlow((Flow)flow);
        }
    }

    static Stream<QueryFilter> filterCombinations() {
        return Stream.of(QueryFilter.builder().field(QueryFilter.Field.QUERY).value((Object)"filterFlowId").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.SCOPE).value(List.of(FlowScope.SYSTEM)).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).value((Object)"system").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.LABELS).value(Map.of("key", "value")).operation(QueryFilter.Op.EQUALS).build());
    }

    @ParameterizedTest
    @MethodSource(value={"errorFilterCombinations"})
    void should_fail_to_find_all(QueryFilter filter) {
        org.junit.jupiter.api.Assertions.assertThrows(InvalidQueryFiltersException.class, () -> this.flowRepository.find(Pageable.UNPAGED, TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()}), List.of(filter)));
    }

    @ParameterizedTest
    @MethodSource(value={"errorFilterCombinations"})
    void should_fail_to_find_all_with_source(QueryFilter filter) {
        org.junit.jupiter.api.Assertions.assertThrows(InvalidQueryFiltersException.class, () -> this.flowRepository.findWithSource(Pageable.UNPAGED, TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()}), List.of(filter)));
    }

    static Stream<QueryFilter> errorFilterCombinations() {
        return Stream.of(QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).value((Object)"sleep").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.START_DATE).value((Object)ZonedDateTime.now().minusMinutes(1L)).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.builder().field(QueryFilter.Field.END_DATE).value((Object)ZonedDateTime.now().plusMinutes(1L)).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.builder().field(QueryFilter.Field.STATE).value((Object)State.Type.RUNNING).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.TIME_RANGE).value((Object)TEST_FLOW_ID).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).value((Object)"executionTriggerId").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).value((Object)TEST_FLOW_ID).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).value((Object)TEST_FLOW_ID).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).value((Object)ExecutionRepositoryInterface.ChildFilter.CHILD).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).value((Object)TEST_FLOW_ID).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).value((Object)TEST_FLOW_ID).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).value((Object)Level.DEBUG).operation(QueryFilter.Op.EQUALS).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void findById() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)AbstractFlowRepositoryTest.builder(tenant).revision(Integer.valueOf(3))).build();
        flow = this.flowRepository.create(GenericFlow.of((FlowInterface)flow));
        try {
            Optional full = this.flowRepository.findById(tenant, flow.getNamespace(), flow.getId());
            Assertions.assertThat((boolean)full.isPresent()).isTrue();
            Assertions.assertThat((Integer)((Flow)full.get()).getRevision()).isEqualTo(1);
            full = this.flowRepository.findById(tenant, flow.getNamespace(), flow.getId(), Optional.empty());
            Assertions.assertThat((boolean)full.isPresent()).isTrue();
        }
        finally {
            this.deleteFlow((Flow)flow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void findByIdWithoutAcl() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)AbstractFlowRepositoryTest.builder(tenant).tenantId(tenant)).revision(Integer.valueOf(3))).build();
        flow = this.flowRepository.create(GenericFlow.of((FlowInterface)flow));
        try {
            Optional full = this.flowRepository.findByIdWithoutAcl(tenant, flow.getNamespace(), flow.getId(), Optional.empty());
            Assertions.assertThat((boolean)full.isPresent()).isTrue();
            Assertions.assertThat((Integer)((Flow)full.get()).getRevision()).isEqualTo(1);
            full = this.flowRepository.findByIdWithoutAcl(tenant, flow.getNamespace(), flow.getId(), Optional.empty());
            Assertions.assertThat((boolean)full.isPresent()).isTrue();
        }
        finally {
            this.deleteFlow((Flow)flow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void findByIdWithSource() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)AbstractFlowRepositoryTest.builder(tenant).tenantId(tenant)).revision(Integer.valueOf(3))).build();
        String source = "# comment\n" + flow.sourceOrGenerateIfNull();
        flow = this.flowRepository.create(GenericFlow.fromYaml((String)tenant, (String)source));
        try {
            Optional full = this.flowRepository.findByIdWithSource(tenant, flow.getNamespace(), flow.getId());
            Assertions.assertThat((boolean)full.isPresent()).isTrue();
            full.ifPresent(current -> {
                Assertions.assertThat((Integer)((FlowWithSource)full.get()).getRevision()).isEqualTo(1);
                Assertions.assertThat((String)((FlowWithSource)full.get()).getSource()).contains(new CharSequence[]{"# comment"});
                Assertions.assertThat((String)((FlowWithSource)full.get()).getSource()).doesNotContain(new CharSequence[]{"revision:"});
            });
        }
        finally {
            this.deleteFlow((Flow)flow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void save() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)AbstractFlowRepositoryTest.builder(tenant).revision(Integer.valueOf(12))).build();
        FlowWithSource save = this.flowRepository.create(GenericFlow.of((FlowInterface)flow));
        try {
            Assertions.assertThat((Integer)save.getRevision()).isEqualTo(1);
        }
        finally {
            this.deleteFlow((Flow)save);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void saveNoRevision() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        FlowWithSource flow = AbstractFlowRepositoryTest.builder(tenant).build();
        FlowWithSource save = this.flowRepository.create(GenericFlow.of((FlowInterface)flow));
        try {
            Assertions.assertThat((Integer)save.getRevision()).isEqualTo(1);
        }
        finally {
            this.deleteFlow((Flow)save);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void findByNamespaceWithSource() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)AbstractFlowRepositoryTest.builder(tenant).revision(Integer.valueOf(3))).build();
        String flowSource = "# comment\n" + flow.sourceOrGenerateIfNull();
        flow = this.flowRepository.create(GenericFlow.fromYaml((String)tenant, (String)flowSource));
        try {
            List save = this.flowRepository.findByNamespaceWithSource(tenant, flow.getNamespace());
            Assertions.assertThat((long)save.size()).isEqualTo(1L);
            Assertions.assertThat((String)((FlowWithSource)save.getFirst()).getSource()).isEqualTo(FlowService.cleanupSource((String)flowSource));
        }
        finally {
            this.deleteFlow((Flow)flow);
        }
    }

    @Test
    void delete() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)AbstractFlowRepositoryTest.builder(tenant).tenantId(tenant)).build();
        FlowWithSource save = this.flowRepository.create(GenericFlow.of((FlowInterface)flow));
        try {
            Assertions.assertThat((boolean)this.flowRepository.findById(tenant, save.getNamespace(), save.getId()).isPresent()).isTrue();
        }
        catch (Throwable e) {
            this.deleteFlow((Flow)save);
            throw e;
        }
        FlowWithSource delete = this.flowRepository.delete((FlowInterface)save);
        Assertions.assertThat((boolean)this.flowRepository.findById(tenant, flow.getNamespace(), flow.getId()).isPresent()).isFalse();
        Assertions.assertThat((boolean)this.flowRepository.findById(tenant, flow.getNamespace(), flow.getId(), Optional.of(save.getRevision())).isPresent()).isTrue();
        List revisions = this.flowRepository.findRevisions(tenant, flow.getNamespace(), flow.getId());
        Assertions.assertThat((Integer)((FlowWithSource)revisions.getLast()).getRevision()).isEqualTo((Object)delete.getRevision());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void updateConflict() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        String flowId = IdUtils.create();
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id(flowId)).namespace(TEST_NAMESPACE)).tenantId(tenant)).inputs(List.of(((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().type(Type.STRING)).id("a")).build()))).tasks(Collections.singletonList(((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id(TEST_FLOW_ID)).type(Return.class.getName())).format(Property.ofValue((Object)TEST_FLOW_ID)).build())).build();
        FlowWithSource save = this.flowRepository.create(GenericFlow.of((FlowInterface)flow));
        try {
            Assertions.assertThat((boolean)this.flowRepository.findById(tenant, flow.getNamespace(), flow.getId()).isPresent()).isTrue();
            Flow update = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id(IdUtils.create())).namespace("io.kestra.unittest2")).tenantId(tenant)).inputs(List.of(((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().type(Type.STRING)).id("b")).build()))).tasks(Collections.singletonList(((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id(TEST_FLOW_ID)).type(Return.class.getName())).format(Property.ofValue((Object)TEST_FLOW_ID)).build())).build();
            ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.flowRepository.update(GenericFlow.of((FlowInterface)update), (FlowInterface)flow));
            Assertions.assertThat((int)e.getConstraintViolations().size()).isEqualTo(2);
        }
        finally {
            this.deleteFlow((Flow)save);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeTrigger() throws TimeoutException {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        String flowId = IdUtils.create();
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id(flowId)).namespace(TEST_NAMESPACE)).tenantId(tenant)).triggers(Collections.singletonList(((UnitTest.UnitTestBuilder)((UnitTest.UnitTestBuilder)UnitTest.builder().id("sleep")).type(UnitTest.class.getName())).build())).tasks(Collections.singletonList(((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id(TEST_FLOW_ID)).type(Return.class.getName())).format(Property.ofValue((Object)TEST_FLOW_ID)).build())).build();
        flow = this.flowRepository.create(GenericFlow.of((FlowInterface)flow));
        try {
            Assertions.assertThat((boolean)this.flowRepository.findById(tenant, flow.getNamespace(), flow.getId()).isPresent()).isTrue();
            Flow update = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id(flowId)).namespace(TEST_NAMESPACE)).tenantId(tenant)).tasks(Collections.singletonList(((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id(TEST_FLOW_ID)).type(Return.class.getName())).format(Property.ofValue((Object)TEST_FLOW_ID)).build())).build();
            FlowWithSource updated = this.flowRepository.update(GenericFlow.of((FlowInterface)update), (FlowInterface)flow);
            Assertions.assertThat((List)updated.getTriggers()).isNull();
        }
        finally {
            this.deleteFlow(flow);
        }
        Await.until(() -> FlowListener.filterByTenant(tenant).size() == 3, (Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(5L));
        Assertions.assertThat((long)FlowListener.filterByTenant(tenant).stream().filter(r -> r.getType() == CrudEventType.CREATE).count()).isEqualTo(1L);
        Assertions.assertThat((long)FlowListener.filterByTenant(tenant).stream().filter(r -> r.getType() == CrudEventType.UPDATE).count()).isEqualTo(1L);
        Assertions.assertThat((long)FlowListener.filterByTenant(tenant).stream().filter(r -> r.getType() == CrudEventType.DELETE).count()).isEqualTo(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void removeTriggerDelete() throws TimeoutException {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        String flowId = IdUtils.create();
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id(flowId)).namespace(TEST_NAMESPACE)).tenantId(tenant)).triggers(Collections.singletonList(((UnitTest.UnitTestBuilder)((UnitTest.UnitTestBuilder)UnitTest.builder().id("sleep")).type(UnitTest.class.getName())).build())).tasks(Collections.singletonList(((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id(TEST_FLOW_ID)).type(Return.class.getName())).format(Property.ofValue((Object)TEST_FLOW_ID)).build())).build();
        FlowWithSource save = this.flowRepository.create(GenericFlow.of((FlowInterface)flow));
        try {
            Assertions.assertThat((boolean)this.flowRepository.findById(tenant, flow.getNamespace(), flow.getId()).isPresent()).isTrue();
        }
        finally {
            this.deleteFlow((Flow)save);
        }
        Await.until(() -> FlowListener.filterByTenant(tenant).size() == 2, (Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(5L));
        Assertions.assertThat((long)FlowListener.filterByTenant(tenant).stream().filter(r -> r.getType() == CrudEventType.CREATE).count()).isEqualTo(1L);
        Assertions.assertThat((long)FlowListener.filterByTenant(tenant).stream().filter(r -> r.getType() == CrudEventType.DELETE).count()).isEqualTo(1L);
    }

    @Test
    protected void shouldReturnNullRevisionForNonExistingFlow() {
        Assertions.assertThat((Integer)this.flowRepository.lastRevision(TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()}), TEST_NAMESPACE, IdUtils.create())).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    protected void shouldReturnLastRevisionOnCreate() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        ArrayList<FlowWithSource> toDelete = new ArrayList<FlowWithSource>();
        String flowId = IdUtils.create();
        try {
            toDelete.add(this.flowRepository.create(AbstractFlowRepositoryTest.createTestingLogFlow(tenant, flowId, "???")));
            Integer result = this.flowRepository.lastRevision(tenant, TEST_NAMESPACE, flowId);
            Assertions.assertThat((Integer)result).isEqualTo(1);
            Assertions.assertThat((Integer)this.flowRepository.lastRevision(tenant, TEST_NAMESPACE, flowId)).isEqualTo(1);
        }
        finally {
            toDelete.forEach(this::deleteFlow);
        }
    }

    @Test
    protected void shouldIncrementRevisionOnDelete() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        String flowId = IdUtils.create();
        FlowWithSource created = this.flowRepository.create(AbstractFlowRepositoryTest.createTestingLogFlow(tenant, flowId, "first"));
        Assertions.assertThat((int)this.flowRepository.findRevisions(tenant, TEST_NAMESPACE, flowId).size()).isEqualTo(1);
        this.flowRepository.delete((FlowInterface)created);
        Assertions.assertThat((int)this.flowRepository.findRevisions(tenant, TEST_NAMESPACE, flowId).size()).isEqualTo(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    protected void shouldIncrementRevisionOnCreateAfterDelete() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        ArrayList<FlowWithSource> toDelete = new ArrayList<FlowWithSource>();
        String flowId = IdUtils.create();
        try {
            this.flowRepository.delete((FlowInterface)this.flowRepository.create(AbstractFlowRepositoryTest.createTestingLogFlow(tenant, flowId, "first")));
            toDelete.add(this.flowRepository.create(AbstractFlowRepositoryTest.createTestingLogFlow(tenant, flowId, "second")));
            Assertions.assertThat((int)this.flowRepository.findRevisions(tenant, TEST_NAMESPACE, flowId).size()).isEqualTo(3);
            Assertions.assertThat((Integer)this.flowRepository.lastRevision(tenant, TEST_NAMESPACE, flowId)).isEqualTo(3);
        }
        finally {
            toDelete.forEach(this::deleteFlow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    protected void shouldReturnNullForLastRevisionAfterDelete() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        ArrayList<FlowWithSource> toDelete = new ArrayList<FlowWithSource>();
        String flowId = IdUtils.create();
        try {
            FlowWithSource created = this.flowRepository.create(AbstractFlowRepositoryTest.createTestingLogFlow(tenant, flowId, "first"));
            toDelete.add(created);
            FlowWithSource updated = this.flowRepository.update(AbstractFlowRepositoryTest.createTestingLogFlow(tenant, flowId, "second"), (FlowInterface)created);
            toDelete.add(updated);
            this.flowRepository.delete((FlowInterface)updated);
            Assertions.assertThat((Optional)this.flowRepository.findById(tenant, TEST_NAMESPACE, flowId, Optional.empty())).isEqualTo(Optional.empty());
            Assertions.assertThat((Integer)this.flowRepository.lastRevision(tenant, TEST_NAMESPACE, flowId)).isNull();
        }
        finally {
            toDelete.forEach(this::deleteFlow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    protected void shouldFindAllRevisionsAfterDelete() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        ArrayList<FlowWithSource> toDelete = new ArrayList<FlowWithSource>();
        String flowId = IdUtils.create();
        try {
            FlowWithSource created = this.flowRepository.create(AbstractFlowRepositoryTest.createTestingLogFlow(tenant, flowId, "first"));
            toDelete.add(created);
            FlowWithSource updated = this.flowRepository.update(AbstractFlowRepositoryTest.createTestingLogFlow(tenant, flowId, "second"), (FlowInterface)created);
            toDelete.add(updated);
            this.flowRepository.delete((FlowInterface)updated);
            Assertions.assertThat((Optional)this.flowRepository.findById(tenant, TEST_NAMESPACE, flowId, Optional.empty())).isEqualTo(Optional.empty());
            Assertions.assertThat((int)this.flowRepository.findRevisions(tenant, TEST_NAMESPACE, flowId).size()).isEqualTo(3);
        }
        finally {
            toDelete.forEach(this::deleteFlow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    protected void shouldIncrementRevisionOnUpdateGivenNotEqualSource() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        ArrayList<FlowWithSource> toDelete = new ArrayList<FlowWithSource>();
        String flowId = IdUtils.create();
        try {
            FlowWithSource created = this.flowRepository.create(AbstractFlowRepositoryTest.createTestingLogFlow(tenant, flowId, "first"));
            toDelete.add(created);
            FlowWithSource updated = this.flowRepository.update(AbstractFlowRepositoryTest.createTestingLogFlow(tenant, flowId, "second"), (FlowInterface)created);
            toDelete.add(updated);
            Assertions.assertThat((Integer)updated.getRevision()).isEqualTo(2);
            Assertions.assertThat((Integer)this.flowRepository.lastRevision(tenant, TEST_NAMESPACE, flowId)).isEqualTo(2);
        }
        finally {
            toDelete.forEach(this::deleteFlow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    protected void shouldNotIncrementRevisionOnUpdateGivenEqualSource() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        ArrayList<FlowWithSource> toDelete = new ArrayList<FlowWithSource>();
        String flowId = IdUtils.create();
        try {
            FlowWithSource created = this.flowRepository.create(AbstractFlowRepositoryTest.createTestingLogFlow(tenant, flowId, "first"));
            toDelete.add(created);
            FlowWithSource updated = this.flowRepository.update(AbstractFlowRepositoryTest.createTestingLogFlow(tenant, flowId, "first"), (FlowInterface)created);
            toDelete.add(updated);
            Assertions.assertThat((Integer)updated.getRevision()).isEqualTo(1);
            Assertions.assertThat((Integer)this.flowRepository.lastRevision(tenant, TEST_NAMESPACE, flowId)).isEqualTo(1);
        }
        finally {
            toDelete.forEach(this::deleteFlow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void findByExecution() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)AbstractFlowRepositoryTest.builder(tenant).revision(Integer.valueOf(1))).build();
        this.flowRepository.create(GenericFlow.of((FlowInterface)flow));
        Execution execution = Execution.builder().id(IdUtils.create()).namespace(flow.getNamespace()).tenantId(tenant).flowId(flow.getId()).flowRevision(flow.getRevision()).state(new State()).build();
        execution = this.executionRepository.save(execution);
        try {
            Flow full = this.flowRepository.findByExecution(execution);
            Assertions.assertThat((Object)full).isNotNull();
            Assertions.assertThat((String)full.getNamespace()).isEqualTo(flow.getNamespace());
            Assertions.assertThat((String)full.getId()).isEqualTo(flow.getId());
            full = this.flowRepository.findByExecutionWithoutAcl(execution);
            Assertions.assertThat((Object)full).isNotNull();
            Assertions.assertThat((String)full.getNamespace()).isEqualTo(flow.getNamespace());
            Assertions.assertThat((String)full.getId()).isEqualTo(flow.getId());
        }
        finally {
            this.deleteFlow((Flow)flow);
            this.executionRepository.delete(execution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void findByExecutionNoRevision() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)AbstractFlowRepositoryTest.builder(tenant).revision(Integer.valueOf(3))).build();
        this.flowRepository.create(GenericFlow.of((FlowInterface)flow));
        Execution execution = Execution.builder().tenantId(tenant).id(IdUtils.create()).namespace(flow.getNamespace()).flowId(flow.getId()).state(new State()).build();
        this.executionRepository.save(execution);
        try {
            Flow full = this.flowRepository.findByExecution(execution);
            Assertions.assertThat((Object)full).isNotNull();
            Assertions.assertThat((String)full.getNamespace()).isEqualTo(flow.getNamespace());
            Assertions.assertThat((String)full.getId()).isEqualTo(flow.getId());
            full = this.flowRepository.findByExecutionWithoutAcl(execution);
            Assertions.assertThat((Object)full).isNotNull();
            Assertions.assertThat((String)full.getNamespace()).isEqualTo(flow.getNamespace());
            Assertions.assertThat((String)full.getId()).isEqualTo(flow.getId());
        }
        finally {
            this.deleteFlow((Flow)flow);
            this.executionRepository.delete(execution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldCountForNullTenant() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        FlowWithSource toDelete = null;
        try {
            Flow flow2 = AbstractFlowRepositoryTest.createTestFlowForNamespace(tenant, TEST_NAMESPACE);
            toDelete = this.flowRepository.create(GenericFlow.of((FlowInterface)flow2));
            int count = this.flowRepository.count(tenant);
            org.junit.jupiter.api.Assertions.assertTrue((count > 0 ? 1 : 0) != 0);
        }
        finally {
            Optional.ofNullable(toDelete).ifPresent(flow -> this.flowRepository.delete((FlowInterface)flow));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void should_exist_for_tenant() {
        String tenantFlowExist = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        FlowWithSource flowExist = ((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)FlowWithSource.builder().id("flowExist")).namespace("system")).tenantId(tenantFlowExist)).deleted(false)).build();
        flowExist = this.flowRepository.create(GenericFlow.of((FlowInterface)flowExist));
        String tenantFlowDeleted = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        FlowWithSource flowDeleted = ((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)FlowWithSource.builder().id("flowDeleted")).namespace("system")).tenantId(tenantFlowDeleted)).deleted(true)).build();
        flowDeleted = this.flowRepository.create(GenericFlow.of((FlowInterface)flowDeleted));
        try {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.flowRepository.existAnyNoAcl(tenantFlowExist));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.flowRepository.existAnyNoAcl("not_found"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.flowRepository.existAnyNoAcl(tenantFlowDeleted));
        }
        finally {
            this.deleteFlow((Flow)flowExist);
            this.deleteFlow((Flow)flowDeleted);
        }
    }

    private static Flow createTestFlowForNamespace(String tenantId, String namespace) {
        return ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id(IdUtils.create())).namespace(namespace)).tenantId(tenantId)).tasks(List.of(((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id(IdUtils.create())).type(Return.class.getName())).build())).build();
    }

    protected void deleteFlow(Flow flow) {
        if (flow == null) {
            return;
        }
        this.flowRepository.findByIdWithSource(flow.getTenantId(), flow.getNamespace(), flow.getId()).ifPresent(delete -> this.flowRepository.delete((FlowInterface)((Flow.FlowBuilder)flow.toBuilder().revision(null)).build()));
    }

    private static GenericFlow createTestingLogFlow(String tenantId, String id, String logMessage) {
        String source = "   id: %s\n   namespace: %s\n   tasks:\n     - id: log\n       type: io.kestra.plugin.core.log.Log\n       message: %s\n".formatted(id, TEST_NAMESPACE, logMessage);
        return GenericFlow.fromYaml((String)tenantId, (String)source);
    }

    @Singleton
    public static class FlowListener
    implements ApplicationEventListener<CrudEvent<AbstractFlow>> {
        private static List<CrudEvent<AbstractFlow>> emits = new CopyOnWriteArrayList<CrudEvent<AbstractFlow>>();

        public void onApplicationEvent(CrudEvent<AbstractFlow> event) {
            if (event.getModel() != null && event.getModel() instanceof AbstractFlow || event.getPreviousModel() != null && event.getPreviousModel() instanceof AbstractFlow) {
                emits.add(event);
            }
        }

        public static void reset() {
            emits = new CopyOnWriteArrayList<CrudEvent<AbstractFlow>>();
        }

        public static List<CrudEvent<AbstractFlow>> filterByTenant(String tenantId) {
            return emits.stream().filter(e -> e.getPreviousModel() != null && ((AbstractFlow)e.getPreviousModel()).getTenantId().equals(tenantId) || e.getModel() != null && ((AbstractFlow)e.getModel()).getTenantId().equals(tenantId)).toList();
        }
    }

    public static class UnitTest
    extends AbstractTrigger
    implements PollingTriggerInterface {
        private final Duration interval;
        private String defaultInjected;

        public Optional<Execution> evaluate(ConditionContext conditionContext, TriggerContext context) throws InterruptedException {
            if (++COUNTER % 2 == 0) {
                Thread.sleep(4000L);
                return Optional.empty();
            }
            Execution execution = Execution.builder().id(IdUtils.create()).tenantId(context.getTenantId()).namespace(context.getNamespace()).flowId(context.getFlowId()).flowRevision(conditionContext.getFlow().getRevision()).state(new State()).trigger(ExecutionTrigger.builder().id(this.getId()).type(this.getType()).variables((Map)ImmutableMap.of((Object)"counter", (Object)COUNTER, (Object)"defaultInjected", (Object)(this.defaultInjected == null ? "ko" : this.defaultInjected))).build()).build();
            return Optional.of(execution);
        }

        @Generated
        private static Duration $default$interval() {
            return Duration.ofSeconds(2L);
        }

        @Generated
        protected UnitTest(UnitTestBuilder<?, ?> b) {
            super(b);
            this.interval = b.interval$set ? b.interval$value : UnitTest.$default$interval();
            this.defaultInjected = b.defaultInjected;
        }

        @Generated
        public static UnitTestBuilder<?, ?> builder() {
            return new UnitTestBuilderImpl();
        }

        @Generated
        public String toString() {
            return "AbstractFlowRepositoryTest.UnitTest(super=" + super.toString() + ", interval=" + String.valueOf(this.getInterval()) + ", defaultInjected=" + this.getDefaultInjected() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnitTest)) {
                return false;
            }
            UnitTest other = (UnitTest)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Duration this$interval = this.getInterval();
            Duration other$interval = other.getInterval();
            if (this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval)) {
                return false;
            }
            String this$defaultInjected = this.getDefaultInjected();
            String other$defaultInjected = other.getDefaultInjected();
            return !(this$defaultInjected == null ? other$defaultInjected != null : !this$defaultInjected.equals(other$defaultInjected));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UnitTest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Duration $interval = this.getInterval();
            result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
            String $defaultInjected = this.getDefaultInjected();
            result = result * 59 + ($defaultInjected == null ? 43 : $defaultInjected.hashCode());
            return result;
        }

        @Generated
        public Duration getInterval() {
            return this.interval;
        }

        @Generated
        public String getDefaultInjected() {
            return this.defaultInjected;
        }

        @Generated
        public UnitTest() {
            this.interval = UnitTest.$default$interval();
        }

        @Generated
        public static abstract class UnitTestBuilder<C extends UnitTest, B extends UnitTestBuilder<C, B>>
        extends AbstractTrigger.AbstractTriggerBuilder<C, B> {
            @Generated
            private boolean interval$set;
            @Generated
            private Duration interval$value;
            @Generated
            private String defaultInjected;

            @Generated
            public B interval(Duration interval) {
                this.interval$value = interval;
                this.interval$set = true;
                return (B)this.self();
            }

            @Generated
            public B defaultInjected(String defaultInjected) {
                this.defaultInjected = defaultInjected;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "AbstractFlowRepositoryTest.UnitTest.UnitTestBuilder(super=" + super.toString() + ", interval$value=" + String.valueOf(this.interval$value) + ", defaultInjected=" + this.defaultInjected + ")";
            }
        }

        @Generated
        private static final class UnitTestBuilderImpl
        extends UnitTestBuilder<UnitTest, UnitTestBuilderImpl> {
            @Generated
            private UnitTestBuilderImpl() {
            }

            @Override
            @Generated
            protected UnitTestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public UnitTest build() {
                return new UnitTest(this);
            }
        }
    }
}

