/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.topologies.FlowNode;
import io.kestra.core.models.topologies.FlowRelation;
import io.kestra.core.models.topologies.FlowTopology;
import io.kestra.core.repositories.FlowTopologyRepositoryInterface;
import io.kestra.core.utils.TestsUtils;
import jakarta.inject.Inject;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
public abstract class AbstractFlowTopologyRepositoryTest {
    @Inject
    private FlowTopologyRepositoryInterface flowTopologyRepository;

    protected FlowTopology createSimpleFlowTopology(String tenantId, String flowA, String flowB, String namespace) {
        return FlowTopology.builder().relation(FlowRelation.FLOW_TASK).source(FlowNode.builder().id(flowA).namespace(namespace).tenantId(tenantId).uid(tenantId + flowA).build()).destination(FlowNode.builder().id(flowB).namespace(namespace).tenantId(tenantId).uid(tenantId + flowB).build()).build();
    }

    @Test
    void findByFlow() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.flowTopologyRepository.save(this.createSimpleFlowTopology(tenant, "flow-a", "flow-b", "io.kestra.tests"));
        List list = this.flowTopologyRepository.findByFlow(tenant, "io.kestra.tests", "flow-a", Boolean.valueOf(false));
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    @Test
    void findByNamespace() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.flowTopologyRepository.save(this.createSimpleFlowTopology(tenant, "flow-a", "flow-b", "io.kestra.tests"));
        this.flowTopologyRepository.save(this.createSimpleFlowTopology(tenant, "flow-c", "flow-d", "io.kestra.tests"));
        List list = this.flowTopologyRepository.findByNamespace(tenant, "io.kestra.tests");
        Assertions.assertThat((int)list.size()).isEqualTo(2);
    }

    @Test
    void findAll() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.flowTopologyRepository.save(this.createSimpleFlowTopology(tenant, "flow-a", "flow-b", "io.kestra.tests"));
        this.flowTopologyRepository.save(this.createSimpleFlowTopology(tenant, "flow-c", "flow-d", "io.kestra.tests"));
        this.flowTopologyRepository.save(this.createSimpleFlowTopology(tenant, "flow-e", "flow-f", "io.kestra.tests.2"));
        List list = this.flowTopologyRepository.findAll(tenant);
        Assertions.assertThat((int)list.size()).isEqualTo(3);
    }
}

