/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.FetchVersion;
import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.kv.PersistedKvMetadata;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.KvMetadataRepositoryInterface;
import io.kestra.core.utils.TestsUtils;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Inject;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
public abstract class AbstractKvMetadataRepositoryTest {
    @Inject
    protected KvMetadataRepositoryInterface kvMetadataRepositoryInterface;

    @Test
    void findKvMetadataByName() throws IOException {
        String tenantId = TestsUtils.randomTenant((String[])new String[0]);
        String namespace = TestsUtils.randomNamespace((String[])new String[0]);
        String key = "test-kv";
        PersistedKvMetadata metadata = PersistedKvMetadata.builder().tenantId(tenantId).namespace(namespace).name(key).description("Test kv description").version(Integer.valueOf(1)).expirationDate(Instant.now().plus(5L, ChronoUnit.MINUTES)).build();
        this.kvMetadataRepositoryInterface.save((Object)metadata);
        String changedDescription = "Changed description";
        this.kvMetadataRepositoryInterface.save((Object)metadata.toBuilder().description(changedDescription).version(Integer.valueOf(2)).build());
        Optional found = this.kvMetadataRepositoryInterface.findByName(tenantId, namespace, key);
        Assertions.assertThat((Optional)found).isPresent();
        Assertions.assertThat((String)((PersistedKvMetadata)found.get()).getName()).isEqualTo(key);
        Assertions.assertThat((String)((PersistedKvMetadata)found.get()).getDescription()).isEqualTo(changedDescription);
        Assertions.assertThat((Integer)((PersistedKvMetadata)found.get()).getVersion()).isEqualTo(2);
        Assertions.assertThat((boolean)((PersistedKvMetadata)found.get()).isLast()).isTrue();
        Assertions.assertThat((boolean)((PersistedKvMetadata)found.get()).isDeleted()).isFalse();
    }

    @Test
    void deleteMetadata() throws IOException {
        String tenantId = TestsUtils.randomTenant((String[])new String[0]);
        String namespace = TestsUtils.randomNamespace((String[])new String[0]);
        String key = "test-kv";
        PersistedKvMetadata metadata = PersistedKvMetadata.builder().tenantId(tenantId).namespace(namespace).name(key).version(Integer.valueOf(1)).build();
        this.kvMetadataRepositoryInterface.save((Object)metadata);
        Optional found = this.kvMetadataRepositoryInterface.findByName(tenantId, namespace, key);
        Assertions.assertThat((Optional)found).isPresent();
        Assertions.assertThat((String)((PersistedKvMetadata)found.get()).getName()).isEqualTo(key);
        Assertions.assertThat((boolean)((PersistedKvMetadata)found.get()).isLast()).isTrue();
        Assertions.assertThat((boolean)((PersistedKvMetadata)found.get()).isDeleted()).isFalse();
        Instant beforeDeleteUpdateDate = ((PersistedKvMetadata)found.get()).getUpdated();
        this.kvMetadataRepositoryInterface.delete((PersistedKvMetadata)found.get());
        found = this.kvMetadataRepositoryInterface.findByName(tenantId, namespace, key);
        Assertions.assertThat((Optional)found).isPresent();
        Assertions.assertThat((String)((PersistedKvMetadata)found.get()).getName()).isEqualTo(key);
        Assertions.assertThat((Integer)((PersistedKvMetadata)found.get()).getVersion()).isEqualTo(1);
        Assertions.assertThat((boolean)((PersistedKvMetadata)found.get()).isLast()).isTrue();
        Assertions.assertThat((boolean)((PersistedKvMetadata)found.get()).isDeleted()).isTrue();
        Assertions.assertThat((Instant)((PersistedKvMetadata)found.get()).getUpdated()).isAfter(beforeDeleteUpdateDate);
    }

    @Test
    void findWithFilters() throws IOException {
        String tenantId = TestsUtils.randomTenant((String[])new String[0]);
        String namespace = TestsUtils.randomNamespace((String[])new String[0]);
        String key = "test-kv";
        String originalDescription = "Some description";
        PersistedKvMetadata metadata = PersistedKvMetadata.builder().tenantId(tenantId).namespace(namespace).name(key).description(originalDescription).build();
        Assertions.assertThat((Integer)metadata.getVersion()).isNull();
        Assertions.assertThat((Integer)((PersistedKvMetadata)this.kvMetadataRepositoryInterface.save((Object)metadata)).getVersion()).isEqualTo(1);
        String changedDescription = "Changed description";
        metadata = (PersistedKvMetadata)this.kvMetadataRepositoryInterface.save((Object)metadata.toBuilder().description(changedDescription).build());
        Assertions.assertThat((Integer)metadata.getVersion()).isEqualTo(2);
        String anotherNamespace = TestsUtils.randomNamespace((String[])new String[0]);
        String anotherNamespaceDeletedKey = "test-another-kv";
        String anotherNamespaceDescription = "Another namespace description";
        PersistedKvMetadata anotherMetadata = PersistedKvMetadata.builder().tenantId(tenantId).namespace(anotherNamespace).name(anotherNamespaceDeletedKey).description(anotherNamespaceDescription).build();
        this.kvMetadataRepositoryInterface.save((Object)anotherMetadata);
        this.kvMetadataRepositoryInterface.delete(anotherMetadata);
        String anotherNamespaceExpiredKey = "test-another-expired-kv";
        String anotherNamespaceExpiredDescription = "Another namespace expired description";
        PersistedKvMetadata anotherExpiredMetadata = PersistedKvMetadata.builder().tenantId(tenantId).namespace(anotherNamespace).name(anotherNamespaceExpiredKey).description(anotherNamespaceExpiredDescription).expirationDate(Instant.now().minus(1L, ChronoUnit.HOURS)).build();
        this.kvMetadataRepositoryInterface.save((Object)anotherExpiredMetadata);
        ArrayListTotal found = this.kvMetadataRepositoryInterface.find(Pageable.from((int)1, (int)1), tenantId, Collections.emptyList(), true, true);
        Assertions.assertThat((List)found).hasSize(1);
        Assertions.assertThat((long)found.getTotal()).isEqualTo(3L);
        found = this.kvMetadataRepositoryInterface.find(Pageable.from((int)1, (int)10), tenantId, Collections.emptyList(), true, true, FetchVersion.ALL);
        Assertions.assertThat((List)found).hasSize(4);
        Assertions.assertThat((long)found.getTotal()).isEqualTo(4L);
        List<PersistedKvMetadata> versionsForKey = found.stream().filter(kv -> kv.getName().equals(key)).toList();
        Assertions.assertThat((int)versionsForKey.size()).isEqualTo(2);
        Assertions.assertThat(versionsForKey.stream().map(PersistedKvMetadata::getVersion)).containsExactlyInAnyOrder((Object[])new Integer[]{1, 2});
        Assertions.assertThat(versionsForKey.stream().map(PersistedKvMetadata::getDescription)).containsExactlyInAnyOrder((Object[])new String[]{originalDescription, changedDescription});
        found = this.kvMetadataRepositoryInterface.find(Pageable.from((int)1, (int)10), tenantId, Collections.emptyList(), true, true, FetchVersion.OLD);
        Assertions.assertThat((List)found).hasSize(1);
        Assertions.assertThat((long)found.getTotal()).isEqualTo(1L);
        Assertions.assertThat((String)((PersistedKvMetadata)found.getFirst()).getDescription()).isEqualTo(originalDescription);
        Assertions.assertThat((Integer)((PersistedKvMetadata)found.getFirst()).getVersion()).isEqualTo(1);
        Assertions.assertThat((boolean)((PersistedKvMetadata)found.getFirst()).isLast()).isFalse();
        found = this.kvMetadataRepositoryInterface.find(Pageable.unpaged(), tenantId, List.of(QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.EQUALS).value((Object)anotherNamespace).build()), true, true);
        Assertions.assertThat((long)found.getTotal()).isEqualTo(2L);
        Assertions.assertThat((List)found.map(PersistedKvMetadata::getName)).containsExactlyInAnyOrder((Object[])new String[]{anotherNamespaceDeletedKey, anotherNamespaceExpiredKey});
        found = this.kvMetadataRepositoryInterface.find(Pageable.unpaged(), tenantId, List.of(QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.EQUALS).value((Object)anotherNamespace).build()), false, true);
        Assertions.assertThat((long)found.getTotal()).isEqualTo(1L);
        Assertions.assertThat((String)((PersistedKvMetadata)found.getFirst()).getName()).isEqualTo(anotherNamespaceExpiredKey);
        found = this.kvMetadataRepositoryInterface.find(Pageable.unpaged(), tenantId, List.of(QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.EQUALS).value((Object)anotherNamespace).build()), true, false);
        Assertions.assertThat((long)found.getTotal()).isEqualTo(1L);
        Assertions.assertThat((String)((PersistedKvMetadata)found.getFirst()).getName()).isEqualTo(anotherNamespaceDeletedKey);
        found = this.kvMetadataRepositoryInterface.find(Pageable.unpaged(), tenantId, Collections.emptyList(), false, false);
        Assertions.assertThat((long)found.getTotal()).isEqualTo(1L);
        Assertions.assertThat((String)((PersistedKvMetadata)found.getFirst()).getName()).isEqualTo(key);
    }

    @Test
    void purgeAllVersions() throws IOException {
        String tenantId = TestsUtils.randomTenant((String[])new String[0]);
        String namespace = TestsUtils.randomNamespace((String[])new String[0]);
        String key = "test-kv";
        PersistedKvMetadata metadata = PersistedKvMetadata.builder().tenantId(tenantId).namespace(namespace).name(key).description("Some description").build();
        Assertions.assertThat((Integer)metadata.getVersion()).isNull();
        Assertions.assertThat((Integer)((PersistedKvMetadata)this.kvMetadataRepositoryInterface.save((Object)metadata)).getVersion()).isEqualTo(1);
        String changedDescription = "Changed description";
        metadata = (PersistedKvMetadata)this.kvMetadataRepositoryInterface.save((Object)metadata.toBuilder().description(changedDescription).build());
        Assertions.assertThat((Integer)metadata.getVersion()).isEqualTo(2);
        Integer purgedAmount = this.kvMetadataRepositoryInterface.purge(List.of(PersistedKvMetadata.builder().tenantId(tenantId).namespace(namespace).name(key).build()));
        Assertions.assertThat((Integer)purgedAmount).isEqualTo(2);
        Assertions.assertThat((boolean)this.kvMetadataRepositoryInterface.findByName(tenantId, namespace, key).isPresent()).isFalse();
    }
}

