/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import io.kestra.core.exceptions.InvalidQueryFiltersException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.dashboards.AggregationType;
import io.kestra.core.models.dashboards.ColumnDescriptor;
import io.kestra.core.models.dashboards.DataFilter;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionKind;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.flows.FlowScope;
import io.kestra.core.models.flows.State;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.repositories.LogRepositoryInterface;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.dashboard.data.ILogs;
import io.kestra.plugin.core.dashboard.data.Logs;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Inject;
import java.io.IOException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.event.Level;
import reactor.core.publisher.Flux;

@KestraTest
public abstract class AbstractLogRepositoryTest {
    @Inject
    protected LogRepositoryInterface logRepository;

    protected static LogEntry.LogEntryBuilder logEntry(String tenantId, Level level) {
        return AbstractLogRepositoryTest.logEntry(tenantId, level, IdUtils.create());
    }

    protected static LogEntry.LogEntryBuilder logEntry(String tenantId, Level level, String executionId) {
        return LogEntry.builder().flowId("flowId").namespace("io.kestra.unittest").taskId("taskId").executionId(executionId).taskRunId(IdUtils.create()).attemptNumber(Integer.valueOf(0)).timestamp(Instant.now()).level(level).thread("").tenantId(tenantId).triggerId("triggerId").message("john doe");
    }

    @ParameterizedTest
    @MethodSource(value={"filterCombinations"})
    void should_find_all(QueryFilter filter) {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.logRepository.save(AbstractLogRepositoryTest.logEntry(tenant, Level.INFO, "executionId").build());
        ArrayListTotal entries = this.logRepository.find(Pageable.UNPAGED, tenant, List.of(filter));
        Assertions.assertThat((List)entries).hasSize(1);
    }

    @ParameterizedTest
    @MethodSource(value={"filterCombinations"})
    void should_find_async(QueryFilter filter) {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.logRepository.save(AbstractLogRepositoryTest.logEntry(tenant, Level.INFO, "executionId").build());
        Flux find = this.logRepository.findAsync(tenant, List.of(filter));
        List logEntries = (List)find.collectList().block();
        Assertions.assertThat((List)logEntries).hasSize(1);
    }

    @ParameterizedTest
    @MethodSource(value={"filterCombinations"})
    void should_delete_with_filter(QueryFilter filter) {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.logRepository.save(AbstractLogRepositoryTest.logEntry(tenant, Level.INFO, "executionId").build());
        this.logRepository.deleteByFilters(tenant, List.of(filter));
        Assertions.assertThat((List)((List)this.logRepository.findAllAsync(tenant).collectList().block())).isEmpty();
    }

    static Stream<QueryFilter> filterCombinations() {
        return Stream.of(QueryFilter.builder().field(QueryFilter.Field.QUERY).value((Object)"flowId").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.QUERY).value((Object)"anotherId").operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.SCOPE).value(List.of(FlowScope.USER)).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.SCOPE).value(List.of(FlowScope.SYSTEM)).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).value((Object)"io.kestra.unittest").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).value((Object)"another.namespace").operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).value((Object)"kestra").operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).value((Object)"io.kestra").operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).value((Object)"unittest").operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).value((Object)".*kestra.*").operation(QueryFilter.Op.REGEX).build(), QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).value(List.of("io.kestra.unittest")).operation(QueryFilter.Op.IN).build(), QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).value(List.of("another.namespace")).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).value((Object)"io").operation(QueryFilter.Op.PREFIX).build(), QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).value((Object)"flowId").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).value((Object)"anotherFlowId").operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).value((Object)"lowI").operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).value((Object)"flow").operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).value((Object)"Id").operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).value((Object)".lowI.").operation(QueryFilter.Op.REGEX).build(), QueryFilter.builder().field(QueryFilter.Field.START_DATE).value((Object)ZonedDateTime.now().minusMinutes(1L)).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.builder().field(QueryFilter.Field.START_DATE).value((Object)ZonedDateTime.now().minusMinutes(1L)).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.builder().field(QueryFilter.Field.START_DATE).value((Object)ZonedDateTime.now().plusMinutes(1L)).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.builder().field(QueryFilter.Field.START_DATE).value((Object)ZonedDateTime.now().plusMinutes(1L)).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.builder().field(QueryFilter.Field.START_DATE).value((Object)ZonedDateTime.now().minusMinutes(1L)).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.END_DATE).value((Object)ZonedDateTime.now().minusMinutes(1L)).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.builder().field(QueryFilter.Field.END_DATE).value((Object)ZonedDateTime.now().minusMinutes(1L)).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.builder().field(QueryFilter.Field.END_DATE).value((Object)ZonedDateTime.now().plusMinutes(1L)).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.builder().field(QueryFilter.Field.END_DATE).value((Object)ZonedDateTime.now().plusMinutes(1L)).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.builder().field(QueryFilter.Field.END_DATE).value((Object)ZonedDateTime.now().minusMinutes(1L)).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).value((Object)"triggerId").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).value((Object)"anotherId").operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).value((Object)"igger").operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).value((Object)"trigger").operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).value((Object)"Id").operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).value(List.of("triggerId")).operation(QueryFilter.Op.IN).build(), QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).value(List.of("anotherId")).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).value((Object)"executionId").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).value((Object)"anotherId").operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).value((Object)"xecution").operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).value((Object)"execution").operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).value((Object)"Id").operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).value(List.of("executionId")).operation(QueryFilter.Op.IN).build(), QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).value(List.of("anotherId")).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).value((Object)Level.DEBUG).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).value((Object)Level.ERROR).operation(QueryFilter.Op.NOT_EQUALS).build());
    }

    @ParameterizedTest
    @MethodSource(value={"errorFilterCombinations"})
    void should_fail_to_find_all(QueryFilter filter) {
        org.junit.jupiter.api.Assertions.assertThrows(InvalidQueryFiltersException.class, () -> this.logRepository.find(Pageable.UNPAGED, TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()}), List.of(filter)));
    }

    static Stream<QueryFilter> errorFilterCombinations() {
        return Stream.of(QueryFilter.builder().field(QueryFilter.Field.LABELS).value(Map.of("key", "value")).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.STATE).value((Object)State.Type.RUNNING).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.TIME_RANGE).value((Object)"test").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).value((Object)"test").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).value((Object)ExecutionRepositoryInterface.ChildFilter.CHILD).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).value((Object)"test").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).value((Object)"test").operation(QueryFilter.Op.EQUALS).build());
    }

    @Test
    void all() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        LogEntry.LogEntryBuilder builder = AbstractLogRepositoryTest.logEntry(tenant, Level.INFO);
        ArrayListTotal find = this.logRepository.find(Pageable.UNPAGED, tenant, null);
        Assertions.assertThat((int)find.size()).isZero();
        LogEntry save = this.logRepository.save(builder.build());
        this.logRepository.save(builder.executionKind(ExecutionKind.TEST).build());
        find = this.logRepository.find(Pageable.UNPAGED, tenant, null);
        Assertions.assertThat((int)find.size()).isEqualTo(1);
        Assertions.assertThat((String)((LogEntry)find.getFirst()).getExecutionId()).isEqualTo(save.getExecutionId());
        List<QueryFilter> filters = List.of(QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).operation(QueryFilter.Op.EQUALS).value((Object)Level.WARN).build(), QueryFilter.builder().field(QueryFilter.Field.START_DATE).operation(QueryFilter.Op.GREATER_THAN).value((Object)Instant.now().minus(1L, ChronoUnit.HOURS)).build());
        find = this.logRepository.find(Pageable.UNPAGED, "doe", filters);
        Assertions.assertThat((int)find.size()).isZero();
        find = this.logRepository.find(Pageable.UNPAGED, tenant, null);
        Assertions.assertThat((int)find.size()).isEqualTo(1);
        Assertions.assertThat((String)((LogEntry)find.getFirst()).getExecutionId()).isEqualTo(save.getExecutionId());
        this.logRepository.find(Pageable.UNPAGED, "kestra-io/kestra", null);
        Assertions.assertThat((int)find.size()).isEqualTo(1);
        Assertions.assertThat((String)((LogEntry)find.getFirst()).getExecutionId()).isEqualTo(save.getExecutionId());
        List list = this.logRepository.findByExecutionId(tenant, save.getExecutionId(), null);
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((String)((LogEntry)list.getFirst()).getExecutionId()).isEqualTo(save.getExecutionId());
        list = this.logRepository.findByExecutionId(tenant, "io.kestra.unittest", "flowId", save.getExecutionId(), null);
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((String)((LogEntry)list.getFirst()).getExecutionId()).isEqualTo(save.getExecutionId());
        list = this.logRepository.findByExecutionIdAndTaskId(tenant, save.getExecutionId(), save.getTaskId(), null);
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((String)((LogEntry)list.getFirst()).getExecutionId()).isEqualTo(save.getExecutionId());
        list = this.logRepository.findByExecutionIdAndTaskId(tenant, "io.kestra.unittest", "flowId", save.getExecutionId(), save.getTaskId(), null);
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((String)((LogEntry)list.getFirst()).getExecutionId()).isEqualTo(save.getExecutionId());
        list = this.logRepository.findByExecutionIdAndTaskRunId(tenant, save.getExecutionId(), save.getTaskRunId(), null);
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((String)((LogEntry)list.getFirst()).getExecutionId()).isEqualTo(save.getExecutionId());
        list = this.logRepository.findByExecutionIdAndTaskRunIdAndAttempt(tenant, save.getExecutionId(), save.getTaskRunId(), null, Integer.valueOf(0));
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((String)((LogEntry)list.getFirst()).getExecutionId()).isEqualTo(save.getExecutionId());
        Integer countDeleted = this.logRepository.purge(Execution.builder().id(save.getExecutionId()).build());
        Assertions.assertThat((Integer)countDeleted).isEqualTo(2);
        list = this.logRepository.findByExecutionIdAndTaskId(tenant, save.getExecutionId(), save.getTaskId(), null);
        Assertions.assertThat((int)list.size()).isZero();
    }

    @Test
    void pageable() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        String executionId = "123";
        LogEntry.LogEntryBuilder builder = AbstractLogRepositoryTest.logEntry(tenant, Level.INFO);
        builder.executionId(executionId);
        for (int i = 0; i < 80; ++i) {
            this.logRepository.save(builder.build());
        }
        builder = AbstractLogRepositoryTest.logEntry(tenant, Level.INFO).executionId(executionId).taskId("taskId2").taskRunId("taskRunId2");
        LogEntry logEntry2 = this.logRepository.save(builder.build());
        for (int i = 0; i < 20; ++i) {
            this.logRepository.save(builder.build());
        }
        ArrayListTotal find = this.logRepository.findByExecutionId(tenant, executionId, null, Pageable.from((int)1, (int)50));
        Assertions.assertThat((int)find.size()).isEqualTo(50);
        Assertions.assertThat((long)find.getTotal()).isEqualTo(101L);
        find = this.logRepository.findByExecutionId(tenant, executionId, null, Pageable.from((int)3, (int)50));
        Assertions.assertThat((int)find.size()).isEqualTo(1);
        Assertions.assertThat((long)find.getTotal()).isEqualTo(101L);
        find = this.logRepository.findByExecutionIdAndTaskId(tenant, executionId, logEntry2.getTaskId(), null, Pageable.from((int)1, (int)50));
        Assertions.assertThat((int)find.size()).isEqualTo(21);
        Assertions.assertThat((long)find.getTotal()).isEqualTo(21L);
        find = this.logRepository.findByExecutionIdAndTaskRunId(tenant, executionId, logEntry2.getTaskRunId(), null, Pageable.from((int)1, (int)10));
        Assertions.assertThat((int)find.size()).isEqualTo(10);
        Assertions.assertThat((long)find.getTotal()).isEqualTo(21L);
        find = this.logRepository.findByExecutionIdAndTaskRunIdAndAttempt(tenant, executionId, logEntry2.getTaskRunId(), null, Integer.valueOf(0), Pageable.from((int)1, (int)10));
        Assertions.assertThat((int)find.size()).isEqualTo(10);
        Assertions.assertThat((long)find.getTotal()).isEqualTo(21L);
        find = this.logRepository.findByExecutionIdAndTaskRunId(tenant, executionId, logEntry2.getTaskRunId(), null, Pageable.from((int)10, (int)10));
        Assertions.assertThat((int)find.size()).isZero();
    }

    @Test
    void shouldFindByExecutionIdTestLogs() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        LogEntry builder = AbstractLogRepositoryTest.logEntry(tenant, Level.INFO).executionId("123").executionKind(ExecutionKind.TEST).build();
        this.logRepository.save(builder);
        List logs = this.logRepository.findByExecutionId(tenant, builder.getExecutionId(), null);
        Assertions.assertThat((List)logs).hasSize(1);
    }

    @Test
    void deleteByQuery() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        LogEntry log1 = AbstractLogRepositoryTest.logEntry(tenant, Level.INFO).build();
        this.logRepository.save(log1);
        this.logRepository.deleteByQuery(tenant, log1.getExecutionId(), null, null, null, null);
        ArrayListTotal find = this.logRepository.findByExecutionId(tenant, log1.getExecutionId(), null, Pageable.from((int)1, (int)50));
        Assertions.assertThat((int)find.size()).isZero();
        this.logRepository.save(log1);
        this.logRepository.deleteByQuery(tenant, "io.kestra.unittest", "flowId", null, List.of(Level.TRACE, Level.DEBUG, Level.INFO), null, ZonedDateTime.now().plusMinutes(1L));
        find = this.logRepository.findByExecutionId(tenant, log1.getExecutionId(), null, Pageable.from((int)1, (int)50));
        Assertions.assertThat((int)find.size()).isZero();
        this.logRepository.save(log1);
        this.logRepository.deleteByQuery(tenant, "io.kestra.unittest", "flowId", null);
        find = this.logRepository.findByExecutionId(tenant, log1.getExecutionId(), null, Pageable.from((int)1, (int)50));
        Assertions.assertThat((int)find.size()).isZero();
        this.logRepository.save(log1);
        this.logRepository.deleteByQuery(tenant, null, null, log1.getExecutionId(), List.of(Level.TRACE, Level.DEBUG, Level.INFO), null, ZonedDateTime.now().plusMinutes(1L));
        find = this.logRepository.findByExecutionId(tenant, log1.getExecutionId(), null, Pageable.from((int)1, (int)50));
        Assertions.assertThat((int)find.size()).isZero();
    }

    @Test
    void findAllAsync() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.logRepository.save(AbstractLogRepositoryTest.logEntry(tenant, Level.INFO).build());
        this.logRepository.save(AbstractLogRepositoryTest.logEntry(tenant, Level.INFO).executionKind(ExecutionKind.TEST).build());
        this.logRepository.save(AbstractLogRepositoryTest.logEntry(tenant, Level.ERROR).build());
        this.logRepository.save(AbstractLogRepositoryTest.logEntry(tenant, Level.WARN).build());
        Flux find = this.logRepository.findAllAsync(tenant);
        List logEntries = (List)find.collectList().block();
        Assertions.assertThat((List)logEntries).hasSize(4);
    }

    @Test
    void fetchData() throws IOException {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.logRepository.save(AbstractLogRepositoryTest.logEntry(tenant, Level.INFO).build());
        ArrayListTotal results = this.logRepository.fetchData(tenant, (DataFilter)((Logs.LogsBuilder)((Logs.LogsBuilder)Logs.builder().type(Logs.class.getName())).columns(Map.of("count", ColumnDescriptor.builder().field((Enum)ILogs.Fields.LEVEL).agg(AggregationType.COUNT).build()))).build(), ZonedDateTime.now().minusHours(3L), ZonedDateTime.now(), null);
        Assertions.assertThat((List)results).hasSize(1);
    }

    @Test
    void purge() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.logRepository.save(AbstractLogRepositoryTest.logEntry(tenant, Level.INFO, "execution1").build());
        this.logRepository.save(AbstractLogRepositoryTest.logEntry(tenant, Level.INFO, "execution1").build());
        this.logRepository.save(AbstractLogRepositoryTest.logEntry(tenant, Level.INFO, "execution2").build());
        this.logRepository.save(AbstractLogRepositoryTest.logEntry(tenant, Level.INFO, "execution2").build());
        Integer result = this.logRepository.purge(List.of(Execution.builder().id("execution1").build(), Execution.builder().id("execution2").build()));
        Assertions.assertThat((Integer)result).isEqualTo(4);
    }
}

