/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import com.devskiller.friendly_id.FriendlyId;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionKind;
import io.kestra.core.models.executions.MetricEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.executions.metrics.MetricAggregations;
import io.kestra.core.models.executions.metrics.Timer;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.MetricRepositoryInterface;
import io.kestra.core.utils.TestsUtils;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
public abstract class AbstractMetricRepositoryTest {
    @Inject
    protected MetricRepositoryInterface metricRepository;

    @Test
    void all() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        String executionId = FriendlyId.createFriendlyId();
        TaskRun taskRun1 = this.taskRun(tenant, executionId, "task");
        MetricEntry counter = MetricEntry.of((TaskRun)taskRun1, (AbstractMetricEntry)this.counter("counter"), null);
        MetricEntry testCounter = MetricEntry.of((TaskRun)taskRun1, (AbstractMetricEntry)this.counter("test"), (ExecutionKind)ExecutionKind.TEST);
        TaskRun taskRun2 = this.taskRun(tenant, executionId, "task");
        MetricEntry timer = MetricEntry.of((TaskRun)taskRun2, (AbstractMetricEntry)this.timer(), null);
        this.metricRepository.save((Object)counter);
        this.metricRepository.save((Object)testCounter);
        this.metricRepository.save((Object)timer);
        ArrayListTotal results = this.metricRepository.findByExecutionId(tenant, executionId, Pageable.from((int)1, (int)10));
        Assertions.assertThat((int)results.size()).isEqualTo(3);
        results = this.metricRepository.findByExecutionIdAndTaskId(tenant, executionId, taskRun1.getTaskId(), Pageable.from((int)1, (int)10));
        Assertions.assertThat((int)results.size()).isEqualTo(3);
        results = this.metricRepository.findByExecutionIdAndTaskRunId(tenant, executionId, taskRun1.getId(), Pageable.from((int)1, (int)10));
        Assertions.assertThat((int)results.size()).isEqualTo(2);
        MetricAggregations aggregationResults = this.metricRepository.aggregateByFlowId(tenant, "namespace", "flow", null, counter.getName(), ZonedDateTime.now().minusDays(30L), ZonedDateTime.now(), "sum");
        Assertions.assertThat((int)aggregationResults.getAggregations().size()).isEqualTo(31);
        Assertions.assertThat((String)aggregationResults.getGroupBy()).isEqualTo("day");
        aggregationResults = this.metricRepository.aggregateByFlowId(tenant, "namespace", "flow", null, counter.getName(), ZonedDateTime.now().minusWeeks(26L), ZonedDateTime.now(), "sum");
        Assertions.assertThat((int)aggregationResults.getAggregations().size()).isEqualTo(27);
        Assertions.assertThat((String)aggregationResults.getGroupBy()).isEqualTo("week");
    }

    @Test
    void names() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        String executionId = FriendlyId.createFriendlyId();
        TaskRun taskRun1 = this.taskRun(tenant, executionId, "task");
        MetricEntry counter = MetricEntry.of((TaskRun)taskRun1, (AbstractMetricEntry)this.counter("counter"), null);
        TaskRun taskRun2 = this.taskRun(tenant, executionId, "task2");
        MetricEntry counter2 = MetricEntry.of((TaskRun)taskRun2, (AbstractMetricEntry)this.counter("counter2"), null);
        MetricEntry test = MetricEntry.of((TaskRun)taskRun2, (AbstractMetricEntry)this.counter("test"), (ExecutionKind)ExecutionKind.TEST);
        this.metricRepository.save((Object)counter);
        this.metricRepository.save((Object)counter2);
        this.metricRepository.save((Object)test);
        List flowMetricsNames = this.metricRepository.flowMetrics(tenant, "namespace", "flow");
        List taskMetricsNames = this.metricRepository.taskMetrics(tenant, "namespace", "flow", "task");
        List tasksWithMetrics = this.metricRepository.tasksWithMetrics(tenant, "namespace", "flow");
        Assertions.assertThat((int)flowMetricsNames.size()).isEqualTo(2);
        Assertions.assertThat((int)taskMetricsNames.size()).isEqualTo(1);
        Assertions.assertThat((int)tasksWithMetrics.size()).isEqualTo(2);
    }

    @Test
    void findAllAsync() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        String executionId = FriendlyId.createFriendlyId();
        TaskRun taskRun1 = this.taskRun(tenant, executionId, "task");
        MetricEntry counter = MetricEntry.of((TaskRun)taskRun1, (AbstractMetricEntry)this.counter("counter"), null);
        TaskRun taskRun2 = this.taskRun(tenant, executionId, "task");
        MetricEntry timer = MetricEntry.of((TaskRun)taskRun2, (AbstractMetricEntry)this.timer(), null);
        MetricEntry test = MetricEntry.of((TaskRun)taskRun2, (AbstractMetricEntry)this.counter("test"), (ExecutionKind)ExecutionKind.TEST);
        this.metricRepository.save((Object)counter);
        this.metricRepository.save((Object)timer);
        this.metricRepository.save((Object)test);
        List results = (List)this.metricRepository.findAllAsync(tenant).collectList().block();
        Assertions.assertThat((List)results).hasSize(3);
    }

    @Test
    void purge() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.metricRepository.save((Object)MetricEntry.of((TaskRun)this.taskRun(tenant, "execution1", "task"), (AbstractMetricEntry)this.counter("counter1"), null));
        this.metricRepository.save((Object)MetricEntry.of((TaskRun)this.taskRun(tenant, "execution1", "task"), (AbstractMetricEntry)this.counter("counter2"), null));
        this.metricRepository.save((Object)MetricEntry.of((TaskRun)this.taskRun(tenant, "execution2", "task"), (AbstractMetricEntry)this.counter("counter1"), null));
        this.metricRepository.save((Object)MetricEntry.of((TaskRun)this.taskRun(tenant, "execution2", "task"), (AbstractMetricEntry)this.counter("counter2"), null));
        Integer result = this.metricRepository.purge(List.of(Execution.builder().id("execution1").build(), Execution.builder().id("execution2").build()));
        Assertions.assertThat((Integer)result).isEqualTo(4);
    }

    private Counter counter(String metricName) {
        return Counter.of((String)metricName, (Integer)1, (String[])new String[0]);
    }

    private Timer timer() {
        return Timer.of((String)"counter", (Duration)Duration.ofSeconds(5L), (String[])new String[0]);
    }

    private TaskRun taskRun(String tenantId, String executionId, String taskId) {
        return TaskRun.builder().tenantId(tenantId).flowId("flow").namespace("namespace").executionId(executionId).taskId(taskId).id(FriendlyId.createFriendlyId()).build();
    }
}

