/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.Setting;
import io.kestra.core.repositories.SettingRepositoryInterface;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.VersionProvider;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
public abstract class AbstractSettingRepositoryTest {
    @Inject
    protected SettingRepositoryInterface settingRepository;
    @Inject
    protected VersionProvider versionProvider;

    @Test
    void all() {
        Setting setting = Setting.builder().key("instance.uuid").value((Object)IdUtils.create()).build();
        Optional find = this.settingRepository.findByKey(setting.getKey());
        Assertions.assertThat((boolean)find.isPresent()).isFalse();
        Setting save = this.settingRepository.save(setting);
        find = this.settingRepository.findByKey(save.getKey());
        Assertions.assertThat((boolean)find.isPresent()).isTrue();
        Assertions.assertThat((Object)((Setting)find.get()).getValue()).isEqualTo(save.getValue());
        List all = this.settingRepository.findAll();
        Assertions.assertThat((int)all.size()).isGreaterThanOrEqualTo(1);
        Assertions.assertThat((List)all).extracting(Setting::getValue).contains(new Object[]{setting.getValue()});
        Setting delete = this.settingRepository.delete(setting);
        Assertions.assertThat((Object)delete.getValue()).isEqualTo(setting.getValue());
        find = this.settingRepository.findByKey(setting.getKey());
        Assertions.assertThat((boolean)find.isPresent()).isFalse();
    }
}

