/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import io.kestra.core.events.CrudEvent;
import io.kestra.core.events.CrudEventType;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.templates.Template;
import io.kestra.core.repositories.TemplateRepositoryInterface;
import io.kestra.core.utils.Await;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.debug.Return;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KestraTest
public abstract class AbstractTemplateRepositoryTest {
    @Inject
    protected TemplateRepositoryInterface templateRepository;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTemplateRepositoryTest.class);

    @BeforeAll
    protected static void init() throws IOException, URISyntaxException {
        TemplateListener.reset();
    }

    protected static Template.TemplateBuilder<?, ?> builder(String tenantId) {
        return AbstractTemplateRepositoryTest.builder(tenantId, null);
    }

    protected static Template.TemplateBuilder<?, ?> builder(String tenantId, String namespace) {
        return Template.builder().id(IdUtils.create()).namespace(namespace == null ? "kestra.test" : namespace).tenantId(tenantId).tasks(Collections.singletonList(((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id("test")).type(Return.class.getName())).format(Property.ofValue((Object)"test")).build()));
    }

    @Test
    void findById() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Template template = AbstractTemplateRepositoryTest.builder(tenant).build();
        this.templateRepository.create(template);
        Optional full = this.templateRepository.findById(tenant, template.getNamespace(), template.getId());
        Assertions.assertThat((boolean)full.isPresent()).isTrue();
        Assertions.assertThat((String)((Template)full.get()).getId()).isEqualTo(template.getId());
        full = this.templateRepository.findById(tenant, template.getNamespace(), template.getId());
        Assertions.assertThat((boolean)full.isPresent()).isTrue();
        Assertions.assertThat((String)((Template)full.get()).getId()).isEqualTo(template.getId());
    }

    @Test
    void findByNamespace() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Template template1 = AbstractTemplateRepositoryTest.builder(tenant).build();
        Template template2 = Template.builder().id(IdUtils.create()).tenantId(tenant).namespace("kestra.test.template").build();
        this.templateRepository.create(template1);
        this.templateRepository.create(template2);
        List templates = this.templateRepository.findByNamespace(tenant, template1.getNamespace());
        Assertions.assertThat((int)templates.size()).isGreaterThanOrEqualTo(1);
        templates = this.templateRepository.findByNamespace(tenant, template2.getNamespace());
        Assertions.assertThat((int)templates.size()).isEqualTo(1);
    }

    @Test
    void save() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Template template = AbstractTemplateRepositoryTest.builder(tenant).build();
        Template save = this.templateRepository.create(template);
        Assertions.assertThat((String)save.getId()).isEqualTo(template.getId());
    }

    @Test
    void findAll() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        long saveCount = this.templateRepository.findAll(tenant).size();
        Template template = AbstractTemplateRepositoryTest.builder(tenant).build();
        this.templateRepository.create(template);
        long size = this.templateRepository.findAll(tenant).size();
        Assertions.assertThat((long)size).isGreaterThan(saveCount);
        this.templateRepository.delete(template);
        Assertions.assertThat((long)this.templateRepository.findAll(tenant).size()).isEqualTo(saveCount);
    }

    @Test
    void findAllForAllTenants() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        long saveCount = this.templateRepository.findAllForAllTenants().size();
        Template template = AbstractTemplateRepositoryTest.builder(tenant).build();
        this.templateRepository.create(template);
        long size = this.templateRepository.findAllForAllTenants().size();
        Assertions.assertThat((long)size).isGreaterThan(saveCount);
    }

    @Test
    void find() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Template template1 = AbstractTemplateRepositoryTest.builder(tenant).build();
        this.templateRepository.create(template1);
        Template template2 = AbstractTemplateRepositoryTest.builder(tenant).build();
        this.templateRepository.create(template2);
        Template template3 = AbstractTemplateRepositoryTest.builder(tenant).build();
        this.templateRepository.create(template3);
        Object save = this.templateRepository.find(Pageable.from((int)1, (int)10), null, tenant, "kestra.test");
        Assertions.assertThat((long)save.size()).isGreaterThanOrEqualTo(3L);
        save = this.templateRepository.find(null, tenant, "kestra.test");
        Assertions.assertThat((long)save.size()).isGreaterThanOrEqualTo(3L);
        this.templateRepository.delete(template1);
        this.templateRepository.delete(template2);
        this.templateRepository.delete(template3);
    }

    @Test
    protected void delete() throws TimeoutException {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Template template = AbstractTemplateRepositoryTest.builder(tenant).build();
        Template save = this.templateRepository.create(template);
        this.templateRepository.delete(save);
        Assertions.assertThat((boolean)this.templateRepository.findById(tenant, template.getNamespace(), template.getId()).isPresent()).isFalse();
        Await.until(() -> {
            LOG.info("-------------> number of event: {}", (Object)TemplateListener.getEmits(tenant).size());
            return TemplateListener.getEmits(tenant).size() == 2;
        }, (Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(5L));
        Assertions.assertThat((long)TemplateListener.getEmits(tenant).stream().filter(r -> r.getType() == CrudEventType.CREATE).count()).isEqualTo(1L);
        Assertions.assertThat((long)TemplateListener.getEmits(tenant).stream().filter(r -> r.getType() == CrudEventType.DELETE).count()).isEqualTo(1L);
    }

    @Singleton
    public static class TemplateListener
    implements ApplicationEventListener<CrudEvent<Template>> {
        private static List<CrudEvent<Template>> emits = new CopyOnWriteArrayList<CrudEvent<Template>>();

        public void onApplicationEvent(CrudEvent<Template> event) {
            if (event.getModel() != null && event.getModel() instanceof Template || event.getPreviousModel() != null && event.getPreviousModel() instanceof Template) {
                emits.add(event);
            }
        }

        public static List<CrudEvent<Template>> getEmits(String tenantId) {
            return emits.stream().filter(e -> e.getModel() != null && ((Template)e.getModel()).getTenantId().equals(tenantId) || e.getPreviousModel() != null && ((Template)e.getPreviousModel()).getTenantId().equals(tenantId)).toList();
        }

        public static void reset() {
            emits = new CopyOnWriteArrayList<CrudEvent<Template>>();
        }
    }
}

