/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import io.kestra.core.exceptions.InvalidQueryFiltersException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.flows.FlowScope;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.repositories.TriggerRepositoryInterface;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.event.Level;

@KestraTest
public abstract class AbstractTriggerRepositoryTest {
    private static final String TEST_NAMESPACE = "io.kestra.unittest";
    @Inject
    protected TriggerRepositoryInterface triggerRepository;

    private static Trigger.TriggerBuilder<?, ?> trigger(String tenantId) {
        return (Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)Trigger.builder().tenantId(tenantId)).flowId(IdUtils.create())).namespace(TEST_NAMESPACE)).triggerId(IdUtils.create())).executionId(IdUtils.create()).date(ZonedDateTime.now());
    }

    protected static Trigger generateDefaultTrigger(String tenantId) {
        Trigger trigger = ((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)Trigger.builder().tenantId(tenantId)).triggerId("triggerId")).namespace("trigger.namespace")).flowId("flowId")).nextExecutionDate(ZonedDateTime.now())).build();
        trigger.setWorkerId("workerId");
        return trigger;
    }

    @ParameterizedTest
    @MethodSource(value={"filterCombinations"})
    void should_find_all(QueryFilter filter) {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.triggerRepository.save(AbstractTriggerRepositoryTest.generateDefaultTrigger(tenant));
        ArrayListTotal entries = this.triggerRepository.find(Pageable.UNPAGED, tenant, List.of(filter));
        Assertions.assertThat((List)entries).hasSize(1);
    }

    @ParameterizedTest
    @MethodSource(value={"filterCombinations"})
    void should_find_all_async(QueryFilter filter) {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.triggerRepository.save(AbstractTriggerRepositoryTest.generateDefaultTrigger(tenant));
        List entries = (List)this.triggerRepository.find(tenant, List.of(filter)).collectList().block();
        Assertions.assertThat((List)entries).hasSize(1);
    }

    static Stream<QueryFilter> filterCombinations() {
        return Stream.of(QueryFilter.builder().field(QueryFilter.Field.QUERY).value((Object)"flowId").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.SCOPE).value(List.of(FlowScope.USER)).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).value((Object)"trigger.namespace").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).value((Object)"flowId").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.START_DATE).value((Object)ZonedDateTime.now().minusMinutes(1L)).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.builder().field(QueryFilter.Field.END_DATE).value((Object)ZonedDateTime.now().plusMinutes(1L)).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).value((Object)"triggerId").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).value((Object)"workerId").operation(QueryFilter.Op.EQUALS).build());
    }

    @ParameterizedTest
    @MethodSource(value={"errorFilterCombinations"})
    void should_fail_to_find_all(QueryFilter filter) {
        org.junit.jupiter.api.Assertions.assertThrows(InvalidQueryFiltersException.class, () -> this.triggerRepository.find(Pageable.UNPAGED, TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()}), List.of(filter)));
    }

    static Stream<QueryFilter> errorFilterCombinations() {
        return Stream.of(QueryFilter.builder().field(QueryFilter.Field.LABELS).value(Map.of("key", "value")).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.STATE).value((Object)State.Type.RUNNING).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.TIME_RANGE).value((Object)"test").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).value((Object)"test").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).value((Object)"test").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).value((Object)ExecutionRepositoryInterface.ChildFilter.CHILD).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).value((Object)"test").operation(QueryFilter.Op.EQUALS).build(), QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).value((Object)Level.DEBUG).operation(QueryFilter.Op.EQUALS).build());
    }

    @Test
    void all() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Trigger.TriggerBuilder<?, ?> builder = AbstractTriggerRepositoryTest.trigger(tenant);
        Optional findLast = this.triggerRepository.findLast((TriggerContext)builder.build());
        Assertions.assertThat((boolean)findLast.isPresent()).isFalse();
        Trigger save = this.triggerRepository.save(builder.build());
        findLast = this.triggerRepository.findLast((TriggerContext)save);
        Assertions.assertThat((boolean)findLast.isPresent()).isTrue();
        Assertions.assertThat((String)((Trigger)findLast.get()).getExecutionId()).isEqualTo(save.getExecutionId());
        save = this.triggerRepository.save(builder.executionId(IdUtils.create()).build());
        findLast = this.triggerRepository.findLast((TriggerContext)save);
        Assertions.assertThat((boolean)findLast.isPresent()).isTrue();
        Assertions.assertThat((String)((Trigger)findLast.get()).getExecutionId()).isEqualTo(save.getExecutionId());
        this.triggerRepository.save(AbstractTriggerRepositoryTest.trigger(tenant).build());
        this.triggerRepository.save(AbstractTriggerRepositoryTest.trigger(tenant).build());
        Trigger searchedTrigger = AbstractTriggerRepositoryTest.trigger(tenant).build();
        this.triggerRepository.save(searchedTrigger);
        List all = this.triggerRepository.findAllForAllTenants();
        Assertions.assertThat((int)all.size()).isGreaterThanOrEqualTo(4);
        all = this.triggerRepository.findAll(tenant);
        Assertions.assertThat((int)all.size()).isEqualTo(4);
        String namespacePrefix = "io.kestra.another";
        String namespace = namespacePrefix + ".ns";
        Trigger trigger = ((Trigger.TriggerBuilder)AbstractTriggerRepositoryTest.trigger(tenant).namespace(namespace)).build();
        this.triggerRepository.save(trigger);
        ArrayListTotal find = this.triggerRepository.find(Pageable.from((int)1, (int)4, (Sort)Sort.of((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"namespace")})), null, tenant, null, null, null);
        Assertions.assertThat((int)find.size()).isEqualTo(4);
        Assertions.assertThat((String)((Trigger)find.getFirst()).getNamespace()).isEqualTo(namespace);
        find = this.triggerRepository.find(Pageable.from((int)1, (int)4, (Sort)Sort.of((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"namespace")})), null, tenant, null, searchedTrigger.getFlowId(), null);
        Assertions.assertThat((int)find.size()).isEqualTo(1);
        Assertions.assertThat((String)((Trigger)find.getFirst()).getFlowId()).isEqualTo(searchedTrigger.getFlowId());
        find = this.triggerRepository.find(Pageable.from((int)1, (int)100, (Sort)Sort.of((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)((String)this.triggerRepository.sortMapping().apply("triggerId")))})), null, tenant, namespacePrefix, null, null);
        Assertions.assertThat((int)find.size()).isEqualTo(1);
        Assertions.assertThat((String)((Trigger)find.getFirst()).getTriggerId()).isEqualTo(trigger.getTriggerId());
        find = this.triggerRepository.find(Pageable.from((int)1, (int)100, (Sort)Sort.UNSORTED), trigger.getNamespace(), tenant, null, null, null);
        Assertions.assertThat((int)find.size()).isEqualTo(1);
        Assertions.assertThat((String)((Trigger)find.getFirst()).getTriggerId()).isEqualTo(trigger.getTriggerId());
        find = this.triggerRepository.find(Pageable.from((int)1, (int)100, (Sort)Sort.UNSORTED), searchedTrigger.getFlowId(), tenant, null, null, null);
        Assertions.assertThat((int)find.size()).isEqualTo(1);
        Assertions.assertThat((String)((Trigger)find.getFirst()).getTriggerId()).isEqualTo(searchedTrigger.getTriggerId());
        find = this.triggerRepository.find(Pageable.from((int)1, (int)100, (Sort)Sort.UNSORTED), searchedTrigger.getTriggerId(), tenant, null, null, null);
        Assertions.assertThat((int)find.size()).isEqualTo(1);
        Assertions.assertThat((String)((Trigger)find.getFirst()).getTriggerId()).isEqualTo(searchedTrigger.getTriggerId());
        find = this.triggerRepository.find(Pageable.from((int)1, (int)100, (Sort)Sort.UNSORTED), searchedTrigger.getExecutionId(), tenant, null, null, null);
        Assertions.assertThat((int)find.size()).isEqualTo(1);
        Assertions.assertThat((String)((Trigger)find.getFirst()).getTriggerId()).isEqualTo(searchedTrigger.getTriggerId());
    }

    @Test
    void shouldCountForNullTenant() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        this.triggerRepository.save(((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)Trigger.builder().tenantId(tenant)).triggerId(IdUtils.create())).flowId(IdUtils.create())).namespace(TEST_NAMESPACE)).build());
        int count = this.triggerRepository.count(tenant);
        Assertions.assertThat((int)count).isEqualTo(1);
    }
}

