/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.AfterExecutionTestCase;
import io.kestra.core.runners.ChangeStateTestCase;
import io.kestra.core.runners.FlowConcurrencyCaseTest;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.runners.FlowTriggerCaseTest;
import io.kestra.core.runners.MultipleConditionTriggerCaseTest;
import io.kestra.core.runners.PluginDefaultsCaseTest;
import io.kestra.core.runners.RestartCaseTest;
import io.kestra.core.runners.SLATestCase;
import io.kestra.core.runners.ScheduleDateCaseTest;
import io.kestra.core.runners.SkipExecutionCaseTest;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.plugin.core.flow.EachSequentialTest;
import io.kestra.plugin.core.flow.FlowCaseTest;
import io.kestra.plugin.core.flow.ForEachItemCaseTest;
import io.kestra.plugin.core.flow.LoopUntilCaseTest;
import io.kestra.plugin.core.flow.PauseTest;
import io.kestra.plugin.core.flow.WorkingDirectoryTest;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@KestraTest(startRunner=true)
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class AbstractRunnerTest {
    public static final String TENANT_1 = "tenant1";
    public static final String TENANT_2 = "tenant2";
    @Inject
    protected TestRunnerUtils runnerUtils;
    @Inject
    @Named(value="workerTaskLogQueue")
    protected QueueInterface<LogEntry> logsQueue;
    @Inject
    protected RestartCaseTest restartCaseTest;
    @Inject
    protected FlowTriggerCaseTest flowTriggerCaseTest;
    @Inject
    protected MultipleConditionTriggerCaseTest multipleConditionTriggerCaseTest;
    @Inject
    private PluginDefaultsCaseTest pluginDefaultsCaseTest;
    @Inject
    protected FlowCaseTest flowCaseTest;
    @Inject
    private WorkingDirectoryTest.Suite workingDirectoryTest;
    @Inject
    protected PauseTest.Suite pauseTest;
    @Inject
    private SkipExecutionCaseTest skipExecutionCaseTest;
    @Inject
    protected ForEachItemCaseTest forEachItemCaseTest;
    @Inject
    protected LoopUntilCaseTest loopUntilTestCaseTest;
    @Inject
    protected FlowConcurrencyCaseTest flowConcurrencyCaseTest;
    @Inject
    protected ScheduleDateCaseTest scheduleDateCaseTest;
    @Inject
    protected FlowInputOutput flowIO;
    @Inject
    private SLATestCase slaTestCase;
    @Inject
    protected ChangeStateTestCase changeStateTestCase;
    @Inject
    private AfterExecutionTestCase afterExecutionTestCase;

    @Test
    @ExecuteFlow(value="flows/valids/full.yaml")
    void full(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(13);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((String)((String)((TaskRun)execution.findTaskRunsByTaskId("t2").getFirst()).getOutputs().get((Object)"value"))).contains(new CharSequence[]{"value1"});
    }

    @Test
    @ExecuteFlow(value="flows/valids/logs.yaml")
    void logs(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
    }

    @Test
    @ExecuteFlow(value="flows/valids/sequential.yaml")
    void sequential(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(11);
    }

    @Test
    @ExecuteFlow(value="flows/valids/parallel.yaml")
    void parallel(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(8);
    }

    @Test
    @ExecuteFlow(value="flows/valids/parallel-nested.yaml")
    void parallelNested(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(11);
    }

    @Test
    @ExecuteFlow(value="flows/valids/each-parallel-subflow-notfound.yml")
    void eachParallelWithSubflowMissing(Execution execution) {
        Assertions.assertThat((Object)execution).isNotNull();
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((long)execution.getTaskRunList().stream().filter(taskRun -> taskRun.getState().isFailed()).count()).isGreaterThanOrEqualTo(2L);
    }

    @Test
    @ExecuteFlow(value="flows/valids/each-sequential-nested.yaml")
    void eachSequentialNested(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(23);
    }

    @Test
    @ExecuteFlow(value="flows/valids/each-parallel.yaml")
    void eachParallel(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(8);
    }

    @Test
    @ExecuteFlow(value="flows/valids/each-parallel-nested.yaml")
    void eachParallelNested(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(11);
    }

    @Test
    @LoadFlows(value={"flows/valids/restart_last_failed.yaml"})
    void restartFailed() throws Exception {
        this.restartCaseTest.restartFailedThenSuccess();
    }

    @Test
    @LoadFlows(value={"flows/valids/restart-each.yaml"})
    void replay() throws Exception {
        this.restartCaseTest.replay();
    }

    @Test
    @LoadFlows(value={"flows/valids/failed-first.yaml"})
    void restartMultiple() throws Exception {
        this.restartCaseTest.restartMultiple();
    }

    @Test
    @LoadFlows(value={"flows/valids/restart_always_failed.yaml"})
    void restartFailedThenFailureWithGlobalErrors() throws Exception {
        this.restartCaseTest.restartFailedThenFailureWithGlobalErrors();
    }

    @Test
    @LoadFlows(value={"flows/valids/restart_local_errors.yaml"})
    protected void restartFailedThenFailureWithLocalErrors() throws Exception {
        this.restartCaseTest.restartFailedThenFailureWithLocalErrors();
    }

    @Test
    @LoadFlows(value={"flows/valids/restart-parent.yaml", "flows/valids/restart-child.yaml"})
    protected void restartSubflow() throws Exception {
        this.restartCaseTest.restartSubflow();
    }

    @Test
    @LoadFlows(value={"flows/valids/restart-with-finally.yaml"})
    protected void restartFailedWithFinally() throws Exception {
        this.restartCaseTest.restartFailedWithFinally();
    }

    @Test
    @LoadFlows(value={"flows/valids/restart-with-after-execution.yaml"})
    protected void restartFailedWithAfterExecution() throws Exception {
        this.restartCaseTest.restartFailedWithAfterExecution();
    }

    @Test
    @LoadFlows(value={"flows/valids/trigger-flow-listener-no-inputs.yaml", "flows/valids/trigger-flow-listener.yaml", "flows/valids/trigger-flow-listener-namespace-condition.yaml", "flows/valids/trigger-flow.yaml"}, tenantId="listener-tenant")
    void flowTrigger() throws Exception {
        this.flowTriggerCaseTest.trigger("listener-tenant");
    }

    @Test
    @LoadFlows(value={"flows/valids/trigger-flow-listener-with-pause.yaml", "flows/valids/trigger-flow-with-pause.yaml"})
    void flowTriggerWithPause() throws Exception {
        this.flowTriggerCaseTest.triggerWithPause();
    }

    @Test
    @LoadFlows(value={"flows/valids/trigger-flow-listener-with-concurrency-limit.yaml", "flows/valids/trigger-flow-with-concurrency-limit.yaml"}, tenantId="trigger-tenant")
    protected void flowTriggerWithConcurrencyLimit() throws Exception {
        this.flowTriggerCaseTest.triggerWithConcurrencyLimit("trigger-tenant");
    }

    @Test
    @LoadFlows(value={"flows/valids/trigger-multiplecondition-listener.yaml", "flows/valids/trigger-multiplecondition-flow-a.yaml", "flows/valids/trigger-multiplecondition-flow-b.yaml"})
    void multipleConditionTrigger() throws Exception {
        this.multipleConditionTriggerCaseTest.trigger();
    }

    @Test
    @LoadFlows(value={"flows/valids/trigger-flow-listener-namespace-condition.yaml", "flows/valids/trigger-multiplecondition-flow-c.yaml", "flows/valids/trigger-multiplecondition-flow-d.yaml"}, tenantId="condition-tenant")
    void multipleConditionTriggerFailed() throws Exception {
        this.multipleConditionTriggerCaseTest.failed("condition-tenant");
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-trigger-preconditions-flow-listen.yaml", "flows/valids/flow-trigger-preconditions-flow-a.yaml", "flows/valids/flow-trigger-preconditions-flow-b.yaml"})
    void flowTriggerPreconditions() throws Exception {
        this.multipleConditionTriggerCaseTest.flowTriggerPreconditions();
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-trigger-preconditions-flow-listen.yaml", "flows/valids/flow-trigger-preconditions-flow-a.yaml", "flows/valids/flow-trigger-preconditions-flow-b.yaml"}, tenantId="tenant1")
    void flowTriggerPreconditionsMergeOutputs() throws Exception {
        this.multipleConditionTriggerCaseTest.flowTriggerPreconditionsMergeOutputs(TENANT_1);
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-trigger-paused-listen.yaml", "flows/valids/flow-trigger-paused-flow.yaml"})
    void flowTriggerOnPaused() throws Exception {
        this.multipleConditionTriggerCaseTest.flowTriggerOnPaused();
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-trigger-for-each-item-parent.yaml", "flows/valids/flow-trigger-for-each-item-child.yaml", "flows/valids/flow-trigger-for-each-item-grandchild.yaml"})
    void forEachItemWithFlowTrigger() throws Exception {
        this.multipleConditionTriggerCaseTest.forEachItemWithFlowTrigger();
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-trigger-multiple-preconditions-flow-a.yaml", "flows/valids/flow-trigger-multiple-preconditions-flow-listen.yaml"})
    void flowTriggerMultiplePreconditions() throws Exception {
        this.multipleConditionTriggerCaseTest.flowTriggerMultiplePreconditions();
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-trigger-multiple-conditions-flow-a.yaml", "flows/valids/flow-trigger-multiple-conditions-flow-listen.yaml"})
    void flowTriggerMultipleConditions() throws Exception {
        this.multipleConditionTriggerCaseTest.flowTriggerMultipleConditions();
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-trigger-mixed-conditions-flow-a.yaml", "flows/valids/flow-trigger-mixed-conditions-flow-listen.yaml"})
    void flowTriggerMixedConditions() throws Exception {
        this.multipleConditionTriggerCaseTest.flowTriggerMixedConditions();
    }

    @Test
    @LoadFlows(value={"flows/valids/each-null.yaml"})
    void eachWithNull() throws Exception {
        EachSequentialTest.eachNullTest(this.runnerUtils, this.logsQueue);
    }

    @Test
    @LoadFlows(value={"flows/tests/plugin-defaults.yaml"})
    void taskDefaults() throws Exception {
        this.pluginDefaultsCaseTest.taskDefaults();
    }

    @Test
    @LoadFlows(value={"flows/valids/switch.yaml", "flows/valids/task-flow.yaml", "flows/valids/task-flow-inherited-labels.yaml"})
    protected void flowWaitSuccess() throws Exception {
        this.flowCaseTest.waitSuccess();
    }

    @Test
    @LoadFlows(value={"flows/valids/switch.yaml", "flows/valids/task-flow.yaml", "flows/valids/task-flow-inherited-labels.yaml"}, tenantId="tenant1")
    public void flowWaitFailed() throws Exception {
        this.flowCaseTest.waitFailed(TENANT_1);
    }

    @Test
    @LoadFlows(value={"flows/valids/switch.yaml", "flows/valids/task-flow.yaml", "flows/valids/task-flow-inherited-labels.yaml"}, tenantId="tenant2")
    public void invalidOutputs() throws Exception {
        this.flowCaseTest.invalidOutputs(TENANT_2);
    }

    @Test
    @LoadFlows(value={"flows/valids/working-directory.yaml"})
    public void workerSuccess() throws Exception {
        this.workingDirectoryTest.success(this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/working-directory.yaml"}, tenantId="tenant1")
    public void workerFailed() throws Exception {
        this.workingDirectoryTest.failed(TENANT_1, this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/working-directory-each.yaml"})
    public void workerEach() throws Exception {
        this.workingDirectoryTest.each(this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/working-directory-cache.yml"})
    public void workingDirectoryCache() throws Exception {
        this.workingDirectoryTest.cache(this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/pause-test.yaml"})
    public void pauseRun() throws Exception {
        this.pauseTest.run(this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/pause-delay.yaml"})
    public void pauseRunDelay() throws Exception {
        this.pauseTest.runDelay(this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/pause-duration-from-input.yaml"})
    public void pauseRunDurationFromInput() throws Exception {
        this.pauseTest.runDurationFromInput(this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/each-parallel-pause.yml"})
    public void pauseRunParallelDelay() throws Exception {
        this.pauseTest.runParallelDelay(this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/pause-timeout.yaml"})
    public void pauseRunTimeout() throws Exception {
        this.pauseTest.runTimeout(this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/minimal.yaml"})
    void skipExecution() throws Exception {
        this.skipExecutionCaseTest.skipExecution();
    }

    @Test
    @LoadFlows(value={"flows/valids/for-each-item-subflow.yaml", "flows/valids/for-each-item.yaml"})
    protected void forEachItem() throws Exception {
        this.forEachItemCaseTest.forEachItem();
    }

    @Test
    @LoadFlows(value={"flows/valids/for-each-item.yaml"}, tenantId="tenant1")
    protected void forEachItemEmptyItems() throws Exception {
        this.forEachItemCaseTest.forEachItemEmptyItems(TENANT_1);
    }

    @Test
    @LoadFlows(value={"flows/valids/for-each-item-subflow-failed.yaml", "flows/valids/for-each-item-failed.yaml"})
    protected void forEachItemFailed() throws Exception {
        this.forEachItemCaseTest.forEachItemFailed();
    }

    @Test
    @LoadFlows(value={"flows/valids/for-each-item-outputs-subflow.yaml", "flows/valids/for-each-item-outputs.yaml"})
    protected void forEachItemSubflowOutputs() throws Exception {
        this.forEachItemCaseTest.forEachItemWithSubflowOutputs();
    }

    @Test
    @LoadFlows(value={"flows/valids/restart-for-each-item.yaml", "flows/valids/restart-child.yaml"}, tenantId="tenant1")
    void restartForEachItem() throws Exception {
        this.forEachItemCaseTest.restartForEachItem(TENANT_1);
    }

    @Test
    @LoadFlows(value={"flows/valids/for-each-item-subflow.yaml", "flows/valids/for-each-item-in-if.yaml"}, tenantId="tenant1")
    protected void forEachItemInIf() throws Exception {
        this.forEachItemCaseTest.forEachItemInIf(TENANT_1);
    }

    @Test
    @LoadFlows(value={"flows/valids/for-each-item-subflow-after-execution.yaml", "flows/valids/for-each-item-after-execution.yaml"})
    protected void forEachItemWithAfterExecution() throws Exception {
        this.forEachItemCaseTest.forEachItemWithAfterExecution();
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-concurrency-cancel.yml"})
    void concurrencyCancel() throws Exception {
        this.flowConcurrencyCaseTest.flowConcurrencyCancel();
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-concurrency-fail.yml"})
    void concurrencyFail() throws Exception {
        this.flowConcurrencyCaseTest.flowConcurrencyFail();
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-concurrency-queue.yml"})
    void concurrencyQueue() throws Exception {
        this.flowConcurrencyCaseTest.flowConcurrencyQueue();
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-concurrency-queue-pause.yml"})
    protected void concurrencyQueuePause() throws Exception {
        this.flowConcurrencyCaseTest.flowConcurrencyQueuePause();
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-concurrency-cancel-pause.yml"})
    protected void concurrencyCancelPause() throws Exception {
        this.flowConcurrencyCaseTest.flowConcurrencyCancelPause();
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-concurrency-for-each-item.yaml", "flows/valids/flow-concurrency-queue.yml"}, tenantId="tenant1")
    protected void flowConcurrencyWithForEachItem() throws Exception {
        this.flowConcurrencyCaseTest.flowConcurrencyWithForEachItem(TENANT_1);
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-concurrency-queue-fail.yml"})
    protected void concurrencyQueueRestarted() throws Exception {
        this.flowConcurrencyCaseTest.flowConcurrencyQueueRestarted();
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-concurrency-queue-after-execution.yml"})
    void concurrencyQueueAfterExecution() throws Exception {
        this.flowConcurrencyCaseTest.flowConcurrencyQueueAfterExecution();
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-concurrency-subflow.yml", "flows/valids/flow-concurrency-cancel.yml"}, tenantId="tenant1")
    void flowConcurrencySubflow() throws Exception {
        this.flowConcurrencyCaseTest.flowConcurrencySubflow(TENANT_1);
    }

    @Test
    @LoadFlows(value={"flows/valids/flow-concurrency-parallel-subflow-kill.yaml", "flows/valids/flow-concurrency-parallel-subflow-kill-child.yaml", "flows/valids/flow-concurrency-parallel-subflow-kill-grandchild.yaml"})
    void flowConcurrencyParallelSubflowKill() throws Exception {
        this.flowConcurrencyCaseTest.flowConcurrencyParallelSubflowKill();
    }

    @Test
    @ExecuteFlow(value="flows/valids/executable-fail.yml")
    void badExecutable(Execution execution) {
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)((TaskRun)execution.getTaskRunList().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    @Test
    @ExecuteFlow(value="flows/valids/dynamic-task.yaml")
    void dynamicTask(Execution execution) {
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(3);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/waitfor.yaml"})
    void waitFor() throws Exception {
        this.loopUntilTestCaseTest.waitfor();
    }

    @Test
    @LoadFlows(value={"flows/valids/waitfor-max-iterations.yaml"})
    void waitforMaxIterations() throws Exception {
        this.loopUntilTestCaseTest.waitforMaxIterations();
    }

    @Test
    @LoadFlows(value={"flows/valids/waitfor-max-duration.yaml"})
    void waitforMaxDuration() throws Exception {
        this.loopUntilTestCaseTest.waitforMaxDuration();
    }

    @Test
    @LoadFlows(value={"flows/valids/waitfor-no-success.yaml"})
    void waitforNoSuccess() throws Exception {
        this.loopUntilTestCaseTest.waitforNoSuccess();
    }

    @Test
    @LoadFlows(value={"flows/valids/waitfor-multiple-tasks.yaml"})
    void waitforMultipleTasks() throws Exception {
        this.loopUntilTestCaseTest.waitforMultipleTasks();
    }

    @Test
    @LoadFlows(value={"flows/valids/waitfor-multiple-tasks-failed.yaml"})
    void waitforMultipleTasksFailed() throws Exception {
        this.loopUntilTestCaseTest.waitforMultipleTasksFailed();
    }

    @Test
    @LoadFlows(value={"flows/valids/minimal.yaml"}, tenantId="tenant1")
    void shouldScheduleOnDate() throws Exception {
        this.scheduleDateCaseTest.shouldScheduleOnDate(TENANT_1);
    }

    @Test
    @LoadFlows(value={"flows/valids/sla-max-duration-fail.yaml"})
    void maxDurationSLAShouldFail() throws Exception {
        this.slaTestCase.maxDurationSLAShouldFail();
    }

    @Test
    @LoadFlows(value={"flows/valids/sla-max-duration-ok.yaml"})
    void maxDurationSLAShouldPass() throws Exception {
        this.slaTestCase.maxDurationSLAShouldPass();
    }

    @Test
    @LoadFlows(value={"flows/valids/sla-execution-condition.yaml"})
    void executionConditionSLAShouldPass() throws Exception {
        this.slaTestCase.executionConditionSLAShouldPass();
    }

    @Test
    @LoadFlows(value={"flows/valids/sla-execution-condition.yaml"}, tenantId="tenant1")
    void executionConditionSLAShouldCancel() throws Exception {
        this.slaTestCase.executionConditionSLAShouldCancel(TENANT_1);
    }

    @Test
    @LoadFlows(value={"flows/valids/sla-execution-condition.yaml"}, tenantId="tenant2")
    void executionConditionSLAShouldLabel() throws Exception {
        this.slaTestCase.executionConditionSLAShouldLabel(TENANT_2);
    }

    @Test
    @LoadFlows(value={"flows/valids/sla-parent-flow.yaml", "flows/valids/sla-subflow.yaml"})
    void slaViolationOnSubflowMayEndTheParentFlow() throws Exception {
        this.slaTestCase.slaViolationOnSubflowMayEndTheParentFlow();
    }

    @Test
    @LoadFlows(value={"flows/valids/if.yaml"})
    void multipleIf() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "if", null, (f, e) -> Map.of("if1", true, "if2", false, "if3", true));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(12);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="flows/valids/failed-first.yaml", tenantId="tenant1")
    public void changeStateShouldEndsInSuccess(Execution execution) throws Exception {
        this.changeStateTestCase.changeStateShouldEndsInSuccess(execution);
    }

    @Test
    @LoadFlows(value={"flows/valids/failed-first.yaml", "flows/valids/subflow-parent-of-failed.yaml"}, tenantId="tenant2")
    public void changeStateInSubflowShouldEndsParentFlowInSuccess() throws Exception {
        this.changeStateTestCase.changeStateInSubflowShouldEndsParentFlowInSuccess(TENANT_2);
    }

    @Test
    @ExecuteFlow(value="flows/valids/after-execution.yaml")
    public void shouldCallTasksAfterExecution(Execution execution) {
        this.afterExecutionTestCase.shouldCallTasksAfterExecution(execution);
    }

    @Test
    @ExecuteFlow(value="flows/valids/after-execution-finally.yaml")
    public void shouldCallTasksAfterFinally(Execution execution) {
        this.afterExecutionTestCase.shouldCallTasksAfterFinally(execution);
    }

    @Test
    @ExecuteFlow(value="flows/valids/after-execution-error.yaml")
    public void shouldCallTasksAfterError(Execution execution) {
        this.afterExecutionTestCase.shouldCallTasksAfterError(execution);
    }

    @Test
    @ExecuteFlow(value="flows/valids/after-execution-listener.yaml")
    public void shouldCallTasksAfterListener(Execution execution) {
        this.afterExecutionTestCase.shouldCallTasksAfterListener(execution);
    }
}

