/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;

@Singleton
public class AfterExecutionTestCase {
    public void shouldCallTasksAfterExecution(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        TaskRun taskRun = (TaskRun)execution.getTaskRunList().getFirst();
        Assertions.assertThat((String)taskRun.getTaskId()).isEqualTo("mytask");
        Assertions.assertThat((Comparable)taskRun.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        TaskRun afterExecution = (TaskRun)execution.getTaskRunList().getLast();
        Assertions.assertThat((String)afterExecution.getTaskId()).isEqualTo("end");
        Assertions.assertThat((Comparable)afterExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Instant)afterExecution.getState().getStartDate()).isAfterOrEqualTo((Instant)taskRun.getState().getEndDate().orElseThrow());
        Assertions.assertThat((Instant)afterExecution.getState().getStartDate()).isAfterOrEqualTo((Instant)execution.getState().getEndDate().orElseThrow());
        Map outputs = (Map)afterExecution.getOutputs().get((Object)"values");
        Assertions.assertThat(outputs.get("state")).isEqualTo((Object)"SUCCESS");
        Assertions.assertThat(outputs.get("output")).isEqualTo((Object)"this is a task output used as a final flow output");
    }

    public void shouldCallTasksAfterFinally(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        TaskRun taskRun = (TaskRun)execution.getTaskRunList().getFirst();
        Assertions.assertThat((Comparable)taskRun.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        TaskRun finallyTaskRun = (TaskRun)execution.getTaskRunList().get(1);
        Assertions.assertThat((Comparable)finallyTaskRun.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Instant)finallyTaskRun.getState().getStartDate()).isAfterOrEqualTo((Instant)taskRun.getState().getEndDate().orElseThrow());
        TaskRun afterExecution = (TaskRun)execution.getTaskRunList().getLast();
        Assertions.assertThat((Comparable)afterExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Instant)afterExecution.getState().getStartDate()).isAfterOrEqualTo((Instant)finallyTaskRun.getState().getEndDate().orElseThrow());
        Assertions.assertThat((Instant)afterExecution.getState().getStartDate()).isAfterOrEqualTo((Instant)execution.getState().getEndDate().orElseThrow());
        Map outputs = (Map)afterExecution.getOutputs().get((Object)"values");
        Assertions.assertThat(outputs.get("state")).isEqualTo((Object)"SUCCESS");
    }

    public void shouldCallTasksAfterError(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        TaskRun taskRun = (TaskRun)execution.getTaskRunList().getFirst();
        Assertions.assertThat((Comparable)taskRun.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        TaskRun errorTaskRun = (TaskRun)execution.getTaskRunList().get(1);
        Assertions.assertThat((Comparable)errorTaskRun.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Instant)errorTaskRun.getState().getStartDate()).isAfterOrEqualTo((Instant)taskRun.getState().getEndDate().orElseThrow());
        TaskRun afterExecution = (TaskRun)execution.getTaskRunList().getLast();
        Assertions.assertThat((Comparable)afterExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Instant)afterExecution.getState().getStartDate()).isAfterOrEqualTo((Instant)taskRun.getState().getEndDate().orElseThrow());
        Assertions.assertThat((Instant)afterExecution.getState().getStartDate()).isAfterOrEqualTo((Instant)execution.getState().getEndDate().orElseThrow());
        Map outputs = (Map)afterExecution.getOutputs().get((Object)"values");
        Assertions.assertThat(outputs.get("state")).isEqualTo((Object)"FAILED");
    }

    public void shouldCallTasksAfterListener(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        TaskRun taskRun = (TaskRun)execution.getTaskRunList().getFirst();
        Assertions.assertThat((Comparable)taskRun.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        TaskRun listenerTaskRun = (TaskRun)execution.getTaskRunList().get(1);
        Assertions.assertThat((Comparable)taskRun.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Instant)listenerTaskRun.getState().getStartDate()).isAfterOrEqualTo((Instant)taskRun.getState().getEndDate().orElseThrow());
        TaskRun afterExecution = (TaskRun)execution.getTaskRunList().getLast();
        Assertions.assertThat((Comparable)afterExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Instant)afterExecution.getState().getStartDate()).isAfterOrEqualTo((Instant)listenerTaskRun.getState().getEndDate().orElseThrow());
        Assertions.assertThat((Instant)afterExecution.getState().getStartDate()).isAfterOrEqualTo((Instant)execution.getState().getEndDate().orElseThrow());
        Map outputs = (Map)afterExecution.getOutputs().get((Object)"values");
        Assertions.assertThat(outputs.get("state")).isEqualTo((Object)"SUCCESS");
    }
}

