/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.services.ExecutionService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import org.assertj.core.api.Assertions;

@Singleton
public class ChangeStateTestCase {
    public static final String NAMESPACE = "io.kestra.tests";
    @Inject
    private FlowRepositoryInterface flowRepository;
    @Inject
    private ExecutionService executionService;
    @Inject
    private TestRunnerUtils runnerUtils;

    public void changeStateShouldEndsInSuccess(Execution execution) throws Exception {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)((TaskRun)execution.getTaskRunList().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Flow flow = this.flowRepository.findByExecution(execution);
        Execution markedAs = this.executionService.markAs(execution, (FlowInterface)flow, ((TaskRun)execution.getTaskRunList().getFirst()).getId(), State.Type.SUCCESS);
        Execution lastExecution = this.runnerUtils.emitAndAwaitExecution(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS), markedAs);
        Assertions.assertThat((Comparable)lastExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)lastExecution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)((TaskRun)lastExecution.getTaskRunList().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    public void changeStateInSubflowShouldEndsParentFlowInSuccess(String tenantId) throws Exception {
        Execution execution = this.runnerUtils.runOne(tenantId, NAMESPACE, "subflow-parent-of-failed");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)((TaskRun)execution.getTaskRunList().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Execution lastExecution = this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().equals((Object)State.Type.FAILED), tenantId, NAMESPACE, "failed-first");
        Assertions.assertThat((Comparable)lastExecution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)lastExecution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)((TaskRun)lastExecution.getTaskRunList().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Flow flow = this.flowRepository.findByExecution(lastExecution);
        Execution markedAs = this.executionService.markAs(lastExecution, (FlowInterface)flow, ((TaskRun)lastExecution.getTaskRunList().getFirst()).getId(), State.Type.SUCCESS);
        this.runnerUtils.emitAndAwaitExecution(e -> e.getState().isTerminated(), markedAs);
        Execution lastParentExecution = this.runnerUtils.awaitFlowExecution(e -> ((TaskRun)e.getTaskRunList().getFirst()).getState().getCurrent().equals((Object)State.Type.SUCCESS), tenantId, NAMESPACE, "subflow-parent-of-failed");
        Assertions.assertThat((Comparable)lastParentExecution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)lastParentExecution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)((TaskRun)lastParentExecution.getTaskRunList().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }
}

