/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.SecureVariableRendererFactory;
import io.kestra.core.runners.VariableRenderer;
import io.micronaut.context.ApplicationContext;
import io.micronaut.test.annotation.MockBean;
import jakarta.inject.Inject;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class CustomVariableRendererTest {
    @Inject
    private SecureVariableRendererFactory secureVariableRendererFactory;
    @Inject
    private VariableRenderer renderer;

    CustomVariableRendererTest() {
    }

    @Test
    void shouldUseCustomVariableRender() throws IllegalVariableEvaluationException {
        String result = this.renderer.render("{{ dummy }}", Map.of());
        Assertions.assertThat((String)result).isEqualTo("alternativeRender");
    }

    @Test
    void shouldUseCustomVariableRenderWhenUsingSecured() throws IllegalVariableEvaluationException {
        VariableRenderer renderer = this.secureVariableRendererFactory.createOrGet();
        String result = renderer.render("{{ dummy }}", Map.of());
        Assertions.assertThat((String)result).isEqualTo("alternativeRender");
    }

    @MockBean(value=VariableRenderer.class)
    VariableRenderer testCustomRenderer(ApplicationContext applicationContext) {
        return new VariableRenderer(this, applicationContext, null){

            protected String alternativeRender(Exception e, String inline, Map<String, Object> variables) {
                return "alternativeRender";
            }
        };
    }
}

