/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.encryption.EncryptionService;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Value;
import io.micronaut.test.extensions.junit5.annotation.MicronautTest;
import jakarta.inject.Inject;
import java.security.GeneralSecurityException;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@MicronautTest
class DefaultRunContextTest {
    @Inject
    private ApplicationContext applicationContext;
    @Value(value="${kestra.encryption.secret-key}")
    private String secretKey;
    @Inject
    private TestRunContextFactory runContextFactory;

    DefaultRunContextTest() {
    }

    @Test
    void shouldGetKestraVersion() {
        DefaultRunContext runContext = new DefaultRunContext();
        runContext.init(this.applicationContext);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)runContext.version());
    }

    @Test
    void shouldDecryptVariables() throws GeneralSecurityException, IllegalVariableEvaluationException {
        RunContext runContext = this.runContextFactory.of();
        String encryptedSecret = EncryptionService.encrypt((String)this.secretKey, (String)"It's a secret");
        Map<String, Map<String, String>> variables = Map.of("test", "test", "secret", Map.of("type", "io.kestra.datatype:aes_encrypted", "value", encryptedSecret));
        String render = runContext.render("What ? {{secret}}", variables);
        Assertions.assertThat((String)render).isEqualTo("What ? It's a secret");
    }
}

