/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
public class EmptyVariablesTest {
    @Inject
    private TestRunnerUtils runnerUtils;
    @Inject
    private FlowInputOutput flowIO;

    @Test
    @LoadFlows(value={"flows/valids/empty-variables.yml"})
    void emptyVariables() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "empty-variables", null, (flow, exec) -> this.flowIO.readExecutionInputs(flow, exec, Map.of("emptyKey", "{ \"foo\": \"\" }", "emptySubObject", "{\"json\":{\"someEmptyObject\":{}}}")));
        Assertions.assertThat((Object)execution).isNotNull();
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
    }
}

