/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.Label;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.flows.GenericFlow;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.repositories.LogRepositoryInterface;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.services.ExecutionService;
import io.kestra.core.utils.Await;
import io.kestra.plugin.core.debug.Return;
import io.kestra.plugin.core.flow.Pause;
import jakarta.inject.Inject;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.RetryingTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@KestraTest(startRunner=true)
class ExecutionServiceTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutionServiceTest.class);
    public static final String TENANT_1 = "tenant1";
    public static final String TENANT_2 = "tenant2";
    public static final String TENANT_3 = "tenant3";
    @Inject
    ExecutionService executionService;
    @Inject
    FlowRepositoryInterface flowRepository;
    @Inject
    ExecutionRepositoryInterface executionRepository;
    @Inject
    LogRepositoryInterface logRepository;
    @Inject
    TestRunnerUtils runnerUtils;

    ExecutionServiceTest() {
    }

    @Test
    @LoadFlows(value={"flows/valids/restart_last_failed.yaml"})
    void restartSimple() throws Exception {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "restart_last_failed");
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Execution restart = this.executionService.restart(execution, null);
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)restart.getState().getHistories()).hasSize(4);
        Assertions.assertThat((List)restart.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)((TaskRun)restart.getTaskRunList().get(2)).getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)((TaskRun)restart.getTaskRunList().get(2)).getState().getHistories()).hasSize(5);
        Assertions.assertThat((String)restart.getId()).isEqualTo(execution.getId());
        Assertions.assertThat((String)((TaskRun)restart.getTaskRunList().get(2)).getId()).isEqualTo(((TaskRun)execution.getTaskRunList().get(2)).getId());
        Assertions.assertThat((List)restart.getLabels()).contains((Object[])new Label[]{new Label("system.restarted", "true")});
    }

    @Test
    @LoadFlows(value={"flows/valids/restart_last_failed.yaml"}, tenantId="tenant1")
    void restartSimpleRevision() throws Exception {
        Execution execution = this.runnerUtils.runOne(TENANT_1, "io.kestra.tests", "restart_last_failed");
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        FlowWithSource flow = (FlowWithSource)this.flowRepository.findByIdWithSource(TENANT_1, "io.kestra.tests", "restart_last_failed").orElseThrow();
        this.flowRepository.update(GenericFlow.of((FlowInterface)flow), (FlowInterface)flow.updateTask("a", (Task)((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id("a")).type(Return.class.getName())).format(Property.ofValue((Object)"replace")).build()));
        Execution restart = this.executionService.restart(execution, Integer.valueOf(2));
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)restart.getState().getHistories()).hasSize(4);
        Assertions.assertThat((List)restart.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)((TaskRun)restart.getTaskRunList().get(2)).getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)((TaskRun)restart.getTaskRunList().get(2)).getState().getHistories()).hasSize(5);
        Assertions.assertThat((String)restart.getId()).isNotEqualTo((Object)execution.getId());
        Assertions.assertThat((String)((TaskRun)restart.getTaskRunList().get(2)).getId()).isNotEqualTo((Object)((TaskRun)execution.getTaskRunList().get(2)).getId());
        Assertions.assertThat((List)restart.getLabels()).contains((Object[])new Label[]{new Label("system.restarted", "true")});
    }

    @RetryingTest(value=5)
    @LoadFlows(value={"flows/valids/restart-each.yaml"})
    void restartFlowable() throws Exception {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "restart-each", null, (f, e) -> ImmutableMap.of((Object)"failed", (Object)"FIRST"));
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Execution restart = this.executionService.restart(execution, null);
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)restart.getState().getHistories()).hasSize(4);
        Assertions.assertThat((long)restart.getTaskRunList().stream().filter(taskRun -> taskRun.getState().getCurrent() == State.Type.RESTARTED).count()).isGreaterThan(1L);
        Assertions.assertThat((long)restart.getTaskRunList().stream().filter(taskRun -> taskRun.getState().getCurrent() == State.Type.RUNNING).count()).isGreaterThan(1L);
        Assertions.assertThat((String)((TaskRun)restart.getTaskRunList().getFirst()).getId()).isEqualTo(((TaskRun)restart.getTaskRunList().getFirst()).getId());
        Assertions.assertThat((List)restart.getLabels()).contains((Object[])new Label[]{new Label("system.restarted", "true")});
    }

    @RetryingTest(value=5)
    @LoadFlows(value={"flows/valids/restart-each.yaml"}, tenantId="tenant1")
    void restartFlowable2() throws Exception {
        Execution execution = this.runnerUtils.runOne(TENANT_1, "io.kestra.tests", "restart-each", null, (f, e) -> ImmutableMap.of((Object)"failed", (Object)"SECOND"));
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Execution restart = this.executionService.restart(execution, null);
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)restart.getState().getHistories()).hasSize(4);
        Assertions.assertThat((long)restart.getTaskRunList().stream().filter(taskRun -> taskRun.getState().getCurrent() == State.Type.RESTARTED).count()).isGreaterThan(1L);
        Assertions.assertThat((long)restart.getTaskRunList().stream().filter(taskRun -> taskRun.getState().getCurrent() == State.Type.RUNNING).count()).isGreaterThan(1L);
        Assertions.assertThat((String)((TaskRun)restart.getTaskRunList().getFirst()).getId()).isEqualTo(((TaskRun)restart.getTaskRunList().getFirst()).getId());
        Assertions.assertThat((List)restart.getLabels()).contains((Object[])new Label[]{new Label("system.restarted", "true")});
    }

    @Test
    @LoadFlows(value={"flows/valids/working-directory.yaml"})
    void restartDynamic() throws Exception {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "working-directory", null, (f, e) -> ImmutableMap.of((Object)"failed", (Object)"true"));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Execution restart = this.executionService.restart(execution, null);
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)restart.getState().getHistories()).hasSize(4);
        Assertions.assertThat((Comparable)((TaskRun)restart.getTaskRunList().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)((TaskRun)restart.getTaskRunList().getFirst()).getState().getHistories()).hasSize(4);
        Assertions.assertThat((List)restart.getLabels()).contains((Object[])new Label[]{new Label("system.restarted", "true")});
    }

    @Test
    @LoadFlows(value={"flows/valids/logs.yaml"})
    void replayFromBeginning() throws Exception {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "logs");
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution restart = this.executionService.replay(execution, null, null);
        Assertions.assertThat((String)restart.getId()).isNotEqualTo((Object)execution.getId());
        Assertions.assertThat((String)restart.getNamespace()).isEqualTo("io.kestra.tests");
        Assertions.assertThat((String)restart.getFlowId()).isEqualTo("logs");
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.CREATED);
        Assertions.assertThat((List)restart.getState().getHistories()).hasSize(1);
        MatcherAssert.assertThat((Object)((State.History)restart.getState().getHistories().getFirst()).getDate(), (Matcher)Matchers.not((Matcher)Matchers.is((Object)execution.getState().getStartDate())));
        Assertions.assertThat((List)restart.getTaskRunList()).hasSize(0);
        Assertions.assertThat((String)restart.getId()).isNotEqualTo((Object)execution.getId());
        Assertions.assertThat((List)restart.getLabels()).contains((Object[])new Label[]{new Label("system.replay", "true")});
    }

    @Test
    @LoadFlows(value={"flows/valids/logs.yaml"}, tenantId="tenant1")
    void replaySimple() throws Exception {
        Execution execution = this.runnerUtils.runOne(TENANT_1, "io.kestra.tests", "logs");
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution restart = this.executionService.replay(execution, ((TaskRun)execution.getTaskRunList().get(1)).getId(), null);
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)restart.getState().getHistories()).hasSize(4);
        Assertions.assertThat((List)restart.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)((TaskRun)restart.getTaskRunList().get(1)).getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)((TaskRun)restart.getTaskRunList().get(1)).getState().getHistories()).hasSize(5);
        Assertions.assertThat((String)restart.getId()).isNotEqualTo((Object)execution.getId());
        Assertions.assertThat((String)((TaskRun)restart.getTaskRunList().get(1)).getId()).isNotEqualTo((Object)((TaskRun)execution.getTaskRunList().get(1)).getId());
        Assertions.assertThat((List)restart.getLabels()).contains((Object[])new Label[]{new Label("system.replay", "true")});
    }

    @Test
    @LoadFlows(value={"flows/valids/restart-each.yaml"}, tenantId="tenant2")
    void replayFlowable() throws Exception {
        Execution execution = this.runnerUtils.runOne(TENANT_2, "io.kestra.tests", "restart-each", null, (f, e) -> ImmutableMap.of((Object)"failed", (Object)"NO"));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(20);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution restart = this.executionService.replay(execution, execution.findTaskRunByTaskIdAndValue("2_end", List.of()).getId(), null);
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)restart.getState().getHistories()).hasSize(4);
        Assertions.assertThat((List)restart.getTaskRunList()).hasSize(20);
        Assertions.assertThat((Comparable)((TaskRun)restart.getTaskRunList().get(19)).getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((String)restart.getId()).isNotEqualTo((Object)execution.getId());
        Assertions.assertThat((String)((TaskRun)restart.getTaskRunList().get(1)).getId()).isNotEqualTo((Object)((TaskRun)execution.getTaskRunList().get(1)).getId());
        Assertions.assertThat((List)restart.getLabels()).contains((Object[])new Label[]{new Label("system.replay", "true")});
    }

    @Test
    @LoadFlows(value={"flows/valids/parallel-nested.yaml"})
    void replayParallel() throws Exception {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "parallel-nested");
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(11);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution restart = this.executionService.replay(execution, execution.findTaskRunByTaskIdAndValue("1-3-2_par", List.of()).getId(), null);
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)restart.getState().getHistories()).hasSize(4);
        Assertions.assertThat((List)restart.getTaskRunList()).hasSize(8);
        Assertions.assertThat((Comparable)restart.findTaskRunByTaskIdAndValue("1-3-2_par", List.of()).getState().getCurrent()).isEqualTo((Object)State.Type.RUNNING);
        Assertions.assertThat((List)restart.findTaskRunByTaskIdAndValue("1-3-2_par", List.of()).getState().getHistories()).hasSize(4);
        Assertions.assertThat((String)restart.getId()).isNotEqualTo((Object)execution.getId());
        Assertions.assertThat((String)((TaskRun)restart.getTaskRunList().get(1)).getId()).isNotEqualTo((Object)((TaskRun)execution.getTaskRunList().get(1)).getId());
        Assertions.assertThat((List)restart.getLabels()).contains((Object[])new Label[]{new Label("system.replay", "true")});
    }

    @Test
    @ExecuteFlow(value="flows/valids/each-sequential-nested.yaml", tenantId="tenant2")
    void replayEachSeq(Execution execution) throws Exception {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(23);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution restart = this.executionService.replay(execution, execution.findTaskRunByTaskIdAndValue("1-2_each", List.of("s1")).getId(), null);
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)restart.getState().getHistories()).hasSize(4);
        Assertions.assertThat((List)restart.getTaskRunList()).hasSize(5);
        Assertions.assertThat((Comparable)restart.findTaskRunByTaskIdAndValue("1-2_each", List.of("s1")).getState().getCurrent()).isEqualTo((Object)State.Type.RUNNING);
        Assertions.assertThat((List)restart.findTaskRunByTaskIdAndValue("1-2_each", List.of("s1")).getState().getHistories()).hasSize(4);
        Assertions.assertThat((String)restart.getId()).isNotEqualTo((Object)execution.getId());
        Assertions.assertThat((String)((TaskRun)restart.getTaskRunList().get(1)).getId()).isNotEqualTo((Object)((TaskRun)execution.getTaskRunList().get(1)).getId());
        Assertions.assertThat((List)restart.getLabels()).contains((Object[])new Label[]{new Label("system.replay", "true")});
    }

    @Test
    @ExecuteFlow(value="flows/valids/each-sequential-nested.yaml", tenantId="tenant1")
    void replayEachSeq2(Execution execution) throws Exception {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(23);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution restart = this.executionService.replay(execution, execution.findTaskRunByTaskIdAndValue("1-2-1_return", List.of("s1", "a a")).getId(), null);
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)restart.getState().getHistories()).hasSize(4);
        Assertions.assertThat((List)restart.getTaskRunList()).hasSize(6);
        Assertions.assertThat((Comparable)restart.findTaskRunByTaskIdAndValue("1-2_each", List.of("s1")).getState().getCurrent()).isEqualTo((Object)State.Type.RUNNING);
        Assertions.assertThat((List)restart.findTaskRunByTaskIdAndValue("1-2_each", List.of("s1")).getState().getHistories()).hasSize(4);
        Assertions.assertThat((String)restart.getId()).isNotEqualTo((Object)execution.getId());
        Assertions.assertThat((String)((TaskRun)restart.getTaskRunList().get(1)).getId()).isNotEqualTo((Object)((TaskRun)execution.getTaskRunList().get(1)).getId());
        Assertions.assertThat((List)restart.getLabels()).contains((Object[])new Label[]{new Label("system.replay", "true")});
    }

    @Test
    @LoadFlows(value={"flows/valids/dynamic-task.yaml"})
    void replayWithADynamicTask() throws Exception {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "dynamic-task");
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution restart = this.executionService.replay(execution, ((TaskRun)execution.getTaskRunList().get(2)).getId(), null);
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)restart.getState().getHistories()).hasSize(4);
        Assertions.assertThat((List)restart.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)((TaskRun)restart.getTaskRunList().get(2)).getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)((TaskRun)restart.getTaskRunList().get(2)).getState().getHistories()).hasSize(5);
        Assertions.assertThat((String)restart.getId()).isNotEqualTo((Object)execution.getId());
        Assertions.assertThat((String)((TaskRun)restart.getTaskRunList().get(1)).getId()).isNotEqualTo((Object)((TaskRun)execution.getTaskRunList().get(1)).getId());
        Assertions.assertThat((List)restart.getLabels()).contains((Object[])new Label[]{new Label("system.replay", "true")});
    }

    @Test
    @LoadFlows(value={"flows/valids/each-parallel-nested.yaml"})
    void replayEachPara() throws Exception {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "each-parallel-nested");
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(11);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution restart = this.executionService.replay(execution, execution.findTaskRunByTaskIdAndValue("2-1_seq", List.of("value 1")).getId(), null);
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)restart.getState().getHistories()).hasSize(4);
        Assertions.assertThat((List)restart.getTaskRunList()).hasSize(8);
        Assertions.assertThat((Comparable)restart.findTaskRunByTaskIdAndValue("2-1_seq", List.of("value 1")).getState().getCurrent()).isEqualTo((Object)State.Type.RUNNING);
        Assertions.assertThat((List)restart.findTaskRunByTaskIdAndValue("2-1_seq", List.of("value 1")).getState().getHistories()).hasSize(4);
        Assertions.assertThat((String)restart.getId()).isNotEqualTo((Object)execution.getId());
        Assertions.assertThat((String)((TaskRun)restart.getTaskRunList().get(1)).getId()).isNotEqualTo((Object)((TaskRun)execution.getTaskRunList().get(1)).getId());
        Assertions.assertThat((List)restart.getLabels()).contains((Object[])new Label[]{new Label("system.replay", "true")});
    }

    @Test
    @LoadFlows(value={"flows/valids/each-parallel-nested.yaml"}, tenantId="tenant1")
    void markAsEachPara() throws Exception {
        Execution execution = this.runnerUtils.runOne(TENANT_1, "io.kestra.tests", "each-parallel-nested");
        Flow flow = this.flowRepository.findByExecution(execution);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(11);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution restart = this.executionService.markAs(execution, (FlowInterface)flow, execution.findTaskRunByTaskIdAndValue("2-1_seq", List.of("value 1")).getId(), State.Type.FAILED);
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((Integer)restart.getMetadata().getAttemptNumber()).isEqualTo(2);
        Assertions.assertThat((List)restart.getState().getHistories()).hasSize(4);
        Assertions.assertThat((List)restart.getTaskRunList()).hasSize(11);
        Assertions.assertThat((Comparable)restart.findTaskRunByTaskIdAndValue("1_each", List.of()).getState().getCurrent()).isEqualTo((Object)State.Type.RUNNING);
        Assertions.assertThat((Comparable)restart.findTaskRunByTaskIdAndValue("2-1_seq", List.of("value 1")).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)restart.findTaskRunByTaskIdAndValue("2-1_seq", List.of("value 1")).getState().getHistories()).hasSize(4);
        Assertions.assertThat((Comparable)((TaskRunAttempt)restart.findTaskRunByTaskIdAndValue("2-1_seq", List.of("value 1")).getAttempts().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        restart = this.executionService.markAs(execution, (FlowInterface)flow, execution.findTaskRunByTaskIdAndValue("2-1-2_t2", List.of("value 1")).getId(), State.Type.FAILED);
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)restart.getState().getHistories()).hasSize(4);
        Assertions.assertThat((List)restart.getTaskRunList()).hasSize(11);
        Assertions.assertThat((Comparable)restart.findTaskRunByTaskIdAndValue("1_each", List.of()).getState().getCurrent()).isEqualTo((Object)State.Type.RUNNING);
        Assertions.assertThat((Comparable)restart.findTaskRunByTaskIdAndValue("2-1_seq", List.of("value 1")).getState().getCurrent()).isEqualTo((Object)State.Type.RUNNING);
        Assertions.assertThat((Comparable)restart.findTaskRunByTaskIdAndValue("2-1-2_t2", List.of("value 1")).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)restart.findTaskRunByTaskIdAndValue("2-1-2_t2", List.of("value 1")).getState().getHistories()).hasSize(5);
        Assertions.assertThat((Comparable)((TaskRunAttempt)restart.findTaskRunByTaskIdAndValue("2-1-2_t2", List.of("value 1")).getAttempts().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    @Test
    @LoadFlows(value={"flows/valids/pause-test.yaml"})
    void resumePausedToRunning() throws Exception {
        Execution execution = this.runnerUtils.runOneUntilPaused("main", "io.kestra.tests", "pause-test");
        Flow flow = this.flowRepository.findByExecution(execution);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.PAUSED);
        Execution resume = this.executionService.resume(execution, (FlowInterface)flow, State.Type.RUNNING, Pause.Resumed.now());
        Assertions.assertThat((Comparable)resume.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)resume.getState().getHistories()).hasSize(4);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.executionService.resume(resume, (FlowInterface)flow, State.Type.RUNNING, Pause.Resumed.now()));
    }

    @Test
    @LoadFlows(value={"flows/valids/pause-test.yaml"}, tenantId="tenant1")
    void resumePausedToKilling() throws Exception {
        Execution execution = this.runnerUtils.runOneUntilPaused(TENANT_1, "io.kestra.tests", "pause-test");
        Flow flow = this.flowRepository.findByExecution(execution);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.PAUSED);
        Execution resume = this.executionService.resume(execution, (FlowInterface)flow, State.Type.KILLING, null);
        Assertions.assertThat((Comparable)resume.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)resume.getState().getHistories()).hasSize(4);
    }

    @Test
    @ExecuteFlow(value="flows/valids/logs.yaml", tenantId="tenant2")
    void deleteExecution(Execution execution) throws IOException, TimeoutException {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Await.until(() -> this.logRepository.findByExecutionId(execution.getTenantId(), execution.getId(), Level.TRACE).size() == 5, (Duration)Duration.ofMillis(10L), (Duration)Duration.ofSeconds(5L));
        this.executionService.delete(execution, true, true, true);
        Assertions.assertThat((Optional)this.executionRepository.findById(execution.getTenantId(), execution.getId())).isEqualTo(Optional.empty());
        Assertions.assertThat((List)this.logRepository.findByExecutionId(execution.getTenantId(), execution.getId(), Level.INFO)).isEmpty();
    }

    @Test
    @ExecuteFlow(value="flows/valids/logs.yaml", tenantId="tenant3")
    void deleteExecutionKeepLogs(Execution execution) throws IOException, TimeoutException {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Await.until(() -> this.logRepository.findByExecutionId(execution.getTenantId(), execution.getId(), Level.TRACE).size() == 5, (Duration)Duration.ofMillis(10L), (Duration)Duration.ofSeconds(5L));
        this.executionService.delete(execution, false, false, false);
        Assertions.assertThat((Optional)this.executionRepository.findById(execution.getTenantId(), execution.getId())).isEqualTo(Optional.empty());
        Assertions.assertThat((List)this.logRepository.findByExecutionId(execution.getTenantId(), execution.getId(), Level.INFO)).hasSize(4);
    }

    @Test
    @LoadFlows(value={"flows/valids/pause_no_tasks.yaml"})
    void shouldKillPausedExecutions() throws Exception {
        Execution execution = this.runnerUtils.runOneUntilPaused("main", "io.kestra.tests", "pause_no_tasks");
        Flow flow = this.flowRepository.findByExecution(execution);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.PAUSED);
        Execution killed = this.executionService.kill(execution, (FlowInterface)flow);
        Assertions.assertThat((Comparable)killed.getState().getCurrent()).isEqualTo((Object)State.Type.KILLING);
        Assertions.assertThat((Comparable)((TaskRun)killed.findTaskRunsByTaskId("pause").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.KILLED);
        Assertions.assertThat((List)killed.getState().getHistories()).hasSize(5);
    }

    @Test
    @ExecuteFlow(value="flows/valids/failed-first.yaml")
    void shouldRestartAfterChangeTaskState(Execution execution) throws Exception {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)((TaskRun)execution.getTaskRunList().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Flow flow = this.flowRepository.findByExecution(execution);
        Execution markedAs = this.executionService.markAs(execution, (FlowInterface)flow, ((TaskRun)execution.getTaskRunList().getFirst()).getId(), State.Type.SUCCESS);
        Assertions.assertThat((Comparable)markedAs.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
    }

    @Test
    @LoadFlows(value={"flows/valids/pause_no_tasks.yaml"}, tenantId="tenant1")
    void killToState() throws Exception {
        Execution execution = this.runnerUtils.runOneUntilPaused(TENANT_1, "io.kestra.tests", "pause_no_tasks");
        Flow flow = this.flowRepository.findByExecution(execution);
        Execution killed = this.executionService.kill(execution, (FlowInterface)flow, Optional.of(State.Type.CANCELLED));
        Assertions.assertThat((Comparable)killed.getState().getCurrent()).isEqualTo((Object)State.Type.CANCELLED);
        Assertions.assertThat((Comparable)((TaskRun)killed.findTaskRunsByTaskId("pause").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.KILLED);
        Assertions.assertThat((Comparable)((TaskRunAttempt)((TaskRun)killed.findTaskRunsByTaskId("pause").getFirst()).getAttempts().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.KILLED);
        Assertions.assertThat((List)killed.getState().getHistories()).hasSize(5);
    }

    @Test
    @LoadFlows(value={"flows/valids/change-state-errors.yaml"})
    void changeStateWithErrorBranch() throws Exception {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "change-state-errors");
        Flow flow = this.flowRepository.findByExecution(execution);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Execution restart = this.executionService.changeTaskRunState(execution, flow, ((TaskRun)execution.findTaskRunsByTaskId("make_error").getFirst()).getId(), State.Type.SUCCESS);
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((Integer)restart.getMetadata().getAttemptNumber()).isEqualTo(2);
        Assertions.assertThat((List)restart.getState().getHistories()).hasSize(4);
        Assertions.assertThat((List)restart.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)((TaskRun)restart.findTaskRunsByTaskId("make_error").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }
}

