/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.FilesService;
import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.storages.StorageInterface;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Property;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@KestraTest(rebuildContext=true)
@Execution(value=ExecutionMode.SAME_THREAD)
class FilesServiceTest {
    @Inject
    private TestRunContextFactory runContextFactory;
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private StorageInterface storageInterface;

    FilesServiceTest() {
    }

    @Test
    void overrideExistingInputFile() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        FilesService.inputFiles((RunContext)runContext, Map.of("file.txt", "content"));
        FilesService.inputFiles((RunContext)runContext, Map.of("file.txt", "overridden content"));
        String fileContent = FileUtils.readFileToString((File)runContext.workingDir().path().resolve("file.txt").toFile(), (String)"UTF-8");
        Assertions.assertThat((String)fileContent).isEqualTo("overridden content");
    }

    @Test
    void renderInputFile() throws Exception {
        RunContext runContext = this.runContextFactory.of(Map.of("filename", "file.txt", "content", "Hello World"));
        Map content = FilesService.inputFiles((RunContext)runContext, Map.of("{{filename}}", "{{content}}"));
        Assertions.assertThat((String)((String)content.get("file.txt"))).isEqualTo("Hello World");
    }

    @Test
    void renderRawFile() throws Exception {
        RunContext runContext = this.runContextFactory.of(Map.of("filename", "file.txt", "content", "Hello World"));
        Map content = FilesService.inputFiles((RunContext)runContext, Map.of("{{filename}}", "{% raw %}{{content}}{% endraw %}"));
        Assertions.assertThat((String)((String)content.get("file.txt"))).isEqualTo("{{content}}");
    }

    @Test
    @Property(name="kestra.local-files.allowed-paths", value="/tmp")
    void localFileAsInputFile() throws Exception {
        URI uri = this.createFile();
        RunContext runContext = this.runContextFactory.of();
        ((DefaultRunContext)runContext).init(this.applicationContext);
        FilesService.inputFiles((RunContext)runContext, Map.of("file.txt", uri.toString()));
        Path file = runContext.workingDir().resolve(Path.of("file.txt", new String[0]));
        Assertions.assertThat((String)new String(Files.readAllBytes(file))).isEqualTo("Hello World");
    }

    @Test
    @Property(name="kestra.local-files.allowed-paths", value="/tmp")
    void nsFileAsInputFile() throws Exception {
        URI uri = this.createNsFile(false);
        RunContext runContext = this.runContextFactory.of();
        FilesService.inputFiles((RunContext)runContext, Map.of("file.txt", uri.toString()));
        Path file = runContext.workingDir().resolve(Path.of("file.txt", new String[0]));
        Assertions.assertThat((String)new String(Files.readAllBytes(file))).isEqualTo("Hello World");
    }

    @Test
    void outputFiles() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        Map files = FilesService.inputFiles((RunContext)runContext, Map.of("file.txt", "content"));
        Map outputs = FilesService.outputFiles((RunContext)runContext, files.keySet().stream().toList());
        Assertions.assertThat((int)outputs.size()).isEqualTo(1);
    }

    @Test
    void renderOutputFiles() throws Exception {
        RunContext runContext = this.runContextFactory.of(Map.of("extension", "txt"));
        Map files = FilesService.inputFiles((RunContext)runContext, Map.of("file.txt", "content"));
        Map outputs = FilesService.outputFiles((RunContext)runContext, List.of("*.{{extension}}"));
        Assertions.assertThat((int)outputs.size()).isEqualTo(1);
    }

    @Test
    void testOutputFilesWithSpecialCharacters(@TempDir Path tempDir) throws Exception {
        RunContext runContext = this.runContextFactory.of();
        Path fileWithSpace = tempDir.resolve("with space.txt");
        Path fileWithUnicode = tempDir.resolve("\u0e2a\u0e27\u0e31\u0e2a\u0e14\u0e35&.txt");
        Files.writeString(fileWithSpace, (CharSequence)"content", new OpenOption[0]);
        Files.writeString(fileWithUnicode, (CharSequence)"content", new OpenOption[0]);
        Path targetFileWithSpace = runContext.workingDir().path().resolve("with space.txt");
        Path targetFileWithUnicode = runContext.workingDir().path().resolve("\u0e2a\u0e27\u0e31\u0e2a\u0e14\u0e35&.txt");
        Files.copy(fileWithSpace, targetFileWithSpace, new CopyOption[0]);
        Files.copy(fileWithUnicode, targetFileWithUnicode, new CopyOption[0]);
        Map outputFiles = FilesService.outputFiles((RunContext)runContext, List.of("with space.txt", "\u0e2a\u0e27\u0e31\u0e2a\u0e14\u0e35&.txt"));
        Assertions.assertThat((Map)outputFiles).hasSize(2);
        Assertions.assertThat((Map)outputFiles).containsKey((Object)"with space.txt");
        Assertions.assertThat((Map)outputFiles).containsKey((Object)"\u0e2a\u0e27\u0e31\u0e2a\u0e14\u0e35&.txt");
        Assertions.assertThat((InputStream)runContext.storage().getFile((URI)outputFiles.get("with space.txt"))).isNotNull();
        Assertions.assertThat((InputStream)runContext.storage().getFile((URI)outputFiles.get("\u0e2a\u0e27\u0e31\u0e2a\u0e14\u0e35&.txt"))).isNotNull();
    }

    private URI createFile() throws IOException {
        File tempFile = File.createTempFile("file", ".txt");
        Files.write(tempFile.toPath(), "Hello World".getBytes(), new OpenOption[0]);
        return tempFile.toPath().toUri();
    }

    private URI createNsFile(boolean nsInAuthority) throws IOException {
        String namespace = "namespace";
        String filePath = "file.txt";
        this.storageInterface.createDirectory("main", namespace, URI.create(StorageContext.namespaceFilePrefix((String)namespace)));
        this.storageInterface.put("main", namespace, URI.create(StorageContext.namespaceFilePrefix((String)namespace) + "/" + filePath), (InputStream)new ByteArrayInputStream("Hello World".getBytes()));
        return URI.create("nsfile://" + (nsInAuthority ? namespace : "") + "/" + filePath);
    }
}

