/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.DependsOn;
import io.kestra.core.models.flows.Input;
import io.kestra.core.models.flows.Type;
import io.kestra.core.models.flows.input.FileInput;
import io.kestra.core.models.flows.input.InputAndValue;
import io.kestra.core.models.flows.input.IntInput;
import io.kestra.core.models.flows.input.MultiselectInput;
import io.kestra.core.models.flows.input.StringInput;
import io.kestra.core.models.property.Property;
import io.kestra.core.repositories.KvMetadataRepositoryInterface;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.secret.SecretNotFoundException;
import io.kestra.core.secret.SecretService;
import io.kestra.core.services.KVStoreService;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.storages.kv.InternalKVStore;
import io.kestra.core.storages.kv.KVStore;
import io.kestra.core.storages.kv.KVValue;
import io.kestra.core.utils.IdUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.multipart.CompletedFileUpload;
import io.micronaut.http.multipart.CompletedPart;
import io.micronaut.test.annotation.MockBean;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@KestraTest
class FlowInputOutputTest {
    private static final String TEST_SECRET_VALUE = "test-secret-value";
    private static final String TEST_KV_VALUE = "test-kv-value";
    static final Execution DEFAULT_TEST_EXECUTION = Execution.builder().id(IdUtils.create()).flowId(IdUtils.create()).flowRevision(Integer.valueOf(1)).namespace("io.kestra.test").build();
    @Inject
    FlowInputOutput flowInputOutput;
    @Inject
    StorageInterface storageInterface;
    @Inject
    KvMetadataRepositoryInterface kvMetadataRepository;

    FlowInputOutputTest() {
    }

    @MockBean(value=SecretService.class)
    SecretService testSecretService() {
        return new SecretService(this){

            public String findSecret(String tenantId, String namespace, String key) throws SecretNotFoundException {
                return FlowInputOutputTest.TEST_SECRET_VALUE;
            }
        };
    }

    @MockBean(value=KVStoreService.class)
    KVStoreService testKVStoreService() {
        return new KVStoreService(){

            public KVStore get(String tenant, String namespace, @Nullable String fromNamespace) {
                return new InternalKVStore(this, tenant, namespace, FlowInputOutputTest.this.storageInterface, FlowInputOutputTest.this.kvMetadataRepository){

                    public Optional<KVValue> getValue(String key) {
                        return Optional.of(new KVValue((Object)FlowInputOutputTest.TEST_KV_VALUE));
                    }
                };
            }
        };
    }

    @Test
    void shouldResolveEnabledInputsGivenInputWithConditionalExpressionMatchingTrue() {
        StringInput input1 = ((StringInput.StringInputBuilder)StringInput.builder().id("input1")).build();
        StringInput input2 = ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input2")).dependsOn(new DependsOn(List.of("input1"), "{{ inputs.input1 equals 'value1' }}"))).build();
        List<StringInput> inputs = List.of(input1, input2);
        Map<String, String> data = Map.of("input1", "value1", "input2", "value2");
        List values = this.flowInputOutput.resolveInputs(inputs, null, DEFAULT_TEST_EXECUTION, data);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(new InputAndValue((Input)input1, (Object)"value1", true, false, null), new InputAndValue((Input)input2, (Object)"value2", true, false, null)), (Object)values);
    }

    @Test
    void shouldResolveEnabledInputsGivenInputWithConditionalInputTrue() {
        StringInput input1 = ((StringInput.StringInputBuilder)StringInput.builder().id("input1")).build();
        StringInput input2 = ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input2")).dependsOn(new DependsOn(List.of("input1"), "{{ inputs.input1 equals 'v1' }}"))).build();
        StringInput input3 = ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input3")).dependsOn(new DependsOn(List.of("input2"), null))).build();
        List<StringInput> inputs = List.of(input1, input2, input3);
        Map<String, String> data = Map.of("input1", "v1", "input2", "v2", "input3", "v3");
        List values = this.flowInputOutput.resolveInputs(inputs, null, DEFAULT_TEST_EXECUTION, data);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(new InputAndValue((Input)input1, (Object)"v1", true, false, null), new InputAndValue((Input)input2, (Object)"v2", true, false, null), new InputAndValue((Input)input3, (Object)"v3", true, false, null)), (Object)values);
    }

    @Test
    void shouldResolveDisabledInputsGivenInputWithConditionalInputFalse() {
        StringInput input1 = ((StringInput.StringInputBuilder)StringInput.builder().id("input1")).build();
        StringInput input2 = ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input2")).dependsOn(new DependsOn(List.of("input1"), "{{ inputs.input1 equals '???' }}"))).build();
        StringInput input3 = ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input3")).dependsOn(new DependsOn(List.of("input2"), null))).build();
        List<StringInput> inputs = List.of(input1, input2, input3);
        Map<String, String> data = Map.of("input1", "v1", "input2", "v2", "input3", "v3");
        List values = this.flowInputOutput.resolveInputs(inputs, null, DEFAULT_TEST_EXECUTION, data);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(new InputAndValue((Input)input1, (Object)"v1", true, false, null), new InputAndValue((Input)input2, (Object)"v2", false, false, null), new InputAndValue((Input)input3, (Object)"v3", false, false, null)), (Object)values);
    }

    @Test
    void shouldResolveDisabledInputsGivenInputWithConditionalExpressionMatchingFalse() {
        StringInput input1 = ((StringInput.StringInputBuilder)StringInput.builder().id("input1")).build();
        StringInput input2 = ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input2")).dependsOn(new DependsOn(List.of("input1"), "{{ inputs.input1 equals 'dummy' }}"))).build();
        List<StringInput> inputs = List.of(input1, input2);
        Map<String, String> data = Map.of("input1", "value1", "input2", "value2");
        List values = this.flowInputOutput.resolveInputs(inputs, null, DEFAULT_TEST_EXECUTION, data);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(new InputAndValue((Input)input1, (Object)"value1", true, false, null), new InputAndValue((Input)input2, (Object)"value2", false, false, null)), (Object)values);
    }

    @Test
    void shouldResolveDisabledInputsGivenInputWithErroneousConditionalExpression() {
        StringInput input1 = ((StringInput.StringInputBuilder)StringInput.builder().id("input1")).build();
        StringInput input2 = ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input2")).dependsOn(new DependsOn(List.of("input1"), "{{ inputs.dummy equals 'dummy' }}"))).build();
        List<StringInput> inputs = List.of(input1, input2);
        Map<String, String> data = Map.of("input1", "value1", "input2", "value2");
        List values = this.flowInputOutput.resolveInputs(inputs, null, DEFAULT_TEST_EXECUTION, data);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)values.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((InputAndValue)values.get(1)).enabled());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)((InputAndValue)values.get(1)).exception());
    }

    @Test
    void shouldNotUploadFileInputAfterValidation() {
        FileInput input = ((FileInput.FileInputBuilder)((FileInput.FileInputBuilder)FileInput.builder().id("input")).type(Type.FILE)).build();
        Mono data = Mono.just((Object)new MemoryCompletedFileUpload("input", "input", "???".getBytes(StandardCharsets.UTF_8)));
        List values = (List)this.flowInputOutput.validateExecutionInputs(List.of(input), null, DEFAULT_TEST_EXECUTION, (Publisher)data).block();
        org.junit.jupiter.api.Assertions.assertNull((Object)((InputAndValue)values.getFirst()).exception());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.storageInterface.exists("main", null, URI.create(((InputAndValue)values.getFirst()).value().toString())));
    }

    @Test
    void resolveInputsWithStrictDefaultTyping() {
        StringInput input1 = ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input1")).type(Type.STRING)).validator("\\d").defaults(Property.ofValue((Object)"0"))).required(Boolean.valueOf(false))).build();
        IntInput input2 = ((IntInput.IntInputBuilder)((IntInput.IntInputBuilder)((IntInput.IntInputBuilder)((IntInput.IntInputBuilder)IntInput.builder().type(Type.INT)).id("input2")).defaults(Property.ofValue((Object)0))).required(Boolean.valueOf(false))).build();
        List<IntInput> inputs = List.of(input1, input2);
        Map<String, String> data = Map.of("input42", "foo");
        List values = this.flowInputOutput.resolveInputs(inputs, null, DEFAULT_TEST_EXECUTION, data);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(new InputAndValue((Input)input1, (Object)"0", true, true, null), new InputAndValue((Input)input2, (Object)0, true, true, null)), (Object)values);
    }

    @Test
    void resolveInputsGivenDefaultExpressions() {
        StringInput input1 = ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input1")).type(Type.STRING)).defaults(Property.ofExpression((String)"{{ 'hello' }}"))).required(Boolean.valueOf(false))).build();
        StringInput input2 = ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input2")).type(Type.STRING)).defaults(Property.ofExpression((String)"{{ inputs.input1 }}_world"))).required(Boolean.valueOf(false))).dependsOn(new DependsOn(List.of("input1"), null))).build();
        List<StringInput> inputs = List.of(input1, input2);
        Map<String, String> data = Map.of("input42", "foo");
        List values = this.flowInputOutput.resolveInputs(inputs, null, DEFAULT_TEST_EXECUTION, data);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(new InputAndValue((Input)input1, (Object)"hello", true, true, null), new InputAndValue((Input)input2, (Object)"hello_world", true, true, null)), (Object)values);
    }

    @Test
    void shouldObfuscateSecretsWhenValidatingInputs() {
        StringInput input = ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input")).type(Type.STRING)).defaults(Property.ofExpression((String)"{{ secret('???') }}"))).required(Boolean.valueOf(false))).build();
        List results = (List)this.flowInputOutput.validateExecutionInputs(List.of(input), null, DEFAULT_TEST_EXECUTION, (Publisher)Mono.empty()).block();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"******", (Object)((InputAndValue)results.getFirst()).value());
    }

    @Test
    void shouldNotObfuscateSecretsInSelectWhenValidatingInputs() {
        MultiselectInput input = ((MultiselectInput.MultiselectInputBuilder)((MultiselectInput.MultiselectInputBuilder)((MultiselectInput.MultiselectInputBuilder)MultiselectInput.builder().id("input")).type(Type.MULTISELECT)).expression("{{ [secret('???')] }}").required(Boolean.valueOf(false))).build();
        List results = (List)this.flowInputOutput.validateExecutionInputs(List.of(input), null, DEFAULT_TEST_EXECUTION, (Publisher)Mono.empty()).block();
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_SECRET_VALUE, ((MultiselectInput)((InputAndValue)results.getFirst()).input()).getValues().getFirst());
    }

    @Test
    void shouldNotObfuscateSecretsWhenReadingInputs() {
        StringInput input = ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input")).type(Type.STRING)).defaults(Property.ofExpression((String)"{{ secret('???') }}"))).required(Boolean.valueOf(false))).build();
        Map results = (Map)this.flowInputOutput.readExecutionInputs(List.of(input), null, DEFAULT_TEST_EXECUTION, (Publisher)Mono.empty()).block();
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_SECRET_VALUE, results.get("input"));
    }

    @Test
    void shouldEvaluateExpressionOnDefaultsUsingKVFunction() {
        StringInput input = ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input")).type(Type.STRING)).defaults(Property.ofExpression((String)"{{ kv('???') }}"))).required(Boolean.valueOf(false))).build();
        Map results = (Map)this.flowInputOutput.readExecutionInputs(List.of(input), null, DEFAULT_TEST_EXECUTION, (Publisher)Mono.empty()).block();
        Assertions.assertThat(results.get("input")).isEqualTo((Object)TEST_KV_VALUE);
    }

    @Test
    void shouldGetDefaultWhenPassingNoDataForRequiredInput() {
        StringInput input = ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input")).type(Type.STRING)).defaults(Property.ofValue((Object)"default"))).build();
        Map results = (Map)this.flowInputOutput.readExecutionInputs(List.of(input), null, DEFAULT_TEST_EXECUTION, (Publisher)Mono.empty()).block();
        Assertions.assertThat(results.get("input")).isEqualTo((Object)"default");
    }

    private static final class MemoryCompletedFileUpload
    extends MemoryCompletedPart
    implements CompletedFileUpload {
        private final String fileName;

        public MemoryCompletedFileUpload(String name, String fileName, byte[] content) {
            super(name, content);
            this.fileName = fileName;
        }

        public String getFilename() {
            return this.fileName;
        }

        public long getSize() {
            return this.content.length;
        }

        public long getDefinedSize() {
            return this.content.length;
        }

        public boolean isComplete() {
            return true;
        }

        public void discard() {
        }
    }

    private static class MemoryCompletedPart
    implements CompletedPart {
        protected final String name;
        protected final byte[] content;

        public MemoryCompletedPart(String name, byte[] content) {
            this.name = name;
            this.content = content;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.content);
        }

        public byte[] getBytes() {
            return this.content;
        }

        public ByteBuffer getByteBuffer() {
            return ByteBuffer.wrap(this.content);
        }

        public Optional<MediaType> getContentType() {
            return Optional.empty();
        }

        public String getName() {
            return this.name;
        }
    }
}

