/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;

@Singleton
public class FlowTriggerCaseTest {
    public static final String NAMESPACE = "io.kestra.tests.trigger";
    @Inject
    protected TestRunnerUtils runnerUtils;

    public void trigger(String tenantId) throws InterruptedException, TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne(tenantId, NAMESPACE, "trigger-flow");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution flowListenerNoInput = this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS), tenantId, NAMESPACE, "trigger-flow-listener-no-inputs");
        Execution flowListener = this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS), tenantId, NAMESPACE, "trigger-flow-listener");
        Execution flowListenerNamespace = this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS), tenantId, NAMESPACE, "trigger-flow-listener-namespace-condition");
        Assertions.assertThat((int)flowListener.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)flowListener.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Object)((TaskRun)flowListener.getTaskRunList().getFirst()).getOutputs().get((Object)"value")).isEqualTo((Object)("childs: from parents: " + execution.getId()));
        Assertions.assertThat(flowListener.getTrigger().getVariables().get("executionId")).isEqualTo((Object)execution.getId());
        Assertions.assertThat(flowListener.getTrigger().getVariables().get("namespace")).isEqualTo((Object)NAMESPACE);
        Assertions.assertThat(flowListener.getTrigger().getVariables().get("flowId")).isEqualTo((Object)"trigger-flow");
        Assertions.assertThat((int)flowListenerNoInput.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat(flowListenerNoInput.getTrigger().getVariables().get("executionId")).isEqualTo((Object)execution.getId());
        Assertions.assertThat(flowListenerNoInput.getTrigger().getVariables().get("namespace")).isEqualTo((Object)NAMESPACE);
        Assertions.assertThat(flowListenerNoInput.getTrigger().getVariables().get("flowId")).isEqualTo((Object)"trigger-flow");
        Assertions.assertThat((Comparable)flowListenerNoInput.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((int)flowListenerNamespace.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat(flowListenerNamespace.getTrigger().getVariables().get("namespace")).isEqualTo((Object)NAMESPACE);
        Assertions.assertThat(flowListenerNamespace.getTrigger().getVariables().get("flowId")).satisfiesAnyOf(new ThrowingConsumer[]{arg -> Assertions.assertThat((Object)arg).isEqualTo((Object)"trigger-flow"), arg -> Assertions.assertThat((Object)arg).isEqualTo((Object)"trigger-flow-listener-no-inputs"), arg -> Assertions.assertThat((Object)arg).isEqualTo((Object)"trigger-flow-listener")});
    }

    public void triggerWithPause() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests.trigger.pause", "trigger-flow-with-pause");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(3);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        List triggeredExec = this.runnerUtils.awaitFlowExecutionNumber(4, "main", "io.kestra.tests.trigger.pause", "trigger-flow-listener-with-pause");
        Assertions.assertThat((int)triggeredExec.size()).isEqualTo(4);
        List<Execution> sortedExecs = triggeredExec.stream().sorted(Comparator.comparing(e -> e.getState().getEndDate().orElse(Instant.now()))).toList();
        Assertions.assertThat(sortedExecs.get(0).getOutputs().get("status")).isEqualTo((Object)"RUNNING");
        Assertions.assertThat(sortedExecs.get(1).getOutputs().get("status")).isEqualTo((Object)"PAUSED");
        Assertions.assertThat(sortedExecs.get(2).getOutputs().get("status")).isEqualTo((Object)"RUNNING");
        Assertions.assertThat(sortedExecs.get(3).getOutputs().get("status")).isEqualTo((Object)"SUCCESS");
    }

    public void triggerWithConcurrencyLimit(String tenantId) throws QueueException, TimeoutException {
        Execution execution1 = this.runnerUtils.runOneUntilRunning(tenantId, "io.kestra.tests.trigger.concurrency", "trigger-flow-with-concurrency-limit");
        Execution execution2 = this.runnerUtils.runOne(tenantId, "io.kestra.tests.trigger.concurrency", "trigger-flow-with-concurrency-limit");
        List triggeredExec = this.runnerUtils.awaitFlowExecutionNumber(5, tenantId, "io.kestra.tests.trigger.concurrency", "trigger-flow-listener-with-concurrency-limit");
        Assertions.assertThat((int)triggeredExec.size()).isEqualTo(5);
        Assertions.assertThat((boolean)triggeredExec.stream().anyMatch(e -> e.getOutputs().get("status").equals("RUNNING") && e.getOutputs().get("executionId").equals(execution1.getId()))).isTrue();
        Assertions.assertThat((boolean)triggeredExec.stream().anyMatch(e -> e.getOutputs().get("status").equals("SUCCESS") && e.getOutputs().get("executionId").equals(execution1.getId()))).isTrue();
        Assertions.assertThat((boolean)triggeredExec.stream().anyMatch(e -> e.getOutputs().get("status").equals("QUEUED") && e.getOutputs().get("executionId").equals(execution2.getId()))).isTrue();
        Assertions.assertThat((boolean)triggeredExec.stream().anyMatch(e -> e.getOutputs().get("status").equals("RUNNING") && e.getOutputs().get("executionId").equals(execution2.getId()))).isTrue();
        Assertions.assertThat((boolean)triggeredExec.stream().anyMatch(e -> e.getOutputs().get("status").equals("SUCCESS") && e.getOutputs().get("executionId").equals(execution2.getId()))).isTrue();
    }
}

