/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.TestsUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.validation.ConstraintViolationException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;

@KestraTest(startRunner=true)
public class InputsTest {
    @Inject
    @Named(value="workerTaskLogQueue")
    private QueueInterface<LogEntry> logQueue;
    @Inject
    private TestRunnerUtils runnerUtils;
    public static Map<String, Object> inputs = ImmutableMap.builder().put((Object)"string", (Object)"myString").put((Object)"enum", (Object)"ENUM_VALUE").put((Object)"int", (Object)"42").put((Object)"float", (Object)"42.42").put((Object)"bool", (Object)"false").put((Object)"instant", (Object)"2019-10-06T18:27:49Z").put((Object)"date", (Object)"2019-10-06").put((Object)"time", (Object)"18:27:49").put((Object)"duration", (Object)"PT5M6S").put((Object)"file", (Object)Objects.requireNonNull(InputsTest.class.getClassLoader().getResource("application-test.yml")).getPath()).put((Object)"json", (Object)"{\"a\": \"b\"}").put((Object)"uri", (Object)"https://www.google.com").put((Object)"nested.string", (Object)"a string").put((Object)"nested.more.int", (Object)"123").put((Object)"nested.bool", (Object)"true").put((Object)"validatedString", (Object)"A123").put((Object)"validatedInt", (Object)"12").put((Object)"validatedDate", (Object)"2023-01-02").put((Object)"validatedDateTime", (Object)"2023-01-01T00:00:10Z").put((Object)"validatedDuration", (Object)"PT15S").put((Object)"validatedFloat", (Object)"0.42").put((Object)"validatedTime", (Object)"11:27:49").put((Object)"secret", (Object)"secret").put((Object)"array", (Object)"[1, 2, 3]").put((Object)"yaml", (Object)"some: property\nalist:\n- of\n- values").build();
    @Inject
    private FlowRepositoryInterface flowRepository;
    @Inject
    private StorageInterface storageInterface;
    @Inject
    private FlowInputOutput flowIO;
    @Inject
    private FlowInputOutput flowInputOutput;

    private Map<String, Object> typedInputs(Map<String, Object> map, String tenantId) {
        return this.typedInputs(map, (Flow)this.flowRepository.findById(tenantId, "io.kestra.tests", "inputs").get());
    }

    private Map<String, Object> typedInputs(Map<String, Object> map, Flow flow) {
        return this.flowIO.readExecutionInputs((FlowInterface)flow, Execution.builder().id("test").namespace(flow.getNamespace()).tenantId(flow.getTenantId()).flowRevision(Integer.valueOf(1)).flowId(flow.getId()).build(), map);
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"})
    void missingRequired() {
        HashMap<String, Object> inputs = new HashMap<String, Object>(InputsTest.inputs);
        inputs.put("string", null);
        ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)inputs, "main"));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid input for `string`, missing required input, but received `null`"});
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant")
    void nonRequiredNoDefaultNoValueIsNull() {
        HashMap<String, Object> inputsWithMissingOptionalInput = new HashMap<String, Object>(inputs);
        inputsWithMissingOptionalInput.remove("bool");
        Assertions.assertThat((boolean)this.typedInputs(inputsWithMissingOptionalInput, "tenant").containsKey("bool")).isTrue();
        Assertions.assertThat((Object)this.typedInputs(inputsWithMissingOptionalInput, "tenant").get("bool")).isNull();
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant1")
    void allValidInputs() throws URISyntaxException, IOException {
        Map<String, Object> typeds = this.typedInputs(inputs, "tenant1");
        Assertions.assertThat((Object)typeds.get("string")).isEqualTo((Object)"myString");
        Assertions.assertThat((Object)typeds.get("int")).isEqualTo((Object)42);
        Assertions.assertThat((Object)typeds.get("float")).isEqualTo((Object)Float.valueOf(42.42f));
        Assertions.assertThat((Boolean)((Boolean)typeds.get("bool"))).isFalse();
        Assertions.assertThat((Object)typeds.get("instant")).isEqualTo((Object)Instant.parse("2019-10-06T18:27:49Z"));
        Assertions.assertThat((Object)typeds.get("instantDefaults")).isEqualTo((Object)Instant.parse("2013-08-09T14:19:00Z"));
        Assertions.assertThat((Object)typeds.get("date")).isEqualTo((Object)LocalDate.parse("2019-10-06"));
        Assertions.assertThat((Object)typeds.get("time")).isEqualTo((Object)LocalTime.parse("18:27:49"));
        Assertions.assertThat((Object)typeds.get("duration")).isEqualTo((Object)Duration.parse("PT5M6S"));
        Assertions.assertThat((URI)((URI)typeds.get("file"))).isEqualTo((Object)new URI("kestra:///io/kestra/tests/inputs/executions/test/inputs/file/application-test.yml"));
        Assertions.assertThat((String)CharStreams.toString((Readable)new InputStreamReader(this.storageInterface.get("tenant1", null, (URI)typeds.get("file"))))).isEqualTo(CharStreams.toString((Readable)new InputStreamReader(new FileInputStream((String)inputs.get("file")))));
        Assertions.assertThat((Object)typeds.get("json")).isEqualTo(Map.of("a", "b"));
        Assertions.assertThat((Object)typeds.get("uri")).isEqualTo((Object)"https://www.google.com");
        Assertions.assertThat(((Map)typeds.get("nested")).get("string")).isEqualTo((Object)"a string");
        Assertions.assertThat((Boolean)((Boolean)((Map)typeds.get("nested")).get("bool"))).isTrue();
        Assertions.assertThat(((Map)((Map)typeds.get("nested")).get("more")).get("int")).isEqualTo((Object)123);
        Assertions.assertThat((Object)typeds.get("validatedString")).isEqualTo((Object)"A123");
        Assertions.assertThat((Object)typeds.get("validatedInt")).isEqualTo((Object)12);
        Assertions.assertThat((Object)typeds.get("validatedDate")).isEqualTo((Object)LocalDate.parse("2023-01-02"));
        Assertions.assertThat((Object)typeds.get("validatedDateTime")).isEqualTo((Object)Instant.parse("2023-01-01T00:00:10Z"));
        Assertions.assertThat((Object)typeds.get("validatedDuration")).isEqualTo((Object)Duration.parse("PT15S"));
        Assertions.assertThat((Object)typeds.get("validatedFloat")).isEqualTo((Object)Float.valueOf(0.42f));
        Assertions.assertThat((Object)typeds.get("validatedTime")).isEqualTo((Object)LocalTime.parse("11:27:49"));
        Assertions.assertThat((Object)typeds.get("secret")).isNotEqualTo((Object)"secret");
        Assertions.assertThat((Object)typeds.get("array")).isInstanceOf(List.class);
        Assertions.assertThat((List)((List)typeds.get("array"))).hasSize(3);
        Assertions.assertThat((List)((List)typeds.get("array"))).isEqualTo(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
        Assertions.assertThat((Object)typeds.get("yaml")).isEqualTo(Map.of("some", "property", "alist", List.of("of", "values")));
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant2")
    void allValidTypedInputs() {
        Map<String, Object> typeds = this.typedInputs(inputs, "tenant2");
        typeds.put("int", 42);
        typeds.put("float", Float.valueOf(42.42f));
        typeds.put("bool", false);
        Assertions.assertThat((Object)typeds.get("string")).isEqualTo((Object)"myString");
        Assertions.assertThat((Object)typeds.get("enum")).isEqualTo((Object)"ENUM_VALUE");
        Assertions.assertThat((Object)typeds.get("int")).isEqualTo((Object)42);
        Assertions.assertThat((Object)typeds.get("float")).isEqualTo((Object)Float.valueOf(42.42f));
        Assertions.assertThat((Boolean)((Boolean)typeds.get("bool"))).isFalse();
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant3")
    void inputFlow() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("tenant3", "io.kestra.tests", "inputs", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, inputs));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(14);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((String)((String)((TaskRun)execution.findTaskRunsByTaskId("file").getFirst()).getOutputs().get((Object)"value"))).matches((CharSequence)"kestra:///io/kestra/tests/inputs/executions/.*/inputs/file/application-test.yml");
        Assertions.assertThat((String)((String)((TaskRun)execution.findTaskRunsByTaskId("secret").getFirst()).getOutputs().get((Object)"value"))).isEqualTo("secret");
        Assertions.assertThat((String)((String)((TaskRun)execution.findTaskRunsByTaskId("optional").getFirst()).getOutputs().get((Object)"value"))).isEmpty();
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant4")
    void inputValidatedStringBadValue() {
        HashMap<String, Object> map = new HashMap<String, Object>(inputs);
        map.put("validatedString", "foo");
        ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)map, "tenant4"));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid input for `validatedString`, it must match the pattern"});
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant5")
    void inputValidatedIntegerBadValue() {
        HashMap<String, Object> mapMin = new HashMap<String, Object>(inputs);
        mapMin.put("validatedInt", "9");
        ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)mapMin, "tenant5"));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid input for `validatedInt`, it must be more than `10`, but received `9`"});
        HashMap<String, Object> mapMax = new HashMap<String, Object>(inputs);
        mapMax.put("validatedInt", "21");
        e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)mapMax, "tenant5"));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid input for `validatedInt`, it must be less than `20`, but received `21`"});
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant6")
    void inputValidatedDateBadValue() {
        HashMap<String, Object> mapMin = new HashMap<String, Object>(inputs);
        mapMin.put("validatedDate", "2022-01-01");
        ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)mapMin, "tenant6"));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid input for `validatedDate`, it must be after `2023-01-01`, but received `2022-01-01`"});
        HashMap<String, Object> mapMax = new HashMap<String, Object>(inputs);
        mapMax.put("validatedDate", "2024-01-01");
        e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)mapMax, "tenant6"));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid input for `validatedDate`, it must be before `2023-12-31`, but received `2024-01-01`"});
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant7")
    void inputValidatedDateTimeBadValue() {
        HashMap<String, Object> mapMin = new HashMap<String, Object>(inputs);
        mapMin.put("validatedDateTime", "2022-01-01T00:00:00Z");
        ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)mapMin, "tenant7"));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid input for `validatedDateTime`, it must be after `2023-01-01T00:00:00Z`, but received `2022-01-01T00:00:00Z`"});
        HashMap<String, Object> mapMax = new HashMap<String, Object>(inputs);
        mapMax.put("validatedDateTime", "2024-01-01T00:00:00Z");
        e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)mapMax, "tenant7"));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid input for `validatedDateTime`, it must be before `2023-12-31T23:59:59Z`"});
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant8")
    void inputValidatedDurationBadValue() {
        HashMap<String, Object> mapMin = new HashMap<String, Object>(inputs);
        mapMin.put("validatedDuration", "PT1S");
        ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)mapMin, "tenant8"));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid input for `validatedDuration`, It must be more than `PT10S`, but received `PT1S`"});
        HashMap<String, Object> mapMax = new HashMap<String, Object>(inputs);
        mapMax.put("validatedDuration", "PT30S");
        e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)mapMax, "tenant8"));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid input for `validatedDuration`, It must be less than `PT20S`, but received `PT30S`"});
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant9")
    void inputValidatedFloatBadValue() {
        HashMap<String, Object> mapMin = new HashMap<String, Object>(inputs);
        mapMin.put("validatedFloat", "0.01");
        ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)mapMin, "tenant9"));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid input for `validatedFloat`, it must be more than `0.1`, but received `0.01`"});
        HashMap<String, Object> mapMax = new HashMap<String, Object>(inputs);
        mapMax.put("validatedFloat", "1.01");
        e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)mapMax, "tenant9"));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid input for `validatedFloat`, it must be less than `0.5`, but received `1.01`"});
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant10")
    void inputValidatedTimeBadValue() {
        HashMap<String, Object> mapMin = new HashMap<String, Object>(inputs);
        mapMin.put("validatedTime", "00:00:01");
        ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)mapMin, "tenant10"));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid input for `validatedTime`, it must be after `01:00`, but received `00:00:01`"});
        HashMap<String, Object> mapMax = new HashMap<String, Object>(inputs);
        mapMax.put("validatedTime", "14:00:00");
        e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)mapMax, "tenant10"));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid input for `validatedTime`, it must be before `11:59:59`, but received `14:00:00`"});
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant11")
    void inputFailed() {
        HashMap<String, Object> map = new HashMap<String, Object>(inputs);
        map.put("uri", "http:/bla");
        ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)map, "tenant11"));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid input for `uri`, Expected `URI` but received `http:/bla`, but received `http:/bla`"});
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant12")
    void inputEnumFailed() {
        HashMap<String, Object> map = new HashMap<String, Object>(inputs);
        map.put("enum", "INVALID");
        ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)map, "tenant12"));
        Assertions.assertThat((String)e.getMessage()).isEqualTo("enum: Invalid input for `enum`, it must match the values `[ENUM_VALUE, OTHER_ONE]`, but received `INVALID`");
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant13")
    void inputArrayFailed() {
        HashMap<String, Object> map = new HashMap<String, Object>(inputs);
        map.put("array", "[\"s1\", \"s2\"]");
        ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.typedInputs((Map<String, Object>)map, "tenant13"));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid input for `array`, Unable to parse array element as `INT` on `s1`, but received `[\"s1\", \"s2\"]`"});
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant14")
    void inputEmptyJson() {
        HashMap<String, Object> map = new HashMap<String, Object>(inputs);
        map.put("json", "{}");
        Map<String, Object> typeds = this.typedInputs(map, "tenant14");
        Assertions.assertThat((Object)typeds.get("json")).isInstanceOf(Map.class);
        Assertions.assertThat((int)((Map)typeds.get("json")).size()).isZero();
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant15")
    void inputEmptyJsonFlow() throws TimeoutException, QueueException {
        HashMap<String, Object> map = new HashMap<String, Object>(inputs);
        map.put("json", "{}");
        Execution execution = this.runnerUtils.runOne("tenant15", "io.kestra.tests", "inputs", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, (Map)map));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(14);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat(execution.getInputs().get("json")).isInstanceOf(Map.class);
        Assertions.assertThat((int)((Map)execution.getInputs().get("json")).size()).isZero();
        Assertions.assertThat((String)((String)((TaskRun)execution.findTaskRunsByTaskId("jsonOutput").getFirst()).getOutputs().get((Object)"value"))).isEqualTo("{}");
    }

    @Test
    @LoadFlows(value={"flows/valids/input-log-secret.yaml"}, tenantId="tenant16")
    void shouldNotLogSecretInput() throws TimeoutException, QueueException, InterruptedException {
        AtomicReference logEntry = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Flux receive = TestsUtils.receive(this.logQueue, l -> {
            LogEntry left = (LogEntry)l.getLeft();
            if (left.getTenantId().equals("tenant16")) {
                logEntry.set(left);
                countDownLatch.countDown();
            }
        });
        Execution execution = this.runnerUtils.runOne("tenant16", "io.kestra.tests", "input-log-secret", null, (flow, exec) -> this.flowInputOutput.readExecutionInputs(flow, exec, Map.of("nested.key", "pass")));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        receive.blockLast();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)countDownLatch.await(10L, TimeUnit.SECONDS));
        Assertions.assertThat((Object)((LogEntry)logEntry.get())).isNotNull();
        Assertions.assertThat((String)((LogEntry)logEntry.get()).getMessage()).isEqualTo("These are my secrets: ****** - ******");
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant17")
    void fileInputWithFileDefault() throws IOException, QueueException, TimeoutException {
        HashMap<String, Object> newInputs = new HashMap<String, Object>(inputs);
        URI file = this.createFile();
        newInputs.put("file", file);
        Execution execution = this.runnerUtils.runOne("tenant17", "io.kestra.tests", "inputs", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, (Map)newInputs));
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((String)((String)((TaskRun)execution.findTaskRunsByTaskId("file").getFirst()).getOutputs().get((Object)"value"))).isEqualTo(file.toString());
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"}, tenantId="tenant18")
    void fileInputWithNsfile() throws IOException, QueueException, TimeoutException {
        HashMap<String, Object> inputs = new HashMap<String, Object>(InputsTest.inputs);
        URI file = this.createNsFile(false, "tenant18");
        inputs.put("file", file);
        Execution execution = this.runnerUtils.runOne("tenant18", "io.kestra.tests", "inputs", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, (Map)inputs));
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((String)((String)((TaskRun)execution.findTaskRunsByTaskId("file").getFirst()).getOutputs().get((Object)"value"))).isEqualTo(file.toString());
    }

    private URI createFile() throws IOException {
        File tempFile = File.createTempFile("file", ".txt");
        Files.write(tempFile.toPath(), "Hello World".getBytes(), new OpenOption[0]);
        return tempFile.toPath().toUri();
    }

    private URI createNsFile(boolean nsInAuthority, String tenantId) throws IOException {
        String namespace = "io.kestra.tests";
        String filePath = "file.txt";
        this.storageInterface.createDirectory(tenantId, namespace, URI.create(StorageContext.namespaceFilePrefix((String)namespace)));
        this.storageInterface.put(tenantId, namespace, URI.create(StorageContext.namespaceFilePrefix((String)namespace) + "/" + filePath), (InputStream)new ByteArrayInputStream("Hello World".getBytes()));
        return URI.create("nsfile://" + (nsInAuthority ? namespace : "") + "/" + filePath);
    }
}

