/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.repositories.LocalFlowRepositoryLoader;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
@KestraTest(startRunner=true)
class ListenersTest {
    @Inject
    private TestRunnerUtils runnerUtils;
    @Inject
    private LocalFlowRepositoryLoader repositoryLoader;

    ListenersTest() {
    }

    @BeforeEach
    void initListeners() throws IOException, URISyntaxException {
        this.repositoryLoader.load(Objects.requireNonNull(ListenersTest.class.getClassLoader().getResource("flows/tests/listeners.yaml")));
        this.repositoryLoader.load(Objects.requireNonNull(ListenersTest.class.getClassLoader().getResource("flows/tests/listeners-flowable.yaml")));
        this.repositoryLoader.load(Objects.requireNonNull(ListenersTest.class.getClassLoader().getResource("flows/tests/listeners-multiple.yaml")));
        this.repositoryLoader.load(Objects.requireNonNull(ListenersTest.class.getClassLoader().getResource("flows/tests/listeners-multiple-failed.yaml")));
        this.repositoryLoader.load(Objects.requireNonNull(ListenersTest.class.getClassLoader().getResource("flows/tests/listeners-failed.yaml")));
    }

    @Test
    void success() throws TimeoutException, QueueException {
        io.kestra.core.models.executions.Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "listeners", null, (f, e) -> ImmutableMap.of((Object)"string", (Object)"OK"));
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(1)).getTaskId()).isEqualTo("ok");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(3);
        Assertions.assertThat((String)((String)((TaskRun)execution.getTaskRunList().get(2)).getOutputs().get((Object)"value"))).contains(new CharSequence[]{"flowId=listeners"});
    }

    @Test
    void failed() throws TimeoutException, QueueException {
        io.kestra.core.models.executions.Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "listeners", null, (f, e) -> ImmutableMap.of((Object)"string", (Object)"KO"));
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(1)).getTaskId()).isEqualTo("ko");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(3);
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(2)).getTaskId()).isEqualTo("execution-failed-listener");
    }

    @Test
    void flowableExecution() throws TimeoutException, QueueException {
        io.kestra.core.models.executions.Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "listeners-flowable", null, (f, e) -> ImmutableMap.of((Object)"string", (Object)"execution"));
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(3);
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(1)).getTaskId()).isEqualTo("parent-seq");
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(2)).getTaskId()).isEqualTo("execution-success-listener");
        Assertions.assertThat((String)((String)((TaskRun)execution.getTaskRunList().get(2)).getOutputs().get((Object)"value"))).contains(new CharSequence[]{execution.getId()});
    }

    @Test
    void multipleListeners() throws TimeoutException, QueueException {
        io.kestra.core.models.executions.Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "listeners-multiple");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(3);
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(1)).getTaskId()).isEqualTo("l1");
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(2)).getTaskId()).isEqualTo("l2");
    }

    @Test
    void failedListeners() throws TimeoutException, QueueException {
        io.kestra.core.models.executions.Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "listeners-failed");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(2);
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(1)).getTaskId()).isEqualTo("ko");
        Assertions.assertThat((Comparable)((TaskRun)execution.getTaskRunList().get(1)).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    @Test
    void failedMultipleListeners() throws TimeoutException, QueueException {
        io.kestra.core.models.executions.Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "listeners-multiple-failed");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(3);
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(1)).getTaskId()).isEqualTo("ko");
        Assertions.assertThat((Comparable)((TaskRun)execution.getTaskRunList().get(1)).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(2)).getTaskId()).isEqualTo("l2");
        Assertions.assertThat((Comparable)((TaskRun)execution.getTaskRunList().get(2)).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }
}

