/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.tasks.FileExistComportment;
import io.kestra.core.runners.LocalWorkingDir;
import io.kestra.core.runners.TestWorkingDir;
import io.kestra.core.runners.WorkingDir;
import io.kestra.core.utils.IdUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class LocalWorkingDirTest {
    LocalWorkingDirTest() {
    }

    @Test
    void shouldReturnWorkingDirPathGivenWorkingDirId() {
        String workingDirId = IdUtils.create();
        LocalWorkingDir workingDirectory = new LocalWorkingDir(Path.of("/tmp", new String[0]), workingDirId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)workingDirectory.path().endsWith(workingDirId));
    }

    @Test
    void shouldReturnTheSameWorkingDirPath() {
        LocalWorkingDir workingDirectory = new LocalWorkingDir(Path.of("/tmp", new String[0]), IdUtils.create());
        Assertions.assertThat((Path)workingDirectory.path()).isEqualTo((Object)workingDirectory.path());
    }

    @Test
    void shouldResolvePathFromWorkingDir() {
        LocalWorkingDir workingDirectory = new LocalWorkingDir(Path.of("/tmp", new String[0]), IdUtils.create());
        Path path = workingDirectory.resolve(Path.of("file.txt", new String[0]));
        Assertions.assertThat((String)path.toString()).isEqualTo(String.valueOf(workingDirectory.path()) + "/file.txt");
        path = workingDirectory.resolve(Path.of("subdir/file.txt", new String[0]));
        Assertions.assertThat((String)path.toString()).isEqualTo(String.valueOf(workingDirectory.path()) + "/subdir/file.txt");
        Assertions.assertThat((Path)workingDirectory.resolve(null)).isEqualTo((Object)workingDirectory.path());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> workingDirectory.resolve(Path.of("/etc/passwd", new String[0])));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> workingDirectory.resolve(Path.of("../../etc/passwd", new String[0])));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> workingDirectory.resolve(Path.of("subdir/../../../etc/passwd", new String[0])));
    }

    @Test
    void shouldCreatedTempFile() throws IOException {
        String workingDirId = IdUtils.create();
        TestWorkingDir workingDirectory = new TestWorkingDir(workingDirId, (WorkingDir)new LocalWorkingDir(Path.of("/tmp/sub/dir/tmp/", new String[0]), workingDirId));
        Path tempFile = workingDirectory.createTempFile();
        Assertions.assertThat((boolean)tempFile.toFile().getAbsolutePath().startsWith("/tmp/sub/dir/tmp/")).isTrue();
        Assertions.assertThat((int)workingDirectory.getAllCreatedTempFiles().size()).isEqualTo(1);
    }

    @Test
    void shouldCreateFile() throws IOException {
        String workingDirId = IdUtils.create();
        TestWorkingDir workingDirectory = new TestWorkingDir(workingDirId, (WorkingDir)new LocalWorkingDir(Path.of("/tmp/sub/dir/tmp/", new String[0]), workingDirId));
        Path path = workingDirectory.createFile("folder/file.txt");
        Assertions.assertThat((boolean)path.toFile().getAbsolutePath().startsWith("/tmp/sub/dir/tmp/")).isTrue();
        Assertions.assertThat((boolean)path.toFile().getAbsolutePath().endsWith("/folder/file.txt")).isTrue();
        Assertions.assertThat((int)workingDirectory.getAllCreatedFiles().size()).isEqualTo(1);
    }

    @Test
    void shouldThrowExceptionGivenFileAlreadyExist() throws IOException {
        String workingDirId = IdUtils.create();
        TestWorkingDir workingDirectory = new TestWorkingDir(workingDirId, (WorkingDir)new LocalWorkingDir(Path.of("/tmp/sub/dir/tmp/", new String[0]), workingDirId));
        workingDirectory.createFile("folder/file.txt", "1".getBytes(StandardCharsets.UTF_8));
        org.junit.jupiter.api.Assertions.assertThrows(FileAlreadyExistsException.class, () -> workingDirectory.createFile("folder/file.txt", "2".getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    void shouldFindAllFilesMatchingPatterns() throws IOException {
        LocalWorkingDir workingDir = new LocalWorkingDir(Path.of("/tmp/", new String[0]));
        workingDir.createTempFile();
        workingDir.createFile("test1.txt");
        workingDir.createFile("test2.txt");
        workingDir.createFile("sub/test3.txt");
        workingDir.createFile("sub/dir/test4.txt");
        Assertions.assertThat((int)workingDir.findAllFilesMatching(List.of("glob:**/*.*")).size()).isEqualTo(5);
        Assertions.assertThat((int)workingDir.findAllFilesMatching(List.of("*.*", "**/*.*")).size()).isEqualTo(5);
        Assertions.assertThat((int)workingDir.findAllFilesMatching(List.of("*.*", "**/*.*", "**/*.*")).size()).isEqualTo(5);
        Assertions.assertThat((int)workingDir.findAllFilesMatching(List.of("regex:.*\\.tmp", "*.txt", "**/*.txt")).size()).isEqualTo(5);
    }

    @Test
    void shouldRecreateDirectoryAfterCleanup() throws IOException {
        LocalWorkingDir workingDir = new LocalWorkingDir(Path.of("/tmp/", new String[0]), IdUtils.create());
        Path firtPath = workingDir.path(true);
        Path file = workingDir.createFile("test.txt");
        workingDir.cleanup();
        Assertions.assertThat((boolean)file.toFile().exists()).isFalse();
        Assertions.assertThat((boolean)firtPath.toFile().exists()).isFalse();
        Path secondPath = workingDir.path(true);
        Assertions.assertThat((boolean)secondPath.toFile().exists()).isTrue();
        Assertions.assertThat((Path)firtPath).isEqualTo((Object)secondPath);
    }

    @Test
    void should_put_file_into_local_dir() throws IOException {
        LocalWorkingDir workingDir = new LocalWorkingDir(Path.of("/tmp/", new String[0]), IdUtils.create());
        workingDir.path(true);
        Path file = workingDir.createFile("test.txt", (InputStream)new ByteArrayInputStream("First file".getBytes(StandardCharsets.UTF_8)));
        org.junit.jupiter.api.Assertions.assertThrows(FileAlreadyExistsException.class, () -> workingDir.putFile(file, (InputStream)new ByteArrayInputStream("Hello world".getBytes(StandardCharsets.UTF_8)), FileExistComportment.FAIL));
        Assertions.assertThat(Files.readAllLines(file, StandardCharsets.UTF_8)).isEqualTo(List.of("First file"));
        workingDir.putFile(file, (InputStream)new ByteArrayInputStream("Hello world".getBytes(StandardCharsets.UTF_8)), FileExistComportment.IGNORE);
        Assertions.assertThat(Files.readAllLines(file, StandardCharsets.UTF_8)).isEqualTo(List.of("First file"));
        workingDir.putFile(file, (InputStream)new ByteArrayInputStream("Hello world".getBytes(StandardCharsets.UTF_8)), FileExistComportment.WARN);
        Assertions.assertThat(Files.readAllLines(file, StandardCharsets.UTF_8)).isEqualTo(List.of("First file"));
        workingDir.putFile(file, (InputStream)new ByteArrayInputStream("New file".getBytes(StandardCharsets.UTF_8)), FileExistComportment.OVERWRITE);
        Assertions.assertThat(Files.readAllLines(file, StandardCharsets.UTF_8)).isEqualTo(List.of("New file"));
    }
}

