/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.flows.State;
import io.kestra.core.storages.StorageInterface;
import jakarta.inject.Inject;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
public class LogToFileTest {
    @Inject
    private StorageInterface storage;

    @Test
    @ExecuteFlow(value="flows/valids/log-to-file.yaml")
    void task(Execution execution) throws Exception {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        TaskRun taskRun = (TaskRun)execution.getTaskRunList().getFirst();
        Assertions.assertThat((List)taskRun.getAttempts()).hasSize(1);
        TaskRunAttempt attempt = (TaskRunAttempt)taskRun.getAttempts().getFirst();
        Assertions.assertThat((URI)attempt.getLogFile()).isNotNull();
        InputStream inputStream = this.storage.get("main", "io.kestra.tests", attempt.getLogFile());
        List strings = IOUtils.readLines((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((List)strings).isNotNull();
        Assertions.assertThat((int)strings.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)strings.getFirst())).contains(new CharSequence[]{"INFO"});
        Assertions.assertThat((String)((String)strings.getFirst())).contains(new CharSequence[]{"Hello World!"});
    }
}

