/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.runners.TestRunnerUtils;
import io.micronaut.context.ApplicationContext;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;

@Singleton
public class MultipleConditionTriggerCaseTest {
    public static final String NAMESPACE = "io.kestra.tests.trigger";
    @Inject
    protected TestRunnerUtils runnerUtils;
    @Inject
    protected FlowRepositoryInterface flowRepository;
    @Inject
    protected ExecutionRepositoryInterface executionRepository;
    @Inject
    protected ApplicationContext applicationContext;

    public void trigger() throws InterruptedException, TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", NAMESPACE, "trigger-multiplecondition-flow-a");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Thread.sleep(1000L);
        ArrayListTotal flowBExecutions = this.executionRepository.findByFlowId("main", NAMESPACE, "trigger-multiplecondition-flow-b", Pageable.UNPAGED);
        ArrayListTotal listenerExecutions = this.executionRepository.findByFlowId("main", NAMESPACE, "trigger-multiplecondition-listener", Pageable.UNPAGED);
        Assertions.assertThat((List)flowBExecutions).isEmpty();
        Assertions.assertThat((List)listenerExecutions).isEmpty();
        execution = this.runnerUtils.runOne("main", NAMESPACE, "trigger-multiplecondition-flow-b");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution triggerExecution = this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS), "main", NAMESPACE, "trigger-multiplecondition-listener");
        Assertions.assertThat((int)triggerExecution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)triggerExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat(triggerExecution.getTrigger().getVariables().get("executionId")).isEqualTo((Object)execution.getId());
        Assertions.assertThat(triggerExecution.getTrigger().getVariables().get("namespace")).isEqualTo((Object)NAMESPACE);
        Assertions.assertThat(triggerExecution.getTrigger().getVariables().get("flowId")).isEqualTo((Object)"trigger-multiplecondition-flow-b");
    }

    public void failed(String tenantId) throws InterruptedException, TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne(tenantId, NAMESPACE, "trigger-multiplecondition-flow-c");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Thread.sleep(1000L);
        ArrayListTotal byFlowId = this.executionRepository.findByFlowId(tenantId, NAMESPACE, "trigger-multiplecondition-flow-d", Pageable.UNPAGED);
        Assertions.assertThat((List)byFlowId).isEmpty();
        execution = this.runnerUtils.runOne(tenantId, NAMESPACE, "trigger-multiplecondition-flow-d");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution triggerExecution = this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS), tenantId, NAMESPACE, "trigger-flow-listener-namespace-condition");
        Assertions.assertThat((Comparable)triggerExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    public void flowTriggerPreconditions() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests.trigger.preconditions", "flow-trigger-preconditions-flow-a");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        execution = this.runnerUtils.runOne("main", "io.kestra.tests.trigger.preconditions", "flow-trigger-preconditions-flow-a");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        execution = this.runnerUtils.runOne("main", "io.kestra.tests.trigger.preconditions", "flow-trigger-preconditions-flow-b");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution triggerExecution = this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS), "main", "io.kestra.tests.trigger.preconditions", "flow-trigger-preconditions-flow-listen");
        Assertions.assertThat((int)triggerExecution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)triggerExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat(triggerExecution.getTrigger().getVariables().get("outputs")).isNotNull();
        Assertions.assertThat((Map)((Map)triggerExecution.getTrigger().getVariables().get("outputs"))).containsEntry((Object)"some", (Object)"value");
    }

    public void flowTriggerPreconditionsMergeOutputs(String tenantId) throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne(tenantId, "io.kestra.tests.trigger.preconditions", "flow-trigger-preconditions-flow-b");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        execution = this.runnerUtils.runOne(tenantId, "io.kestra.tests.trigger.preconditions", "flow-trigger-preconditions-flow-a");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution triggerExecution = this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS), tenantId, "io.kestra.tests.trigger.preconditions", "flow-trigger-preconditions-flow-listen");
        Assertions.assertThat((int)triggerExecution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)triggerExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat(triggerExecution.getTrigger().getVariables().get("outputs")).isNotNull();
        Assertions.assertThat((Map)((Map)triggerExecution.getTrigger().getVariables().get("outputs"))).containsEntry((Object)"some", (Object)"value");
    }

    public void flowTriggerOnPaused() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests.trigger.paused", "flow-trigger-paused-flow");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(2);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution triggerExecution = this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS), "main", "io.kestra.tests.trigger.paused", "flow-trigger-paused-listen");
        Assertions.assertThat((int)triggerExecution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)triggerExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    public void forEachItemWithFlowTrigger() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests.trigger.foreachitem", "flow-trigger-for-each-item-parent");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(5);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        List childExecutions = this.runnerUtils.awaitFlowExecutionNumber(5, "main", "io.kestra.tests.trigger.foreachitem", "flow-trigger-for-each-item-child");
        Assertions.assertThat((List)childExecutions).hasSize(5);
        childExecutions.forEach(exec -> {
            Assertions.assertThat((Comparable)exec.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
            Assertions.assertThat((int)exec.getTaskRunList().size()).isEqualTo(1);
        });
        List grandchildExecutions = this.runnerUtils.awaitFlowExecutionNumber(5, "main", "io.kestra.tests.trigger.foreachitem", "flow-trigger-for-each-item-grandchild");
        Assertions.assertThat((List)grandchildExecutions).hasSize(5);
        grandchildExecutions.forEach(exec -> {
            Assertions.assertThat((Comparable)exec.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
            Assertions.assertThat((int)exec.getTaskRunList().size()).isEqualTo(2);
        });
    }

    public void flowTriggerMultiplePreconditions() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests.trigger.multiple.preconditions", "flow-trigger-multiple-preconditions-flow-a");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution triggerExecution = this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS), "main", "io.kestra.tests.trigger.multiple.preconditions", "flow-trigger-multiple-preconditions-flow-listen");
        this.executionRepository.delete(triggerExecution);
        Assertions.assertThat((int)triggerExecution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)triggerExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS), "main", "io.kestra.tests.trigger.multiple.preconditions", "flow-trigger-multiple-preconditions-flow-listen", Duration.ofSeconds(1L)));
    }

    public void flowTriggerMultipleConditions() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests.trigger.multiple.conditions", "flow-trigger-multiple-conditions-flow-a");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution triggerExecution = this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS), "main", "io.kestra.tests.trigger.multiple.conditions", "flow-trigger-multiple-conditions-flow-listen");
        this.executionRepository.delete(triggerExecution);
        Assertions.assertThat((int)triggerExecution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)triggerExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS), "main", "io.kestra.tests.trigger.multiple.conditions", "flow-trigger-multiple-conditions-flow-listen", Duration.ofSeconds(1L)));
    }

    public void flowTriggerMixedConditions() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests.trigger.mixed.conditions", "flow-trigger-mixed-conditions-flow-a");
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution triggerExecution = this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS), "main", "io.kestra.tests.trigger.mixed.conditions", "flow-trigger-mixed-conditions-flow-listen");
        this.executionRepository.delete(triggerExecution);
        Assertions.assertThat((int)triggerExecution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)triggerExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS), "main", "io.kestra.tests.trigger.mixed.conditions", "flow-trigger-mixed-conditions-flow-listen", Duration.ofSeconds(1L)));
    }
}

