/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.runners.InputsTest;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.test.support.TestPropertyProvider;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@KestraTest(startRunner=true)
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class NoEncryptionConfiguredTest
implements TestPropertyProvider {
    @Inject
    private FlowRepositoryInterface flowRepository;
    @Inject
    private FlowInputOutput flowIO;

    @NonNull
    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("kestra.encryption.secret-key", null);
        return properties;
    }

    @Test
    @ExecuteFlow(value="flows/valids/encrypted-string.yaml")
    void encryptedStringOutput(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        TaskRun hello = (TaskRun)execution.findTaskRunsByTaskId("hello").getFirst();
        Map valueOutput = (Map)hello.getOutputs().get((Object)"value");
        Assertions.assertThat((int)valueOutput.size()).isEqualTo(2);
        Assertions.assertThat((String)((String)valueOutput.get("type"))).isEqualTo("io.kestra.datatype:aes_encrypted");
        Assertions.assertThat((String)((String)valueOutput.get("value"))).isEqualTo("Hello World");
        TaskRun returnTask = (TaskRun)execution.findTaskRunsByTaskId("return").getFirst();
        Assertions.assertThat((Object)returnTask.getOutputs().get((Object)"value")).isEqualTo((Object)"Hello World");
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs.yaml"})
    void secretInput() {
        Assertions.assertThat((boolean)this.flowRepository.findById("main", "io.kestra.tests", "inputs").isPresent()).isTrue();
        Flow flow = (Flow)this.flowRepository.findById("main", "io.kestra.tests", "inputs").get();
        Execution execution = Execution.builder().id("test").namespace(flow.getNamespace()).tenantId("main").flowRevision(Integer.valueOf(1)).flowId(flow.getId()).build();
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.flowIO.readExecutionInputs((FlowInterface)flow, execution, InputsTest.inputs));
    }
}

