/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.utils.GraphUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import lombok.Generated;
import org.assertj.core.api.Assertions;

@Singleton
public class PluginDefaultsCaseTest {
    @Inject
    private TestRunnerUtils runnerUtils;

    public void taskDefaults() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "plugin-defaults", Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(8);
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().getFirst()).getTaskId()).isEqualTo("first");
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"def")).isEqualTo((Object)"1");
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(1)).getTaskId()).isEqualTo("second");
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().get(1)).getOutputs().get((Object)"def")).isEqualTo((Object)"2");
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(2)).getTaskId()).isEqualTo("third");
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().get(2)).getOutputs().get((Object)"def")).isEqualTo((Object)"3");
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(4)).getTaskId()).isEqualTo("err-first");
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().get(4)).getOutputs().get((Object)"def")).isEqualTo((Object)"1");
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(5)).getTaskId()).isEqualTo("err-second");
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().get(5)).getOutputs().get((Object)"def")).isEqualTo((Object)"2");
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(6)).getTaskId()).isEqualTo("err-third");
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().get(6)).getOutputs().get((Object)"def")).isEqualTo((Object)"3");
    }

    public static class DefaultSequential3
    extends DefaultSequential1 {
        @Generated
        protected DefaultSequential3(DefaultSequential3Builder<?, ?> b) {
            super(b);
        }

        @Generated
        public static DefaultSequential3Builder<?, ?> builder() {
            return new DefaultSequential3BuilderImpl();
        }

        @Override
        @Generated
        public String toString() {
            return "PluginDefaultsCaseTest.DefaultSequential3(super=" + super.toString() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultSequential3)) {
                return false;
            }
            DefaultSequential3 other = (DefaultSequential3)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DefaultSequential3;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }

        @Generated
        public DefaultSequential3() {
        }

        @Generated
        private static final class DefaultSequential3BuilderImpl
        extends DefaultSequential3Builder<DefaultSequential3, DefaultSequential3BuilderImpl> {
            @Generated
            private DefaultSequential3BuilderImpl() {
            }

            @Override
            @Generated
            protected DefaultSequential3BuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DefaultSequential3 build() {
                return new DefaultSequential3(this);
            }
        }

        @Generated
        public static abstract class DefaultSequential3Builder<C extends DefaultSequential3, B extends DefaultSequential3Builder<C, B>>
        extends DefaultSequential1.DefaultSequential1Builder<C, B> {
            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "PluginDefaultsCaseTest.DefaultSequential3.DefaultSequential3Builder(super=" + super.toString() + ")";
            }
        }
    }

    public static class DefaultSequential2
    extends DefaultSequential1 {
        @Generated
        protected DefaultSequential2(DefaultSequential2Builder<?, ?> b) {
            super(b);
        }

        @Generated
        public static DefaultSequential2Builder<?, ?> builder() {
            return new DefaultSequential2BuilderImpl();
        }

        @Override
        @Generated
        public String toString() {
            return "PluginDefaultsCaseTest.DefaultSequential2(super=" + super.toString() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultSequential2)) {
                return false;
            }
            DefaultSequential2 other = (DefaultSequential2)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DefaultSequential2;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }

        @Generated
        public DefaultSequential2() {
        }

        @Generated
        private static final class DefaultSequential2BuilderImpl
        extends DefaultSequential2Builder<DefaultSequential2, DefaultSequential2BuilderImpl> {
            @Generated
            private DefaultSequential2BuilderImpl() {
            }

            @Override
            @Generated
            protected DefaultSequential2BuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DefaultSequential2 build() {
                return new DefaultSequential2(this);
            }
        }

        @Generated
        public static abstract class DefaultSequential2Builder<C extends DefaultSequential2, B extends DefaultSequential2Builder<C, B>>
        extends DefaultSequential1.DefaultSequential1Builder<C, B> {
            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "PluginDefaultsCaseTest.DefaultSequential2.DefaultSequential2Builder(super=" + super.toString() + ")";
            }
        }
    }

    public static class DefaultSequential1
    extends Task
    implements FlowableTask<Output> {
        @Valid
        protected List<Task> errors;
        @Valid
        @JsonProperty(value="finally")
        protected List<Task> _finally;
        @Valid
        @NotEmpty
        private List<Task> tasks;
        private String def;

        public List<Task> getFinally() {
            return this._finally;
        }

        public GraphCluster tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
            GraphCluster subGraph = new GraphCluster((Task)this, taskRun, parentValues, RelationType.SEQUENTIAL);
            GraphUtils.sequential((GraphCluster)subGraph, this.tasks, this.errors, this._finally, (TaskRun)taskRun, (Execution)execution);
            return subGraph;
        }

        public List<Task> allChildTasks() {
            return Stream.concat(this.tasks != null ? this.tasks.stream() : Stream.empty(), Stream.concat(this.errors != null ? this.errors.stream() : Stream.empty(), this._finally != null ? this._finally.stream() : Stream.empty())).toList();
        }

        public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) {
            return FlowableUtils.resolveTasks(this.tasks, (TaskRun)parentTaskRun);
        }

        public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) {
            return FlowableUtils.resolveSequentialNexts((Execution)execution, this.childTasks(runContext, parentTaskRun), (List)FlowableUtils.resolveTasks(this.errors, (TaskRun)parentTaskRun), (List)FlowableUtils.resolveTasks(this._finally, (TaskRun)parentTaskRun), (TaskRun)parentTaskRun);
        }

        public Output outputs(RunContext runContext) throws IllegalVariableEvaluationException {
            return ((Output.OutputBuilder)Output.builder().def(this.def)).build();
        }

        @Generated
        protected DefaultSequential1(DefaultSequential1Builder<?, ?> b) {
            super(b);
            this.errors = b.errors;
            this._finally = b._finally;
            this.tasks = b.tasks;
            this.def = b.def;
        }

        @Generated
        public static DefaultSequential1Builder<?, ?> builder() {
            return new DefaultSequential1BuilderImpl();
        }

        @Generated
        public String toString() {
            return "PluginDefaultsCaseTest.DefaultSequential1(super=" + super.toString() + ", errors=" + String.valueOf(this.getErrors()) + ", _finally=" + String.valueOf(this._finally) + ", tasks=" + String.valueOf(this.getTasks()) + ", def=" + this.getDef() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultSequential1)) {
                return false;
            }
            DefaultSequential1 other = (DefaultSequential1)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<Task> this$errors = this.getErrors();
            List<Task> other$errors = other.getErrors();
            if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
                return false;
            }
            List<Task> this$_finally = this._finally;
            List<Task> other$_finally = other._finally;
            if (this$_finally == null ? other$_finally != null : !((Object)this$_finally).equals(other$_finally)) {
                return false;
            }
            List<Task> this$tasks = this.getTasks();
            List<Task> other$tasks = other.getTasks();
            if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
                return false;
            }
            String this$def = this.getDef();
            String other$def = other.getDef();
            return !(this$def == null ? other$def != null : !this$def.equals(other$def));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DefaultSequential1;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<Task> $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
            List<Task> $_finally = this._finally;
            result = result * 59 + ($_finally == null ? 43 : ((Object)$_finally).hashCode());
            List<Task> $tasks = this.getTasks();
            result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
            String $def = this.getDef();
            result = result * 59 + ($def == null ? 43 : $def.hashCode());
            return result;
        }

        @Generated
        public List<Task> getErrors() {
            return this.errors;
        }

        @Generated
        public List<Task> getTasks() {
            return this.tasks;
        }

        @Generated
        public String getDef() {
            return this.def;
        }

        @Generated
        public DefaultSequential1() {
        }

        public static class Output
        implements io.kestra.core.models.tasks.Output {
            private final String def;

            @Generated
            protected Output(OutputBuilder<?, ?> b) {
                this.def = b.def;
            }

            @Generated
            public static OutputBuilder<?, ?> builder() {
                return new OutputBuilderImpl();
            }

            @Generated
            public String getDef() {
                return this.def;
            }

            @Generated
            public static abstract class OutputBuilder<C extends Output, B extends OutputBuilder<C, B>> {
                @Generated
                private String def;

                @Generated
                public B def(String def) {
                    this.def = def;
                    return this.self();
                }

                @Generated
                protected abstract B self();

                @Generated
                public abstract C build();

                @Generated
                public String toString() {
                    return "PluginDefaultsCaseTest.DefaultSequential1.Output.OutputBuilder(def=" + this.def + ")";
                }
            }

            @Generated
            private static final class OutputBuilderImpl
            extends OutputBuilder<Output, OutputBuilderImpl> {
                @Generated
                private OutputBuilderImpl() {
                }

                @Override
                @Generated
                protected OutputBuilderImpl self() {
                    return this;
                }

                @Override
                @Generated
                public Output build() {
                    return new Output(this);
                }
            }
        }

        @Generated
        public static abstract class DefaultSequential1Builder<C extends DefaultSequential1, B extends DefaultSequential1Builder<C, B>>
        extends Task.TaskBuilder<C, B> {
            @Generated
            private List<Task> errors;
            @Generated
            private List<Task> _finally;
            @Generated
            private List<Task> tasks;
            @Generated
            private String def;

            @Generated
            public B errors(List<Task> errors) {
                this.errors = errors;
                return (B)this.self();
            }

            @JsonProperty(value="finally")
            @Generated
            public B _finally(List<Task> _finally) {
                this._finally = _finally;
                return (B)this.self();
            }

            @Generated
            public B tasks(List<Task> tasks) {
                this.tasks = tasks;
                return (B)this.self();
            }

            @Generated
            public B def(String def) {
                this.def = def;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "PluginDefaultsCaseTest.DefaultSequential1.DefaultSequential1Builder(super=" + super.toString() + ", errors=" + String.valueOf(this.errors) + ", _finally=" + String.valueOf(this._finally) + ", tasks=" + String.valueOf(this.tasks) + ", def=" + this.def + ")";
            }
        }

        @Generated
        private static final class DefaultSequential1BuilderImpl
        extends DefaultSequential1Builder<DefaultSequential1, DefaultSequential1BuilderImpl> {
            @Generated
            private DefaultSequential1BuilderImpl() {
            }

            @Override
            @Generated
            protected DefaultSequential1BuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DefaultSequential1 build() {
                return new DefaultSequential1(this);
            }
        }
    }
}

