/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.State;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.services.ExecutionService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;

@Singleton
public class RestartCaseTest {
    @Inject
    private FlowRepositoryInterface flowRepository;
    @Inject
    private TestRunnerUtils runnerUtils;
    @Inject
    private ExecutionService executionService;

    public void restartFailedThenSuccess() throws Exception {
        Flow flow = (Flow)this.flowRepository.findById("main", "io.kestra.tests", "restart_last_failed").orElseThrow();
        Execution firstExecution = this.runnerUtils.runOne("main", flow.getNamespace(), flow.getId());
        Assertions.assertThat((Comparable)firstExecution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)firstExecution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)((TaskRun)firstExecution.getTaskRunList().get(2)).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Execution restartedExec = this.executionService.restart(firstExecution, null);
        Assertions.assertThat((Object)restartedExec).isNotNull();
        Assertions.assertThat((String)restartedExec.getId()).isEqualTo(firstExecution.getId());
        Assertions.assertThat((String)restartedExec.getParentId()).isNull();
        Assertions.assertThat((int)restartedExec.getTaskRunList().size()).isEqualTo(3);
        Assertions.assertThat((Comparable)restartedExec.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Execution finishedRestartedExecution = this.runnerUtils.restartExecution(execution -> execution.getState().getCurrent() == State.Type.SUCCESS && execution.getId().equals(firstExecution.getId()), restartedExec);
        Assertions.assertThat((Object)finishedRestartedExecution).isNotNull();
        Assertions.assertThat((String)finishedRestartedExecution.getId()).isEqualTo(firstExecution.getId());
        Assertions.assertThat((String)finishedRestartedExecution.getParentId()).isNull();
        Assertions.assertThat((int)finishedRestartedExecution.getTaskRunList().size()).isEqualTo(4);
        Assertions.assertThat((int)((TaskRun)finishedRestartedExecution.getTaskRunList().get(2)).getAttempts().size()).isEqualTo(2);
        finishedRestartedExecution.getTaskRunList().stream().map(TaskRun::getState).forEach(state -> Assertions.assertThat((Comparable)state.getCurrent()).isEqualTo((Object)State.Type.SUCCESS));
    }

    public void restartFailedThenFailureWithGlobalErrors() throws Exception {
        Flow flow = (Flow)this.flowRepository.findById("main", "io.kestra.tests", "restart_always_failed").orElseThrow();
        Execution firstExecution = this.runnerUtils.runOne("main", flow.getNamespace(), flow.getId(), Duration.ofSeconds(60L));
        Assertions.assertThat((Comparable)firstExecution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)firstExecution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)((TaskRun)firstExecution.getTaskRunList().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Execution restartedExec = this.executionService.restart(firstExecution, null);
        Assertions.assertThat((Object)restartedExec).isNotNull();
        Assertions.assertThat((String)restartedExec.getId()).isEqualTo(firstExecution.getId());
        Assertions.assertThat((String)restartedExec.getParentId()).isNull();
        Assertions.assertThat((int)restartedExec.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)restartedExec.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Execution finishedRestartedExecution = this.runnerUtils.restartExecution(execution -> execution.getState().getCurrent() == State.Type.FAILED && ((TaskRun)execution.getTaskRunList().getFirst()).getAttempts().size() == 2, restartedExec);
        Assertions.assertThat((Object)finishedRestartedExecution).isNotNull();
        Assertions.assertThat((String)finishedRestartedExecution.getId()).isEqualTo(firstExecution.getId());
        Assertions.assertThat((String)finishedRestartedExecution.getParentId()).isNull();
        Assertions.assertThat((int)finishedRestartedExecution.getTaskRunList().size()).isEqualTo(2);
        Assertions.assertThat((int)((TaskRun)finishedRestartedExecution.getTaskRunList().getFirst()).getAttempts().size()).isEqualTo(2);
        Assertions.assertThat((Comparable)finishedRestartedExecution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    public void restartFailedThenFailureWithLocalErrors() throws Exception {
        Flow flow = (Flow)this.flowRepository.findById("main", "io.kestra.tests", "restart_local_errors").orElseThrow();
        Execution firstExecution = this.runnerUtils.runOne("main", flow.getNamespace(), flow.getId(), Duration.ofSeconds(60L));
        Assertions.assertThat((Comparable)firstExecution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)firstExecution.getTaskRunList()).hasSize(5);
        Assertions.assertThat((Comparable)((TaskRun)firstExecution.getTaskRunList().get(3)).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Execution restartedExec = this.executionService.restart(firstExecution, null);
        Assertions.assertThat((Object)restartedExec).isNotNull();
        Assertions.assertThat((String)restartedExec.getId()).isEqualTo(firstExecution.getId());
        Assertions.assertThat((String)restartedExec.getParentId()).isNull();
        Assertions.assertThat((int)restartedExec.getTaskRunList().size()).isEqualTo(4);
        Assertions.assertThat((Comparable)restartedExec.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Execution finishedRestartedExecution = this.runnerUtils.restartExecution(execution -> execution.getState().getCurrent() == State.Type.FAILED && ((TaskRun)execution.findTaskRunsByTaskId("failStep").stream().findFirst().get()).getAttempts().size() == 2, restartedExec);
        Assertions.assertThat((Object)finishedRestartedExecution).isNotNull();
        Assertions.assertThat((String)finishedRestartedExecution.getId()).isEqualTo(firstExecution.getId());
        Assertions.assertThat((String)finishedRestartedExecution.getParentId()).isNull();
        Assertions.assertThat((int)finishedRestartedExecution.getTaskRunList().size()).isEqualTo(5);
        Optional taskRun = finishedRestartedExecution.findTaskRunsByTaskId("failStep").stream().findFirst();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)taskRun.isPresent());
        Assertions.assertThat((int)((TaskRun)taskRun.get()).getAttempts().size()).isEqualTo(2);
        Assertions.assertThat((Comparable)finishedRestartedExecution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    public void replay() throws Exception {
        Flow flow = (Flow)this.flowRepository.findById("main", "io.kestra.tests", "restart-each").orElseThrow();
        Execution firstExecution = this.runnerUtils.runOne("main", flow.getNamespace(), flow.getId(), Duration.ofSeconds(60L));
        Assertions.assertThat((Comparable)firstExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Execution restartedExec = this.executionService.replay(firstExecution, firstExecution.findTaskRunByTaskIdAndValue("2_end", List.of()).getId(), null);
        Assertions.assertThat((Comparable)restartedExec.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((List)restartedExec.getState().getHistories()).hasSize(4);
        Assertions.assertThat((List)restartedExec.getTaskRunList()).hasSize(20);
        Assertions.assertThat((Comparable)((TaskRun)restartedExec.getTaskRunList().get(19)).getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Assertions.assertThat((String)restartedExec.getId()).isNotEqualTo((Object)firstExecution.getId());
        Assertions.assertThat((String)((TaskRun)restartedExec.getTaskRunList().get(1)).getId()).isNotEqualTo((Object)((TaskRun)firstExecution.getTaskRunList().get(1)).getId());
        Execution finishedRestartedExecution = this.runnerUtils.awaitChildExecution(flow, firstExecution, restartedExec, Duration.ofSeconds(60L));
        Assertions.assertThat((Object)finishedRestartedExecution).isNotNull();
        Assertions.assertThat((String)finishedRestartedExecution.getId()).isNotEqualTo((Object)firstExecution.getId());
        Assertions.assertThat((String)finishedRestartedExecution.getParentId()).isEqualTo(firstExecution.getId());
        Assertions.assertThat((Comparable)finishedRestartedExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    public void restartMultiple() throws Exception {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "failed-first");
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Execution restart = this.executionService.restart(execution, null);
        Assertions.assertThat((Comparable)restart.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Execution restartEnded = this.runnerUtils.restartExecution(e -> e.getState().getCurrent() == State.Type.FAILED, restart);
        Assertions.assertThat((Comparable)restartEnded.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Execution newRestart = this.executionService.restart(restartEnded, null);
        restartEnded = this.runnerUtils.restartExecution(e -> e.getState().getCurrent() == State.Type.FAILED, newRestart);
        Assertions.assertThat((Comparable)restartEnded.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    public void restartSubflow() throws Exception {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "restart-parent");
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().isFailed(), "main", "io.kestra.tests", "restart-child");
        Execution restarted1 = this.executionService.restart(execution, null);
        execution = this.runnerUtils.restartExecution(e -> e.getState().getCurrent() == State.Type.FAILED && e.getFlowId().equals("restart-parent"), restarted1);
        Execution restarted2 = this.executionService.restart(execution, null);
        execution = this.runnerUtils.restartExecution(e -> e.getState().getCurrent() == State.Type.FAILED && e.getFlowId().equals("restart-parent"), restarted2);
        Execution restarted3 = this.executionService.restart(execution, null);
        execution = this.runnerUtils.restartExecution(e -> e.getState().getCurrent() == State.Type.SUCCESS && e.getFlowId().equals("restart-parent"), restarted3);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(6);
        List childExecutions = this.runnerUtils.awaitFlowExecutionNumber(3, "main", "io.kestra.tests", "restart-child");
        List<Execution> successfulRestart = childExecutions.stream().filter(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS)).toList();
        Assertions.assertThat(successfulRestart).hasSize(3);
    }

    public void restartFailedWithFinally() throws Exception {
        Flow flow = (Flow)this.flowRepository.findById("main", "io.kestra.tests", "restart-with-finally").orElseThrow();
        Execution firstExecution = this.runnerUtils.runOne("main", flow.getNamespace(), flow.getId(), Duration.ofSeconds(60L));
        Assertions.assertThat((Comparable)firstExecution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)firstExecution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)((TaskRun)firstExecution.getTaskRunList().get(1)).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Execution restartedExec = this.executionService.restart(firstExecution, null);
        Assertions.assertThat((Object)restartedExec).isNotNull();
        Assertions.assertThat((String)restartedExec.getId()).isEqualTo(firstExecution.getId());
        Assertions.assertThat((String)restartedExec.getParentId()).isNull();
        Assertions.assertThat((int)restartedExec.getTaskRunList().size()).isEqualTo(2);
        Assertions.assertThat((Comparable)restartedExec.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Execution finishedRestartedExecution = this.runnerUtils.restartExecution(execution -> this.executionService.isTerminated(flow, execution) && execution.getState().isSuccess(), restartedExec);
        Assertions.assertThat((Object)finishedRestartedExecution).isNotNull();
        Assertions.assertThat((String)finishedRestartedExecution.getId()).isEqualTo(firstExecution.getId());
        Assertions.assertThat((String)finishedRestartedExecution.getParentId()).isNull();
        Assertions.assertThat((int)finishedRestartedExecution.getTaskRunList().size()).isEqualTo(4);
        finishedRestartedExecution.getTaskRunList().stream().map(TaskRun::getState).forEach(state -> Assertions.assertThat((Comparable)state.getCurrent()).isIn(new Object[]{State.Type.SUCCESS, State.Type.SKIPPED}));
    }

    public void restartFailedWithAfterExecution() throws Exception {
        Flow flow = (Flow)this.flowRepository.findById("main", "io.kestra.tests", "restart-with-after-execution").orElseThrow();
        Execution firstExecution = this.runnerUtils.runOne("main", flow.getNamespace(), flow.getId(), Duration.ofSeconds(60L));
        Assertions.assertThat((Comparable)firstExecution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)firstExecution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)((TaskRun)firstExecution.getTaskRunList().get(1)).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Execution restartedExec = this.executionService.restart(firstExecution, null);
        Assertions.assertThat((Object)restartedExec).isNotNull();
        Assertions.assertThat((String)restartedExec.getId()).isEqualTo(firstExecution.getId());
        Assertions.assertThat((String)restartedExec.getParentId()).isNull();
        Assertions.assertThat((int)restartedExec.getTaskRunList().size()).isEqualTo(2);
        Assertions.assertThat((Comparable)restartedExec.getState().getCurrent()).isEqualTo((Object)State.Type.RESTARTED);
        Execution finishedRestartedExecution = this.runnerUtils.restartExecution(execution -> this.executionService.isTerminated(flow, execution) && execution.getState().isSuccess(), restartedExec);
        Assertions.assertThat((Object)finishedRestartedExecution).isNotNull();
        Assertions.assertThat((String)finishedRestartedExecution.getId()).isEqualTo(firstExecution.getId());
        Assertions.assertThat((String)finishedRestartedExecution.getParentId()).isNull();
        Assertions.assertThat((int)finishedRestartedExecution.getTaskRunList().size()).isEqualTo(4);
        finishedRestartedExecution.getTaskRunList().stream().map(TaskRun::getState).forEach(state -> Assertions.assertThat((Comparable)state.getCurrent()).isIn(new Object[]{State.Type.SUCCESS, State.Type.SKIPPED}));
    }
}

