/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.RunContextLogger;
import io.kestra.core.utils.TestsUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import reactor.core.publisher.Flux;

@KestraTest
@org.junit.jupiter.api.parallel.Execution(value=ExecutionMode.SAME_THREAD)
class RunContextLoggerTest {
    @Inject
    @Named(value="workerTaskLogQueue")
    QueueInterface<LogEntry> logQueue;

    RunContextLoggerTest() {
    }

    @Test
    void logs() {
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(this.logQueue, either -> logs.add((LogEntry)either.getLeft()));
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, Map.of());
        RunContextLogger runContextLogger = new RunContextLogger(this.logQueue, LogEntry.of((Execution)execution), Level.TRACE, false);
        Logger logger = runContextLogger.logger();
        logger.trace("trace");
        logger.debug("debug");
        logger.info("info");
        logger.warn("warn");
        logger.error("error");
        List matchingLog = TestsUtils.awaitLogs(logs, (Integer)5);
        receive.blockLast();
        Assertions.assertThat((String)matchingLog.stream().filter(logEntry -> logEntry.getLevel().equals((Object)Level.TRACE)).findFirst().orElseThrow().getMessage()).isEqualTo("trace");
        Assertions.assertThat((String)matchingLog.stream().filter(logEntry -> logEntry.getLevel().equals((Object)Level.DEBUG)).findFirst().orElseThrow().getMessage()).isEqualTo("debug");
        Assertions.assertThat((String)matchingLog.stream().filter(logEntry -> logEntry.getLevel().equals((Object)Level.INFO)).findFirst().orElseThrow().getMessage()).isEqualTo("info");
        Assertions.assertThat((String)matchingLog.stream().filter(logEntry -> logEntry.getLevel().equals((Object)Level.WARN)).findFirst().orElseThrow().getMessage()).isEqualTo("warn");
        Assertions.assertThat((String)matchingLog.stream().filter(logEntry -> logEntry.getLevel().equals((Object)Level.ERROR)).findFirst().orElseThrow().getMessage()).isEqualTo("error");
    }

    @Test
    void emptyLogMessage() {
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(this.logQueue, either -> logs.add((LogEntry)either.getLeft()));
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, Map.of());
        RunContextLogger runContextLogger = new RunContextLogger(this.logQueue, LogEntry.of((Execution)execution), Level.TRACE, false);
        Logger logger = runContextLogger.logger();
        logger.info("");
        List matchingLog = TestsUtils.awaitLogs(logs, (Integer)1);
        receive.blockLast();
        Assertions.assertThat((String)((LogEntry)matchingLog.stream().findFirst().orElseThrow()).getMessage()).isEmpty();
    }

    @Test
    void secrets() {
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(this.logQueue, either -> logs.add((LogEntry)either.getLeft()));
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, Map.of());
        RunContextLogger runContextLogger = new RunContextLogger(this.logQueue, LogEntry.of((Execution)execution), Level.TRACE, false);
        runContextLogger.usedSecret("doe.com");
        runContextLogger.usedSecret("myawesomepass");
        runContextLogger.usedSecret("http://it-s.secret");
        runContextLogger.usedSecret("");
        runContextLogger.usedSecret(null);
        Logger logger = runContextLogger.logger();
        logger.debug("test {} test", (Object)"john@doe.com", (Object)new Exception("exception from doe.com"));
        logger.info("test {} myawesomepassmyawesomepass myawesomepass myawesomepassmyawesomepass", (Object)Base64.getEncoder().encodeToString("myawesomepass".getBytes(StandardCharsets.UTF_8)));
        logger.warn("test {}", (Object)URI.create("http://it-s.secret"));
        List matchingLog = TestsUtils.awaitLogs(logs, (Integer)4);
        receive.blockLast();
        Assertions.assertThat((String)matchingLog.stream().filter(logEntry -> logEntry.getLevel().equals((Object)Level.DEBUG)).findFirst().orElseThrow().getMessage()).isEqualTo("test john@****** test");
        Assertions.assertThat((String)matchingLog.stream().filter(logEntry -> logEntry.getLevel().equals((Object)Level.TRACE)).findFirst().orElseThrow().getMessage()).contains(new CharSequence[]{"exception from doe.com"});
        Assertions.assertThat((String)matchingLog.stream().filter(logEntry -> logEntry.getLevel().equals((Object)Level.INFO)).findFirst().orElseThrow().getMessage()).isEqualTo("test ****** ************ ****** ************");
        Assertions.assertThat((String)matchingLog.stream().filter(logEntry -> logEntry.getLevel().equals((Object)Level.WARN)).findFirst().orElseThrow().getMessage()).isEqualTo("test ******");
    }
}

