/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextProperty;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class RunContextPropertyTest {
    @Inject
    private TestRunContextFactory runContextFactory;

    RunContextPropertyTest() {
    }

    @Test
    void asShouldReturnEmptyForNullProperty() throws IllegalVariableEvaluationException {
        RunContext runContext = this.runContextFactory.of();
        RunContextProperty runContextProperty = new RunContextProperty(null, runContext);
        Assertions.assertThat((Optional)runContextProperty.as(String.class)).isEqualTo(Optional.empty());
        runContextProperty = new RunContextProperty(null, runContext);
        Assertions.assertThat((Optional)runContextProperty.as(String.class, Map.of("key", "value"))).isEqualTo(Optional.empty());
    }

    @Test
    void asShouldRenderAProperty() throws IllegalVariableEvaluationException {
        RunContext runContext = this.runContextFactory.of(Map.of("variable", "value"));
        RunContextProperty runContextProperty = new RunContextProperty(Property.builder().expression("{{ variable }}").build(), runContext);
        Assertions.assertThat((String)((String)runContextProperty.as(String.class).orElseThrow())).isEqualTo("value");
        runContextProperty = new RunContextProperty(Property.builder().expression("{{ key }}").build(), runContext);
        Assertions.assertThat((String)((String)runContextProperty.as(String.class, Map.of("key", "value")).orElseThrow())).isEqualTo("value");
    }

    @Test
    void asListShouldReturnEmptyForNullProperty() throws IllegalVariableEvaluationException {
        RunContext runContext = this.runContextFactory.of();
        RunContextProperty runContextProperty = new RunContextProperty(null, runContext);
        Assertions.assertThat((List)((List)runContextProperty.asList(String.class))).hasSize(0);
        runContextProperty = new RunContextProperty(null, runContext);
        Assertions.assertThat((List)((List)runContextProperty.asList(String.class, Map.of("key", "value")))).hasSize(0);
    }

    @Test
    void asListShouldRenderAProperty() throws IllegalVariableEvaluationException {
        RunContext runContext = this.runContextFactory.of(Map.of("variable", "value"));
        RunContextProperty runContextProperty = new RunContextProperty(Property.builder().expression("[\"{{ variable }}\"]").build(), runContext);
        Assertions.assertThat((List)((List)runContextProperty.asList(String.class))).contains((Object[])new String[]{"value"});
        runContextProperty = new RunContextProperty(Property.builder().expression("[\"{{ key }}\"]").build(), runContext);
        Assertions.assertThat((List)((List)runContextProperty.asList(String.class, Map.of("key", "value")))).contains((Object[])new String[]{"value"});
    }

    @Test
    void asMapShouldReturnEmptyForNullProperty() throws IllegalVariableEvaluationException {
        RunContext runContext = this.runContextFactory.of();
        RunContextProperty runContextProperty = new RunContextProperty(null, runContext);
        Assertions.assertThat((Map)((Map)runContextProperty.asMap(String.class, String.class))).hasSize(0);
        runContextProperty = new RunContextProperty(null, runContext);
        Assertions.assertThat((Map)((Map)runContextProperty.asMap(String.class, String.class, Map.of("key", "value")))).hasSize(0);
    }

    @Test
    void asMapShouldRenderAProperty() throws IllegalVariableEvaluationException {
        RunContext runContext = this.runContextFactory.of(Map.of("variable", "value"));
        RunContextProperty runContextProperty = new RunContextProperty(Property.builder().expression("{ \"key\": \"{{ variable }}\"}").build(), runContext);
        Assertions.assertThat((Map)((Map)runContextProperty.asMap(String.class, String.class))).containsEntry((Object)"key", (Object)"value");
        runContextProperty = new RunContextProperty(Property.builder().expression("{ \"key\": \"{{ key }}\"}").build(), runContext);
        Assertions.assertThat((Map)((Map)runContextProperty.asMap(String.class, String.class, Map.of("key", "value")))).containsEntry((Object)"key", (Object)"value");
    }

    @Test
    void asShouldReturnCachedRenderedProperty() throws IllegalVariableEvaluationException {
        RunContext runContext = this.runContextFactory.of();
        RunContextProperty runContextProperty = new RunContextProperty(Property.builder().expression("{{ variable }}").build(), runContext);
        Assertions.assertThat((Optional)runContextProperty.as(String.class, Map.of("variable", "value1"))).isEqualTo(Optional.of("value1"));
        Assertions.assertThat((Optional)runContextProperty.as(String.class, Map.of("variable", "value2"))).isEqualTo(Optional.of("value1"));
    }

    @Test
    void asShouldNotReturnCachedRenderedPropertyWithSkipCache() throws IllegalVariableEvaluationException {
        RunContext runContext = this.runContextFactory.of();
        RunContextProperty runContextProperty = new RunContextProperty(Property.builder().expression("{{ variable }}").build(), runContext);
        Assertions.assertThat((Optional)runContextProperty.as(String.class, Map.of("variable", "value1"))).isEqualTo(Optional.of("value1"));
        RunContextProperty skippedCache = runContextProperty.skipCache();
        Assertions.assertThat((Optional)skippedCache.as(String.class, Map.of("variable", "value2"))).isEqualTo(Optional.of("value2"));
        Assertions.assertThat((Optional)skippedCache.as(String.class, Map.of("variable", "value3"))).isEqualTo(Optional.of("value3"));
    }

    @Test
    void asShouldNotReturnCachedRenderedPropertyWithOfExpression() throws IllegalVariableEvaluationException {
        RunContext runContext = this.runContextFactory.of();
        RunContextProperty runContextProperty = new RunContextProperty(Property.ofExpression((String)"{{ variable }}"), runContext);
        Assertions.assertThat((Optional)runContextProperty.as(String.class, Map.of("variable", "value1"))).isEqualTo(Optional.of("value1"));
        Assertions.assertThat((Optional)runContextProperty.as(String.class, Map.of("variable", "value2"))).isEqualTo(Optional.of("value2"));
    }
}

