/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.encryption.EncryptionService;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.Label;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.executions.metrics.Timer;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.flows.Type;
import io.kestra.core.models.flows.input.StringInput;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.PollingTriggerInterface;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.LocalFlowRepositoryLoader;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.runners.InputsTest;
import io.kestra.core.runners.ListenersTest;
import io.kestra.core.runners.PluginDefaultsCaseTest;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.runners.RunContextInitializer;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.runners.WorkerTrigger;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.tasks.test.SleepTrigger;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.micronaut.context.annotation.Value;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.TemporalOffset;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import org.slf4j.event.Level;
import reactor.core.publisher.Flux;

@KestraTest(startRunner=true)
@io.micronaut.context.annotation.Property(name="kestra.tasks.tmp-dir.path", value="/tmp/sub/dir/tmp/")
class RunContextTest {
    @Inject
    @Named(value="workerTaskLogQueue")
    QueueInterface<LogEntry> workerTaskLogQueue;
    @Inject
    PluginDefaultsCaseTest pluginDefaultsCaseTest;
    @Inject
    RunContextFactory runContextFactory;
    @Inject
    RunContextInitializer runContextInitializer;
    @Inject
    StorageInterface storageInterface;
    @Inject
    MetricRegistry metricRegistry;
    @Value(value="${kestra.encryption.secret-key}")
    private String secretKey;
    @Inject
    @Named(value="workerTaskLogQueue")
    private QueueInterface<LogEntry> logQueue;
    @Inject
    private FlowInputOutput flowIO;
    @Inject
    private TestRunnerUtils runnerUtils;
    @Inject
    protected LocalFlowRepositoryLoader repositoryLoader;

    RunContextTest() {
    }

    @Test
    @LoadFlows(value={"flows/valids/logs.yaml"})
    void logs() throws TimeoutException, QueueException {
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(this.workerTaskLogQueue, either -> logs.add((LogEntry)either.getLeft()));
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "logs");
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
        LogEntry matchingLog = TestsUtils.awaitLog(logs, log -> Objects.equals(log.getTaskRunId(), ((TaskRun)execution.getTaskRunList().getFirst()).getId()));
        Assertions.assertThat((Object)matchingLog).isNotNull();
        Assertions.assertThat((Comparable)matchingLog.getLevel()).isEqualTo((Object)Level.TRACE);
        Assertions.assertThat((String)matchingLog.getMessage()).isEqualTo("first t1");
        matchingLog = TestsUtils.awaitLog(logs, log -> Objects.equals(log.getTaskRunId(), ((TaskRun)execution.getTaskRunList().get(1)).getId()));
        Assertions.assertThat((Object)matchingLog).isNotNull();
        Assertions.assertThat((Comparable)matchingLog.getLevel()).isEqualTo((Object)Level.WARN);
        Assertions.assertThat((String)matchingLog.getMessage()).isEqualTo("second io.kestra.plugin.core.log.Log");
        matchingLog = TestsUtils.awaitLog(logs, log -> Objects.equals(log.getTaskRunId(), ((TaskRun)execution.getTaskRunList().get(2)).getId()));
        Assertions.assertThat((Object)matchingLog).isNotNull();
        Assertions.assertThat((Comparable)matchingLog.getLevel()).isEqualTo((Object)Level.ERROR);
        Assertions.assertThat((String)matchingLog.getMessage()).isEqualTo("third logs");
        matchingLog = TestsUtils.awaitLog(logs, log -> Objects.equals(log.getTaskRunId(), ((TaskRun)execution.getTaskRunList().get(3)).getId()));
        receive.blockLast();
        Assertions.assertThat((Object)matchingLog).isNull();
    }

    @Test
    @LoadFlows(value={"flows/valids/inputs-large.yaml"})
    void inputsLarge() throws TimeoutException, QueueException {
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(this.workerTaskLogQueue, either -> logs.add((LogEntry)either.getLeft()));
        char[] chars = new char[16384];
        Arrays.fill(chars, 'a');
        HashMap<String, Object> inputs = new HashMap<String, Object>(InputsTest.inputs);
        inputs.put("string", new String(chars));
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "inputs-large", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, inputs));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(10);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.getTaskRunList().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        List logEntries = TestsUtils.awaitLogs(logs, logEntry -> logEntry.getTaskRunId() != null && logEntry.getTaskRunId().equals(((TaskRun)execution.getTaskRunList().get(1)).getId()), count -> count > 3);
        receive.blockLast();
        logEntries.sort(Comparator.comparingLong(value -> value.getTimestamp().toEpochMilli()));
        Assertions.assertThat((long)((LogEntry)logEntries.getFirst()).getTimestamp().toEpochMilli()).isEqualTo(((LogEntry)logEntries.get(1)).getTimestamp().toEpochMilli());
    }

    @Test
    @ExecuteFlow(value="flows/valids/return.yaml")
    void variables(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((ZonedDateTime)ZonedDateTime.parse((String)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"value"))).isCloseTo(ZonedDateTime.now(), (TemporalOffset)Assertions.within((long)10L, (TemporalUnit)ChronoUnit.SECONDS));
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().get(1)).getOutputs().get((Object)"value")).isEqualTo((Object)"task-id");
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().get(2)).getOutputs().get((Object)"value")).isEqualTo((Object)"return");
    }

    @Test
    void taskDefaults() throws TimeoutException, QueueException, IOException, URISyntaxException {
        this.repositoryLoader.load(Objects.requireNonNull(ListenersTest.class.getClassLoader().getResource("flows/tests/plugin-defaults.yaml")));
        this.pluginDefaultsCaseTest.taskDefaults();
    }

    @Test
    void largeInput() throws IOException, InterruptedException {
        RunContext runContext = this.runContextFactory.of();
        Path path = runContext.workingDir().createTempFile();
        long size = 0x40000000L;
        Process p = Runtime.getRuntime().exec(new String[]{"dd", "if=/dev/zero", String.format("of=%s", path), "bs=1", "count=1", String.format("seek=%s", size)});
        p.waitFor();
        p.destroy();
        URI uri = runContext.storage().putFile(path.toFile());
        Assertions.assertThat((long)this.storageInterface.getAttributes("main", null, uri).getSize()).isEqualTo(size + 1L);
    }

    @Test
    void metricsIncrement() {
        RunContext runContext = this.runContextFactory.of();
        Counter counter = Counter.of((String)"counter", (String)"Some counter", (Double)12.0, (String[])new String[0]);
        runContext.metric((AbstractMetricEntry)counter);
        runContext.metric((AbstractMetricEntry)Counter.of((String)"counter", (String)"Some counter", (Double)30.0, (String[])new String[0]));
        Timer timer = Timer.of((String)"duration", (String)"Some duration", (Duration)Duration.ofSeconds(12L), (String[])new String[0]);
        runContext.metric((AbstractMetricEntry)timer);
        runContext.metric((AbstractMetricEntry)Timer.of((String)"duration", (String)"Some duration", (Duration)Duration.ofSeconds(30L), (String[])new String[0]));
        runContext.metric((AbstractMetricEntry)Counter.of((String)"counter", (Double)123.0, (String[])new String[]{"key", "value"}));
        runContext.metric((AbstractMetricEntry)Timer.of((String)"duration", (Duration)Duration.ofSeconds(123L), (String[])new String[]{"key", "value"}));
        Assertions.assertThat((Object)((AbstractMetricEntry)runContext.metrics().get(runContext.metrics().indexOf(counter))).getValue()).isEqualTo((Object)42.0);
        Assertions.assertThat((double)this.metricRegistry.counter("counter", null, new String[0]).count()).isEqualTo(42.0);
        Assertions.assertThat((Object)((AbstractMetricEntry)runContext.metrics().get(runContext.metrics().indexOf(timer))).getValue()).isEqualTo((Object)Duration.ofSeconds(42L));
        Assertions.assertThat((double)this.metricRegistry.timer("duration", null, new String[0]).totalTime(TimeUnit.SECONDS)).isEqualTo(42.0);
        Assertions.assertThat((Object)((AbstractMetricEntry)runContext.metrics().get(2)).getValue()).isEqualTo((Object)123.0);
        Assertions.assertThat((int)((AbstractMetricEntry)runContext.metrics().get(2)).getTags().size()).isEqualTo(1);
        Assertions.assertThat((Object)((AbstractMetricEntry)runContext.metrics().get(3)).getValue()).isEqualTo((Object)Duration.ofSeconds(123L));
        Assertions.assertThat((int)((AbstractMetricEntry)runContext.metrics().get(3)).getTags().size()).isEqualTo(1);
    }

    @Test
    void encrypt() throws GeneralSecurityException {
        RunContext runContext = this.runContextFactory.of();
        String plainText = "toto";
        String encrypted = runContext.encrypt(plainText);
        String decrypted = EncryptionService.decrypt((String)this.secretKey, (String)encrypted);
        Assertions.assertThat((String)encrypted).isNotEqualTo((Object)plainText);
        Assertions.assertThat((String)decrypted).isEqualTo(plainText);
    }

    @Test
    @ExecuteFlow(value="flows/valids/encrypted-string.yaml")
    void encryptedStringOutput(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        TaskRun hello = (TaskRun)execution.findTaskRunsByTaskId("hello").getFirst();
        Map valueOutput = (Map)hello.getOutputs().get((Object)"value");
        Assertions.assertThat((int)valueOutput.size()).isEqualTo(2);
        Assertions.assertThat((String)((String)valueOutput.get("type"))).isEqualTo("io.kestra.datatype:aes_encrypted");
        Assertions.assertThat((String)((String)valueOutput.get("value"))).isNotEqualTo((Object)"Hello World");
        TaskRun returnTask = (TaskRun)execution.findTaskRunsByTaskId("return").getFirst();
        Assertions.assertThat((Object)returnTask.getOutputs().get((Object)"value")).isEqualTo((Object)"Hello World");
    }

    @Test
    void withDefaultInput() throws IllegalVariableEvaluationException {
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id("triggerWithDefaultInput")).namespace("io.kestra.test")).revision(Integer.valueOf(1))).inputs(List.of(((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("test")).type(Type.STRING)).defaults(Property.ofValue((Object)"test"))).build()))).build();
        Execution execution = Execution.builder().id(IdUtils.create()).flowId("triggerWithDefaultInput").namespace("io.kestra.test").state(new State()).build();
        RunContext runContext = this.runContextFactory.of((FlowInterface)flow, execution);
        Assertions.assertThat((String)runContext.render("{{inputs.test}}")).isEqualTo("test");
    }

    @Test
    void withNullLabel() throws IllegalVariableEvaluationException {
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id("triggerWithDefaultInput")).namespace("io.kestra.test")).revision(Integer.valueOf(1))).inputs(List.of(((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("test")).type(Type.STRING)).defaults(Property.ofValue((Object)"test"))).build()))).build();
        Execution execution = Execution.builder().id(IdUtils.create()).flowId("triggerWithDefaultInput").namespace("io.kestra.test").state(new State()).labels(List.of(new Label("key", null), new Label(null, "value"))).build();
        RunContext runContext = this.runContextFactory.of((FlowInterface)flow, execution);
        Assertions.assertThat((String)runContext.render("{{inputs.test}}")).isEqualTo("test");
    }

    @Test
    void renderMap() throws IllegalVariableEvaluationException {
        RunContext runContext = this.runContextFactory.of(Map.of("key", "default", "value", "default"));
        Map rendered = runContext.renderMap(Map.of("{{key}}", "{{value}}"));
        Assertions.assertThat((String)((String)rendered.get("default"))).isEqualTo("default");
        rendered = runContext.renderMap(Map.of("{{key}}", "{{value}}"), Map.of("key", "key", "value", "value"));
        Assertions.assertThat((String)((String)rendered.get("key"))).isEqualTo("value");
    }

    @Test
    @EnabledIfEnvironmentVariable(named="SECRET_PASSWORD", matches=".*")
    void secretTrigger() throws IllegalVariableEvaluationException {
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(this.logQueue, either -> logs.add((LogEntry)either.getLeft()));
        AbstractTrigger trigger = ((LogTrigger.LogTriggerBuilder)((Object)((LogTrigger.LogTriggerBuilder)((LogTrigger.LogTriggerBuilder)LogTrigger.builder().type(SleepTrigger.class.getName())).id("unit-test")).format("john {{ secret('PASSWORD') }} doe"))).build();
        Map.Entry mockedTrigger = TestsUtils.mockTrigger((RunContextFactory)this.runContextFactory, (AbstractTrigger)trigger);
        WorkerTrigger workerTrigger = WorkerTrigger.builder().trigger(trigger).triggerContext((Trigger)mockedTrigger.getValue()).conditionContext((ConditionContext)mockedTrigger.getKey()).build();
        RunContext runContext = this.runContextInitializer.forWorker((DefaultRunContext)workerTrigger.getConditionContext().getRunContext(), workerTrigger);
        trigger.evaluate(((ConditionContext)mockedTrigger.getKey()).withRunContext(runContext), (TriggerContext)mockedTrigger.getValue());
        List matchingLog = TestsUtils.awaitLogs(logs, (Integer)3);
        receive.blockLast();
        Assertions.assertThat((String)Objects.requireNonNull(matchingLog.stream().filter(logEntry -> logEntry.getLevel().equals((Object)Level.INFO)).findFirst().orElse(null)).getMessage()).isEqualTo("john ****** doe");
    }

    @Test
    void shouldValidateABean() {
        DefaultRunContext runContext = this.runContextInitializer.forExecutor((DefaultRunContext)this.runContextFactory.of());
        TestBean testBean = new TestBean("someValue");
        runContext.validate((Object)testBean);
    }

    @Test
    void shouldFailValidateABean() {
        DefaultRunContext runContext = this.runContextInitializer.forExecutor((DefaultRunContext)this.runContextFactory.of());
        TestBean testBean = new TestBean(null);
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> RunContextTest.lambda$shouldFailValidateABean$12((RunContext)runContext, testBean));
    }

    @Test
    @ExecuteFlow(value="flows/invalids/foreach-switch-failed.yaml")
    void failedTasksVariable(Execution execution) throws Exception {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        TaskRun taskRun = execution.getTaskRunList().stream().filter(tr -> tr.getTaskId().equals("errorforeach")).findFirst().orElseThrow(() -> new Exception("TaskRun not found"));
        Assertions.assertThat((boolean)taskRun.getOutputs().get((Object)"value").toString().contains("{\"state\":\"FAILED\",\"value\":\"2\",\"taskId\":\"switch\"}")).isEqualTo(true);
    }

    private static /* synthetic */ void lambda$shouldFailValidateABean$12(RunContext runContext, TestBean testBean) throws Throwable {
        runContext.validate((Object)testBean);
    }

    public static class LogTrigger
    extends AbstractTrigger
    implements PollingTriggerInterface {
        @PluginProperty
        @NotNull
        private String format;

        public Optional<Execution> evaluate(ConditionContext conditionContext, TriggerContext context) throws IllegalVariableEvaluationException {
            conditionContext.getRunContext().logger().info(conditionContext.getRunContext().render(this.format));
            return Optional.empty();
        }

        public Duration getInterval() {
            return null;
        }

        @Generated
        protected LogTrigger(LogTriggerBuilder<?, ?> b) {
            super(b);
            this.format = b.format;
        }

        @Generated
        public static LogTriggerBuilder<?, ?> builder() {
            return new LogTriggerBuilderImpl();
        }

        @Generated
        public String toString() {
            return "RunContextTest.LogTrigger(super=" + super.toString() + ", format=" + this.getFormat() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogTrigger)) {
                return false;
            }
            LogTrigger other = (LogTrigger)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$format = this.getFormat();
            String other$format = other.getFormat();
            return !(this$format == null ? other$format != null : !this$format.equals(other$format));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LogTrigger;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            return result;
        }

        @Generated
        public String getFormat() {
            return this.format;
        }

        @Generated
        public LogTrigger() {
        }

        @Generated
        public static abstract class LogTriggerBuilder<C extends LogTrigger, B extends LogTriggerBuilder<C, B>>
        extends AbstractTrigger.AbstractTriggerBuilder<C, B> {
            @Generated
            private String format;

            @Generated
            public B format(String format) {
                this.format = format;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "RunContextTest.LogTrigger.LogTriggerBuilder(super=" + super.toString() + ", format=" + this.format + ")";
            }
        }

        @Generated
        private static final class LogTriggerBuilderImpl
        extends LogTriggerBuilder<LogTrigger, LogTriggerBuilderImpl> {
            @Generated
            private LogTriggerBuilderImpl() {
            }

            @Override
            @Generated
            protected LogTriggerBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public LogTrigger build() {
                return new LogTrigger(this);
            }
        }
    }

    record TestBean(@NotNull String someValue) {
    }
}

