/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.DependsOn;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.GenericFlow;
import io.kestra.core.models.flows.Type;
import io.kestra.core.models.flows.input.BoolInput;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.property.PropertyContext;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.repositories.KvMetadataRepositoryInterface;
import io.kestra.core.runners.RunContextLogger;
import io.kestra.core.runners.RunVariables;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.runners.pebble.PebbleEngineFactory;
import io.kestra.core.services.KVStoreService;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.storages.kv.InternalKVStore;
import io.kestra.core.storages.kv.KVStore;
import io.kestra.core.storages.kv.KVValue;
import io.kestra.core.utils.IdUtils;
import io.micronaut.context.ApplicationContext;
import io.micronaut.test.annotation.MockBean;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@KestraTest
class RunVariablesTest {
    @Inject
    VariableRenderer renderer;
    @Inject
    StorageInterface storageInterface;
    @Inject
    KvMetadataRepositoryInterface kvMetadataRepository;

    RunVariablesTest() {
    }

    @MockBean(value=KVStoreService.class)
    KVStoreService testKVStoreService() {
        return new KVStoreService(){

            public KVStore get(String tenant, String namespace, @Nullable String fromNamespace) {
                return new InternalKVStore(this, tenant, namespace, RunVariablesTest.this.storageInterface, RunVariablesTest.this.kvMetadataRepository){

                    public Optional<KVValue> getValue(String key) {
                        return Optional.of(new KVValue((Object)"value"));
                    }
                };
            }
        };
    }

    @Test
    void shouldGetEmptyVariables() {
        Map variables = new RunVariables.DefaultBuilder().build(new RunContextLogger(), PropertyContext.create((VariableRenderer)this.renderer));
        Assertions.assertThat((int)variables.size()).isEqualTo(3);
        Assertions.assertThat((Map)((Map)variables.get("envs"))).isEqualTo(Map.of());
        Assertions.assertThat((Map)((Map)variables.get("globals"))).isEqualTo(Map.of());
        Assertions.assertThat(variables.get("addSecretConsumer")).isNotNull();
    }

    @Test
    void shouldGetVariablesGivenFlowWithNoTenant() {
        Map variables = new RunVariables.DefaultBuilder().withFlow((FlowInterface)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id("id-value")).namespace("namespace-value")).revision(Integer.valueOf(42))).build()).build(new RunContextLogger(), PropertyContext.create((VariableRenderer)this.renderer));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("id", "id-value", "namespace", "namespace-value", "revision", 42), variables.get("flow"));
    }

    @Test
    void shouldGetVariablesGivenFlowWithTenant() {
        Map variables = new RunVariables.DefaultBuilder().withFlow((FlowInterface)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id("id-value")).namespace("namespace-value")).revision(Integer.valueOf(42))).tenantId("tenant-value")).build()).build(new RunContextLogger(), PropertyContext.create((VariableRenderer)this.renderer));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("id", "id-value", "namespace", "namespace-value", "revision", 42, "tenantId", "tenant-value"), variables.get("flow"));
    }

    @Test
    void shouldGetVariablesGivenTask() {
        Map variables = new RunVariables.DefaultBuilder().withTask(new Task(this){

            public String getId() {
                return "id-value";
            }

            public String getType() {
                return "type-value";
            }
        }).build(new RunContextLogger(), PropertyContext.create((VariableRenderer)this.renderer));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("id", "id-value", "type", "type-value"), variables.get("task"));
    }

    @Test
    void shouldGetVariablesGivenTrigger() {
        Map variables = new RunVariables.DefaultBuilder().withTrigger(new AbstractTrigger(this){

            public String getId() {
                return "id-value";
            }

            public String getType() {
                return "type-value";
            }
        }).build(new RunContextLogger(), PropertyContext.create((VariableRenderer)this.renderer));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("id", "id-value", "type", "type-value"), variables.get("trigger"));
    }

    @Test
    void shouldGetKestraConfiguration() {
        Map variables = new RunVariables.DefaultBuilder().withKestraConfiguration(new RunVariables.KestraConfiguration("test", "http://localhost:8080")).build(new RunContextLogger(), PropertyContext.create((VariableRenderer)this.renderer));
        Assertions.assertThat((int)variables.size()).isEqualTo(4);
        Map kestra = (Map)variables.get("kestra");
        Assertions.assertThat((Map)kestra).hasSize(2);
        Assertions.assertThat(kestra.get("environment")).isEqualTo((Object)"test");
        Assertions.assertThat(kestra.get("url")).isEqualTo((Object)"http://localhost:8080");
    }

    @Test
    void nonResolvableDynamicInputsShouldBeSkipped() {
        VariableRenderer.VariableConfiguration mkVariableConfiguration = (VariableRenderer.VariableConfiguration)Mockito.mock(VariableRenderer.VariableConfiguration.class);
        ApplicationContext mkApplicationContext = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        Map variables = new RunVariables.DefaultBuilder().withFlow((FlowInterface)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("a.b")).id("c")).inputs(List.of(((BoolInput.BoolInputBuilder)((BoolInput.BoolInputBuilder)((BoolInput.BoolInputBuilder)BoolInput.builder().id("a")).type(Type.BOOL)).defaults(Property.ofValue((Object)true))).build(), ((BoolInput.BoolInputBuilder)((BoolInput.BoolInputBuilder)((BoolInput.BoolInputBuilder)((BoolInput.BoolInputBuilder)BoolInput.builder().id("b")).type(Type.BOOL)).dependsOn(new DependsOn(List.of("a"), null))).defaults(Property.ofExpression((String)"{{inputs.a == true}}"))).build()))).build()).withExecution(Execution.builder().id(IdUtils.create()).build()).build(new RunContextLogger(), PropertyContext.create((VariableRenderer)new VariableRenderer(new PebbleEngineFactory(mkApplicationContext, mkVariableConfiguration), mkVariableConfiguration)));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("a", true), variables.get("inputs"));
    }

    @Test
    void shouldBuildVariablesGivenFlowWithInputHavingDefaultPebbleExpression() {
        GenericFlow flow = GenericFlow.fromYaml((String)"main", (String)"id: id-value\nnamespace: namespace-value\ninputs:\n- id: input\n  type: STRING\n  defaults: \"{{ kv('???') }}\"\n");
        Map variables = new RunVariables.DefaultBuilder().withFlow((FlowInterface)flow).withExecution(Execution.builder().id(IdUtils.create()).build()).build(new RunContextLogger(), PropertyContext.create((VariableRenderer)this.renderer));
        Assertions.assertThat(variables.get("inputs")).isEqualTo(Map.of("input", "value"));
    }
}

