/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.Label;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;

@Singleton
public class SLATestCase {
    @Inject
    private TestRunnerUtils runnerUtils;

    public void maxDurationSLAShouldFail() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "sla-max-duration-fail");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    public void maxDurationSLAShouldPass() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "sla-max-duration-ok");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    public void executionConditionSLAShouldPass() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "sla-execution-condition");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    public void executionConditionSLAShouldCancel(String tenantId) throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne(tenantId, "io.kestra.tests", "sla-execution-condition", null, (f, e) -> Map.of("string", "CANCEL"));
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.CANCELLED);
    }

    public void executionConditionSLAShouldLabel(String tenantId) throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne(tenantId, "io.kestra.tests", "sla-execution-condition", null, (f, e) -> Map.of("string", "LABEL"));
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getLabels()).contains((Object[])new Label[]{new Label("sla", "violated")});
    }

    public void slaViolationOnSubflowMayEndTheParentFlow() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "sla-parent-flow");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }
}

