/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.assertj.core.api.Assertions;

@Singleton
public class ScheduleDateCaseTest {
    @Inject
    private FlowRepositoryInterface flowRepository;
    @Inject
    private TestRunnerUtils runnerUtils;

    public void shouldScheduleOnDate(String tenantId) throws QueueException {
        ZonedDateTime scheduleOn = ZonedDateTime.now().plusSeconds(1L);
        Flow flow = (Flow)this.flowRepository.findById(tenantId, "io.kestra.tests", "minimal").orElseThrow();
        Execution execution = Execution.newExecution((FlowInterface)flow, null, null, Optional.of(scheduleOn));
        Assertions.assertThat((Instant)execution.getScheduleDate()).isEqualTo((Object)scheduleOn.toInstant());
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.CREATED);
        this.runnerUtils.emitAndAwaitExecution(e -> e.getState().getCurrent().equals((Object)State.Type.SUCCESS), execution);
    }
}

