/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.SecureVariableRendererFactory;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.secret.SecretNotFoundException;
import io.kestra.core.secret.SecretService;
import io.micronaut.test.annotation.MockBean;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class SecureVariableRendererFactoryTest {
    @Inject
    private SecureVariableRendererFactory secureVariableRendererFactory;
    @Inject
    private VariableRenderer renderer;

    SecureVariableRendererFactoryTest() {
    }

    @MockBean(value=SecretService.class)
    SecretService testSecretService() {
        return new SecretService(this){

            public String findSecret(String tenantId, String namespace, String key) throws SecretNotFoundException, IOException {
                return switch (key) {
                    case "MY_SECRET" -> "my-secret-value-12345";
                    case "API_KEY" -> "api-key-value-67890";
                    case "DB_PASSWORD" -> "db-password-secret";
                    case "TOKEN" -> "token-value-abc123";
                    case "KEY1" -> "secret-value-1";
                    case "KEY2" -> "secret-value-2";
                    case "JSON_SECRET" -> "{\"api_key\": \"secret123\", \"token\": \"token456\"}";
                    default -> throw new SecretNotFoundException("Secret not found: " + key);
                };
            }
        };
    }

    @Test
    void shouldCreateDebugRenderer() {
        VariableRenderer debugRenderer = this.secureVariableRendererFactory.createOrGet();
        Assertions.assertThat((Object)debugRenderer).isNotNull();
    }

    @Test
    void shouldCreateDebugRendererThatIsNotSameAsBaseRenderer() {
        VariableRenderer debugRenderer = this.secureVariableRendererFactory.createOrGet();
        Assertions.assertThat((Object)debugRenderer).isNotSameAs((Object)this.renderer);
    }

    @Test
    void shouldCreateDebugRendererThatMasksSecrets() throws IllegalVariableEvaluationException {
        VariableRenderer debugRenderer = this.secureVariableRendererFactory.createOrGet();
        Map<String, Map<String, String>> context = Map.of("flow", Map.of("namespace", "io.kestra.unittest"));
        String result = debugRenderer.render("{{ secret('MY_SECRET') }}", context);
        Assertions.assertThat((String)result).isEqualTo("******");
        Assertions.assertThat((String)result).doesNotContain(new CharSequence[]{"my-secret-value-12345"});
    }

    @Test
    void shouldCreateDebugRendererThatMasksMultipleSecrets() throws IllegalVariableEvaluationException {
        VariableRenderer debugRenderer = this.secureVariableRendererFactory.createOrGet();
        Map<String, Map<String, String>> context = Map.of("flow", Map.of("namespace", "io.kestra.unittest"));
        String result = debugRenderer.render("API: {{ secret('API_KEY') }}, DB: {{ secret('DB_PASSWORD') }}, Token: {{ secret('TOKEN') }}", context);
        Assertions.assertThat((String)result).isEqualTo("API: ******, DB: ******, Token: ******");
        Assertions.assertThat((String)result).doesNotContain(new CharSequence[]{"api-key-value-67890"});
        Assertions.assertThat((String)result).doesNotContain(new CharSequence[]{"db-password-secret"});
        Assertions.assertThat((String)result).doesNotContain(new CharSequence[]{"token-value-abc123"});
    }

    @Test
    void shouldCreateDebugRendererThatDoesNotMaskNonSecretVariables() throws IllegalVariableEvaluationException {
        VariableRenderer debugRenderer = this.secureVariableRendererFactory.createOrGet();
        Map<String, Integer> context = Map.of("username", "testuser", "email", "test@example.com", "count", 42);
        String result = debugRenderer.render("User: {{ username }}, Email: {{ email }}, Count: {{ count }}", context);
        Assertions.assertThat((String)result).isEqualTo("User: testuser, Email: test@example.com, Count: 42");
    }

    @Test
    void shouldCreateDebugRendererThatMasksOnlySecretFunctions() throws IllegalVariableEvaluationException {
        VariableRenderer debugRenderer = this.secureVariableRendererFactory.createOrGet();
        Map<String, String> context = Map.of("flow", Map.of("namespace", "io.kestra.unittest"), "username", "testuser", "environment", "production");
        String result = debugRenderer.render("User: {{ username }}, Env: {{ environment }}, Secret: {{ secret('MY_SECRET') }}", context);
        Assertions.assertThat((String)result).isEqualTo("User: testuser, Env: production, Secret: ******");
        Assertions.assertThat((String)result).contains(new CharSequence[]{"testuser"});
        Assertions.assertThat((String)result).contains(new CharSequence[]{"production"});
        Assertions.assertThat((String)result).doesNotContain(new CharSequence[]{"my-secret-value-12345"});
    }

    @Test
    void shouldCreateDebugRendererThatHandlesMissingSecrets() {
        VariableRenderer debugRenderer = this.secureVariableRendererFactory.createOrGet();
        Map<String, Map<String, String>> context = Map.of("flow", Map.of("namespace", "io.kestra.unittest"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> debugRenderer.render("{{ secret('NON_EXISTENT_SECRET') }}", context)).isInstanceOf(IllegalVariableEvaluationException.class)).hasMessageContaining("Secret not found: NON_EXISTENT_SECRET");
    }

    @Test
    void shouldCreateDebugRendererThatMasksSecretsInComplexExpressions() throws IllegalVariableEvaluationException {
        VariableRenderer debugRenderer = this.secureVariableRendererFactory.createOrGet();
        Map<String, Map<String, String>> context = Map.of("flow", Map.of("namespace", "io.kestra.unittest"));
        String result = debugRenderer.render("{{ 'API Key: ' ~ secret('API_KEY') }}", context);
        Assertions.assertThat((String)result).isEqualTo("API Key: ******");
        Assertions.assertThat((String)result).doesNotContain(new CharSequence[]{"api-key-value-67890"});
    }

    @Test
    void shouldCreateDebugRendererThatMasksSecretsInConditionals() throws IllegalVariableEvaluationException {
        VariableRenderer debugRenderer = this.secureVariableRendererFactory.createOrGet();
        Map<String, Map<String, String>> context = Map.of("flow", Map.of("namespace", "io.kestra.unittest"));
        String result = debugRenderer.render("{{ secret('MY_SECRET') is defined ? 'Secret exists' : 'No secret' }}", context);
        Assertions.assertThat((String)result).isEqualTo("Secret exists");
        Assertions.assertThat((String)result).doesNotContain(new CharSequence[]{"my-secret-value-12345"});
    }

    @Test
    void shouldCreateDebugRendererThatMasksSecretsWithSubkeys() throws IllegalVariableEvaluationException {
        VariableRenderer debugRenderer = this.secureVariableRendererFactory.createOrGet();
        Map<String, Map<String, String>> context = Map.of("flow", Map.of("namespace", "io.kestra.unittest"));
        String result = debugRenderer.render("{{ secret('JSON_SECRET', subkey='api_key') }}", context);
        Assertions.assertThat((String)result).isEqualTo("******");
        Assertions.assertThat((String)result).doesNotContain(new CharSequence[]{"secret123"});
    }

    @Test
    void shouldCreateDebugRendererThatHandlesEmptyContext() throws IllegalVariableEvaluationException {
        VariableRenderer debugRenderer = this.secureVariableRendererFactory.createOrGet();
        Map emptyContext = Map.of();
        String result = debugRenderer.render("Hello World", emptyContext);
        Assertions.assertThat((String)result).isEqualTo("Hello World");
    }

    @Test
    void shouldCreateDebugRendererThatHandlesNullValues() throws IllegalVariableEvaluationException {
        VariableRenderer debugRenderer = this.secureVariableRendererFactory.createOrGet();
        Map<String, String> context = Map.of("value", "test");
        String result = debugRenderer.render("{{ value }}", context);
        Assertions.assertThat((String)result).isEqualTo("test");
    }

    @Test
    void shouldCreateDebugRendererThatMasksSecretsInNestedRender() throws IllegalVariableEvaluationException {
        VariableRenderer debugRenderer = this.secureVariableRendererFactory.createOrGet();
        Map<String, Map<String, String>> context = Map.of("flow", Map.of("namespace", "io.kestra.unittest"));
        String result = debugRenderer.render("{{ render('{{s'~'ecret(\"MY_SECRET\")}}') }}", context);
        Assertions.assertThat((String)result).isEqualTo("******");
        Assertions.assertThat((String)result).doesNotContain(new CharSequence[]{"my-secret-value-12345"});
    }
}

