/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.services.SkipExecutionService;
import io.kestra.core.utils.Await;
import io.kestra.core.utils.IdUtils;
import io.kestra.plugin.core.debug.Return;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;

@Singleton
public class SkipExecutionCaseTest {
    @Inject
    @Named(value="executionQueue")
    protected QueueInterface<Execution> executionQueue;
    @Inject
    protected TestRunnerUtils runnerUtils;
    @Inject
    private ExecutionRepositoryInterface executionRepository;
    @Inject
    private SkipExecutionService skipExecutionService;

    public void skipExecution() throws TimeoutException, QueueException {
        Flow flow = this.createFlow();
        Execution execution1 = Execution.newExecution((FlowInterface)flow, null, null, Optional.empty());
        String execution1Id = execution1.getId();
        this.skipExecutionService.setSkipExecutions(List.of(execution1Id));
        this.executionQueue.emit((Object)execution1);
        Execution execution2 = this.runnerUtils.runOne("main", "io.kestra.tests", "minimal");
        Assertions.assertThat((Comparable)execution2.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        execution1 = (Execution)Await.until(() -> this.executionRepository.findById("main", execution1Id).orElse(null), (Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(1L));
        Assertions.assertThat((Comparable)execution1.getState().getCurrent()).isEqualTo((Object)State.Type.CREATED);
    }

    private Flow createFlow() {
        return ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id(IdUtils.create())).tenantId("main")).namespace("io.kestra.unittest")).revision(Integer.valueOf(1))).tasks(Collections.singletonList(((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id("test")).type(Return.class.getName())).format(Property.ofExpression((String)"{{ inputs.testInputs }}")).build())).build();
    }
}

