/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
public class TaskCacheTest {
    static final AtomicInteger COUNTER = new AtomicInteger(0);
    @Inject
    private TestRunnerUtils runnerUtils;

    @BeforeEach
    void resetCounter() {
        COUNTER.set(0);
    }

    @Test
    @LoadFlows(value={"flows/valids/cache.yaml"})
    void shouldCacheTaskRunOutput() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "cache");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"counter")).isEqualTo((Object)1);
        Execution cached = this.runnerUtils.runOne("main", "io.kestra.tests", "cache");
        Assertions.assertThat((Comparable)cached.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((int)cached.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Object)((TaskRun)cached.getTaskRunList().getFirst()).getOutputs().get((Object)"counter")).isEqualTo((Object)1);
    }

    @Test
    @LoadFlows(value={"flows/valids/cache.yaml"})
    @Disabled(value="Expiration didn't work on CI for an unknown reason")
    void shouldExpireCacheTaskRunOutputAfterTtl() throws QueueException, TimeoutException, InterruptedException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "cache");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"counter")).isEqualTo((Object)1);
        Thread.sleep(1100L);
        Execution notCached = this.runnerUtils.runOne("main", "io.kestra.tests", "cache");
        Assertions.assertThat((Comparable)notCached.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((int)notCached.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Object)((TaskRun)notCached.getTaskRunList().getFirst()).getOutputs().get((Object)"counter")).isEqualTo((Object)2);
    }

    @Plugin
    public static class CounterTask
    extends Task
    implements RunnableTask<Output> {
        private String workingDir;

        public Output run(RunContext runContext) throws Exception {
            Map<String, String> variables = Map.of("workingDir", runContext.workingDir().path().toString());
            runContext.render(this.workingDir, variables);
            return ((Output.OutputBuilder)Output.builder().counter(COUNTER.incrementAndGet())).build();
        }

        @Generated
        protected CounterTask(CounterTaskBuilder<?, ?> b) {
            super(b);
            this.workingDir = b.workingDir;
        }

        @Generated
        public static CounterTaskBuilder<?, ?> builder() {
            return new CounterTaskBuilderImpl();
        }

        @Generated
        public String toString() {
            return "TaskCacheTest.CounterTask(super=" + super.toString() + ", workingDir=" + this.getWorkingDir() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CounterTask)) {
                return false;
            }
            CounterTask other = (CounterTask)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$workingDir = this.getWorkingDir();
            String other$workingDir = other.getWorkingDir();
            return !(this$workingDir == null ? other$workingDir != null : !this$workingDir.equals(other$workingDir));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CounterTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $workingDir = this.getWorkingDir();
            result = result * 59 + ($workingDir == null ? 43 : $workingDir.hashCode());
            return result;
        }

        @Generated
        public String getWorkingDir() {
            return this.workingDir;
        }

        @Generated
        public CounterTask() {
        }

        public static class Output
        implements io.kestra.core.models.tasks.Output {
            private int counter;

            @Generated
            protected Output(OutputBuilder<?, ?> b) {
                this.counter = b.counter;
            }

            @Generated
            public static OutputBuilder<?, ?> builder() {
                return new OutputBuilderImpl();
            }

            @Generated
            public OutputBuilder<?, ?> toBuilder() {
                return new OutputBuilderImpl().$fillValuesFrom(this);
            }

            @Generated
            public int getCounter() {
                return this.counter;
            }

            @Generated
            public static abstract class OutputBuilder<C extends Output, B extends OutputBuilder<C, B>> {
                @Generated
                private int counter;

                @Generated
                protected B $fillValuesFrom(C instance) {
                    OutputBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                    return this.self();
                }

                @Generated
                private static void $fillValuesFromInstanceIntoBuilder(Output instance, OutputBuilder<?, ?> b) {
                    b.counter(instance.counter);
                }

                @Generated
                public B counter(int counter) {
                    this.counter = counter;
                    return this.self();
                }

                @Generated
                protected abstract B self();

                @Generated
                public abstract C build();

                @Generated
                public String toString() {
                    return "TaskCacheTest.CounterTask.Output.OutputBuilder(counter=" + this.counter + ")";
                }
            }

            @Generated
            private static final class OutputBuilderImpl
            extends OutputBuilder<Output, OutputBuilderImpl> {
                @Generated
                private OutputBuilderImpl() {
                }

                @Override
                @Generated
                protected OutputBuilderImpl self() {
                    return this;
                }

                @Override
                @Generated
                public Output build() {
                    return new Output(this);
                }
            }
        }

        @Generated
        public static abstract class CounterTaskBuilder<C extends CounterTask, B extends CounterTaskBuilder<C, B>>
        extends Task.TaskBuilder<C, B> {
            @Generated
            private String workingDir;

            @Generated
            public B workingDir(String workingDir) {
                this.workingDir = workingDir;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "TaskCacheTest.CounterTask.CounterTaskBuilder(super=" + super.toString() + ", workingDir=" + this.workingDir + ")";
            }
        }

        @Generated
        private static final class CounterTaskBuilderImpl
        extends CounterTaskBuilder<CounterTask, CounterTaskBuilderImpl> {
            @Generated
            private CounterTaskBuilderImpl() {
            }

            @Override
            @Generated
            protected CounterTaskBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public CounterTask build() {
                return new CounterTask(this);
            }
        }
    }
}

